#!/usr/bin/perl

###############################################################################
#
# _AFMsgDel.cgi - Delete messages from the Forum
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:53 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFMsgDel.cgi,v 1.30.2.4 2001/08/21 17:50:53 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "M_Init.pl";

# Turn off buffering - for the response page
$| = 1;

###############################################################################
#
# Process submitted data


$Class = $CGIQuery->param('fid');
$func = $CGIQuery->param('func');
$date = $CGIQuery->param('date');
$age = $CGIQuery->param('age');
$num = $CGIQuery->param('num');

if ($Class eq "") {
	&showErrorHTML("$CorF not specified");
	exit();
}
	
&lookupClass;
	
&loadColors($ColorQueryString);

&checkCookieGuest($CGIEnvUser, $C_authtype);

if ($CGIEnvUser eq "") {
	&showErrorBackHTML("You are not properly logged in. Please log in and come back.");
	exit();
}

&lookupUser($CGIEnvUser);

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !(&IS_FAC($U_Perms) && $C_ModDelete ne "0")) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

if ($func eq "domsgdel") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&doMsgsDel;
	
} elsif ($func eq "copypaste") {
	&parseCopyPaste;
	
} elsif ($func eq "gather") {
	
	################################
	# Print list of messages
	################################

	if ($date eq "NULL") {
		&showHeaderBackHTML("Choose the messages to retrieve above");
		exit();
	}
	
	# What's today?
	($tsec, $tmin, $thr, $tday, $tmon, $tyr, $tdow, $tdoy, $tdls) = localtime(time());
	$tmon += 1;
	
	$todaystart = time() - ($thr * 3600) - ($tmin * 60) - $tsec;
	$todayend = $todaystart + 86400;
	
	# Print out a header
	if ($date eq "ALL") {
		$head = "All Messages";
	} elsif ($date eq "Week") {
		$head = "Messages for the Past Week";
		$start = $todaystart - 86400 * 7;
		$end = $todayend;
	} elsif ($date eq "Today") {
		$head = "Messages for $date";
		$start = $todaystart;
		$end = $todayend;
	} elsif ($date ne "") {
		#($sec, $min, $hr, $day, $mon, $yr, $dow, $doy, $dls) = localtime($date);
		#$mon += 1;
		#if ($yr >= 100) { $yr = $yr - 100; }
		#$pdate = sprintf("%02d-%02d-%02d", $mon, $day, $yr);
		
		#$head = "Messages for $pdate";
		#$start = $date - ($hr * 3600) - ($min * 60) - $sec;
		#$end = $start + 86400;
		
		$head = "Messages for $date";
		$start = "Day";
		
		($Daymon, $Dayday, $Dayyear) = split(/\./, $date);
		$Daymon =~ s/^0//;
		$Dayday =~ s/^0//;
	} elsif ($age ne "") {
		if ($age eq "hours") {
			$subtract = $num * 3600;
		} elsif ($age eq "days") {
			$subtract = $num * 3600 * 24;
		} elsif ($age eq "weeks") {
			$subtract = $num * 3600 * 24 * 7;
		} else {
			$subtract = $num * 3600 * 24 * 365;
		}
		
		$oldnew = $CGIQuery->param('oldnew');
		if ($oldnew eq "older") {
			$start = 1;
			$end = time() - $subtract;
			$tex = "Older than"
		} else {
			$start = time() - $subtract;
			$end = time();
			$tex = "Newer than"
		}
		
		$head = "Messages " . $tex . " " . $num . " " . $age;
	}

	# Get the posts

	$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FALL";
	if (! -e $dbfile) {
		$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FNEW";
	}
	
	foreach (`$prtDB $dbfile -tbtree -a -q`) {
		# Ignore errors. May be caused by no data in database.
	
		($key, $value) = split(/\t/, $_);
		$value = &UnEscape($value);
	
		if ($date eq "ALL") {
			push (@keys, $key);
			push (@values, $value);
		} elsif ($start eq "Day") {
			($sec, $min, $hr, $day, $mon, $yr, $dow, $doy, $dls) = localtime($key);
			$mon += 1;
			if ($yr >= 100) {
				$yr = $yr - 100;
			}
			while(length($yr) < 2) {
				$yr = "0" . $yr;
			}
			
			if ($mon eq $Daymon && $day eq $Dayday && $yr eq $Dayyear) {
				push (@keys, $key);
				push (@values, $value);
			}
		} elsif ($key >= $start && $key <= $end) {
			push (@keys, $key);
			push (@values, $value);
		}
	}
	
	$helplink = "file=MessageDeleteCORP_Admin.html";
	$helplink .= "&anchor=DeleteMessageEdtFSummary";
	$helplink .= "&helptitle=Delete%20Message%20Editing%20Frame";
	
	&showHeaderBackHTML($head, "", 0, 0, 0, $helplink);
	
	# Print some javascript to select multiple boxes
	&printCheckSelJS;
	&printJavascript;
	&printAllMsgData;
	
##########################################################	
	
} elsif ($func eq "nothing" ) {

	&printEmptyTaskFrame("Choose the messages to retrieve in the frame above.");
	
} elsif ($func eq "menu") {
	$helplink = "file=MessageDeleteCORP_Admin.html";
	$helplink .= "&anchor=DeleteMessageTskFSummary";
	$helplink .= "&helptitle=Delete%20Messages%20Task%20Frame";

	&showHeaderBackHTML("Delete Messages from $CorF - $Class",
		"", 0, 1, 0, $helplink);
	
	&printResetJavascript;

	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	# Get the total number of posts
	$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_STATS";
	
	($key, $value) = split(/\t/, `$prtDB $dbfile -tbtree -k \"_Total\"`);
	
	print "<tr><td valign=middle align=left>";
	print $FontFace, $FontSize;
	print "There are $value Messages.";
	print "</td></tr>\n\n";
	
	# Start Form
	print "<form action=$CGIEnvScript method=POST target=msgdel>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n\n";
	print "<input type=hidden name=func value=gather>\n\n";
	
	print "<tr><td valign=middle align=left>";
	print $FontFace, $FontSize;
	print "Select Messages from: ";
	print "<select name=date>";
	print "<option value=Today> Today\n";
	print "<option value=Week> The Past Week\n";
	print "<option value=ALL> All Posts\n";
	print "<option value=NULL> --- By Day (Choose One Below) ---\n";
	
	# Need to get the date of the earliest post
	#$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FALL";
	#if (! -e $dbfile) {
	#	$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FNEW";
	#}
	
	#($key, $value) = split(/\t/, `$prtDB $dbfile -tbtree -f -q`);
	# Error means no posts yet. Ignore.
	
	#$now = time();
	#if ($key ne "") {
	#	for ($i = $now - 86400; $i > $key - 86400; $i=$i - 86400) {
	#		($sec, $min, $hr, $day, $mon, $yr, $dow, $doy, $dls) = localtime($i);
	#		$mon += 1;
	#		if ($yr >= 100) { $yr = $yr - 100; }
	#		$date = sprintf("%02d-%02d-%02d", $mon, $day, $yr);
	#		#$date = $mon . "-" . $day . "-" . $yr;
	#		
	#		print "<option value=$i> $date\n";
	#	}
	#}
	
	# Use stats databse to get dates
	foreach (`$prtDB $dbfile -tbtree -a`) {
		($DB_Key, $num, $test, @junk) = split(/\t/, $_);
		if ($test eq "" && $DB_Key =~ /\./ && $num > 0) {
			push(@dates, $DB_Key);
			$posts{"$DB_Key"} = $num;
		}
	}
	
	@dates = sort byDateReverse @dates;
	
	for ($i=0; $i < @dates; $i++) {
		print "<option value=\"", @dates[$i], "\"> ";
		print @dates[$i], " - (", $posts{"@dates[$i]"}, " Posts)\n";
	}
	
	print "</select>";
	print $BtnFormSubmit;
	print $BtnFormClear;
	
	print "</td></tr>\n\n";
	
	print "</form>\n";
	
	# Older than....
	print "<form action=$CGIEnvScript method=POST target=msgdel>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n\n";
	print "<input type=hidden name=func value=gather>\n\n";
	
	# Spacer/divider
	print "<tr><td>$ImgIndentSmall</td></tr>\n\n";
	print "<tr><td bgcolor=$FTheaderback>$ImgClearDot</td></tr>\n\n";
	print "<tr><td>$ImgIndentSmall</td></tr>\n\n";
	
	print "<tr><td valign=middle align=left>";
	print $FontFace, $FontSize;
	print "Select all messages ";
	
	print "<select name=oldnew>\n";
	print "<option value=older> Older Than \n";
	print "<option value=newer> Newer Than \n";
	print "</select>\n";
	
	print "<input name='num' type=text maxlength=6 size=6 value=10>\n";
	print "<select name='age'>\n";
	print "<option value='hours'> Hours\n";
	print "<option value='days'> Days\n";
	print "<option value='weeks'> Weeks\n";
	print "<option value='years'> Years\n";
	print "</select>\n";
	
	print $BtnFormSubmit;
	print $BtnFormClear;
	
	print "</td></tr>\n\n";
	
	print "</form>\n";
	
	# Copy and paste a message url
	
	print "<form action=$CGIEnvScript method=POST target=msgdel>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n\n";
	print "<input type=hidden name=func value=copypaste>\n\n";
	
	# Spacer/divider
	print "<tr><td>$ImgIndentSmall</td></tr>\n\n";
	print "<tr><td bgcolor=$FTheaderback>$ImgClearDot</td></tr>\n\n";
	print "<tr><td>$ImgIndentSmall</td></tr>\n\n";
	
	print "<tr><td valign=top>", $FontFace, $FontSize;
	print "Copy and paste the URL of a message here to select it for deletion.";
	print "<br>\n";
	print "<input type=text name=MsgDelURL size=60>\n";
	print $BtnFormSubmit;
	print $BtnFormClear;
	
	print "<br>";
	print "(e.g. /Forum/cgi-bin/FVwMsgThr.cgi?fid=Forum&tid=Practice&mid=12)\n";
	
	print "</td></tr>\n";
	
	print "</form>\n";

	print "</table>\n";
} else {

	# Print out frameset
	# print $CGIQuery->header(-expires=>'-1d');
	print $CGIQuery->header;
	print "<html><head><title>$Class Forum Message Deletion</title>\n";
	&printJavascript();
	print "</head>\n";
	print "<frameset rows='200,*' border=2>\n";
	print "	<frame name=msgdelmenu src=$CGIEnvScript?fid=$Class&func=menu ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=msgdel src=$CGIEnvScript?fid=$Class&func=nothing ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}

#
########

sub parseCopyPaste {
	$MsgDelURL = $CGIQuery->param('MsgDelURL');
	
	if ($MsgDelURL !~ /\?/) {
		&showErrorBackHTML("The URL did not contain a query string.");
		exit();
	}
	
	if ($MsgDelURL !~ /mid/) {
		&showErrorBackHTML("The URL did not contain a valid message ID (msgid)");
		exit();
	}
	
	if ($MsgDelURL !~ /tid/) {
		&showErrorBackHTML("The URL did not contain a valid topic specification (tid)");
		exit();
	}
	
	($junk, $qstring) = split(/\?/, $MsgDelURL);
	
	# Remove anchor
	$qstring =~ s/\#.*$//;
	
	$parseIt = new CGI($qstring);
	
	$id = $parseIt->param('mid');
	$subject = $parseIt->param('tid');
	
	if ($id =~ /\./) {
		@gettop = split(/\./, $id);
		$topid = @gettop[0];
	} else {
		$topid = $id;
	}

	$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$subject/$topid" . ".db";
	
	if (! -e $dbfile) {
		&showErrorBackHTML("The message database, $dbfile, was not found.");
		exit();
	}
	
	$value = "";

	($key, $value) = split(/\t/, `$prtDB $dbfile -tbtree -q -k \"$id\"`);
	$value = &UnEscape($value);
	chomp($value);
	
	$status = &dbErrorCheck($?, $key);
	
	if ($value eq "" || $status ne "") {
		&showErrorBackHTML("The selected message does not exist.");
		exit();
	}
	
	($II, $title, $poster, $posterperm, $posttime, @junk) = split(/\t/, $value);
	
	@keys[0] = $posttime;
	@values[0] = "$id\t$subject\t$title\t$poster\t$posterperm";
	
	$helplink = "file=MessageDeleteCORP_Admin.html";
	$helplink .= "&anchor=DeleteMessageEdtFSummary";
	$helplink .= "&helptitle=Delete%20Message%20Editing%20Frame";
	
	&showHeaderBackHTML("Selected Message", "", 0, 0, 0, $helplink);
	
	# print $value;
	
	&printCheckSelJS;
	&printJavascript;
	&printAllMsgData;
}

sub printAllMsgData {
	if (@keys > 0) {
		print "<form action=$CGIEnvScript method=POST>\n";
		print "<input type=hidden name=fid value=$Class>\n";
		print "<input type=hidden name=func value=domsgdel>\n";
	}
	
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	
	if (@keys > 0) {
		print "<tr bgcolor=$FCmsgheadhilight>";
		# Don't allow individual message deletion
		#print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		#print "&nbsp;Delete &nbsp;Msg$ImgIndent";
		#print "</td>\n";
	
		#print "<td width=1 bgcolor=$FCheaderback>";
		#print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Delete &nbsp;Msg<br>&nbsp;\& &nbsp;Replies$ImgIndent";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Delete &nbsp;Entire<br>&nbsp;Thread$ImgIndent";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Date$ImgIndent";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Topic$ImgIndent";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;Title$ImgIndent";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td bgcolor=$FCmsgheadhilight><b>", $FontFace, $FontSize2;
		print "&nbsp;User ID$ImgIndent";
		print "</td>\n";
		print "</tr>\n\n";
	
		print "<tr><td colspan=13 height=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td></tr>\n\n";
	}
	
	$U_PermsOrig = $U_Perms;
	
	for ($i=0; $i < @keys; $i++) {
		($msgid, $subject, $title, $poster, $posterperm) = split(/\t/, @values[$i]);
		$pdate = &formatDate(@keys[$i]);
		
		if ($i % 2) {
			$bg = " bgcolor=$FCmsghilight";
		} else {
			$bg = "";
		}
		
		$allowdel = 1;
		if (! &IS_ADMIN($U_PermsOrig)) {
			if (&IS_FAC($U_PermsOrig) && ($C_ModDeleteAll eq "0" || $C_ModDeleteAll eq "")) {
				# Have to check to see if this moderator can delete this post
				&lookupUser($poster);
				
				if ($U_C_Sect =~ /\:/) {
					($junk, $snum) = split(/\:/, $U_C_Sect);
				} else {
					$snum = $U_C_Sect;
				}
				if ($C_Sects{$snum}{"fac"} eq $CGIEnvUser) {
					$allowdel = 1;
				} else {
					$allowdel = 0;
				}
				
				if ($poster eq "Guest" || $poster eq "Anonymous") {
					$allowdel = 0;
				}
			}
		}
		
		print "<tr", $bg, ">";
		
		# Don't allow individual message deletion
		#print "<td align=center", $bg, ">", $FontFace, $FontSize;
		#if ($allowdel) {
		#	print "<input type=checkbox name=delmsg value=\"$msgid";
		#	print ":", $subject, "\">";
		#} else {
		#	print "&nbsp;";
		#}
		#print "</td>\n";
		
		#print "<td width=1 bgcolor=$FCheaderback>";
		#print "$ImgClearDot</td>\n";
		
		print "<td align=center", $bg, ">", $FontFace, $FontSize;
		if ($allowdel) {
			print "<input type=checkbox name=delchildren value=\"$msgid";
			print ":", $subject, "\">";
		} else {
			print "&nbsp;";
		}
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td align=center", $bg, ">", $FontFace, $FontSize;
		if ($allowdel) {
			print "<input type=checkbox name=delthread value=\"$msgid";
			print ":", $subject, "\">";
		} else {
			print "<img src=$ImgSrcClearDot width=5 height=16>";
		}
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, " nowrap>", $FontFace, $FontSize;
		print "&nbsp;", $pdate, $ImgIndent;
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, " nowrap>", $FontFace, $FontSize;
		print "&nbsp;<b>";
		print &printPretty(&unEscapeTopic($subject));
		print $ImgIndent;
		print "</b></td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, " nowrap>", $FontFace, $FontSize;
		print "&nbsp;";
		print "<a href=\"javascript:openwin('";
		print $CGI_ForumViewMsgThread, "?fid=$Class\&tid=$subject";
		print "\&mid=$msgid\#$msgid','600','400','msgview')\">";
		print $title, "</a>", $ImgIndent;
		print "</td>\n";
		
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td", $bg, ">", $FontFace, $FontSize;
		print "&nbsp;", $poster, $ImgIndent;
		print "</td>\n";
		
		print "</tr>\n\n";
		
	}
	
	if (@keys == 0) {
		# print "<tr><td colspan=13>";
		print "<tr><td colspan=11>";
		print "$ImgIndent</td></tr>\n\n";
	
		# print "<tr><td colspan=13>", $FontFace, $FontSize;
		print "<tr><td colspan=11>", $FontFace, $FontSize;
		print "No posts found in the selected range.</td></tr>\n\n";
	} elsif (@keys > 1) {
		#print "<tr><td colspan=13 height=1 bgcolor=$FCheaderback>";
		print "<tr><td colspan=11 height=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td></tr>\n\n";
		
		print "<tr>";
		
		# Don't allow individual message deletion
		#print "<td>", $FontFace, $FontSize;
		#print "&nbsp;<a href=javascript:selectAll('delmsg')>Select&nbsp;All</a>$ImgIndent";
		#print "<br>&nbsp;<a href=javascript:deselectAll('delmsg')>Deselect&nbsp;All</a>";
		#print "<br>&nbsp;<a href=javascript:selectInverse('delmsg')>Select&nbsp;Inverse</a>";
		#print "</td>\n";
	
		#print "<td width=1 bgcolor=$FCheaderback>";
		#print "$ImgClearDot</td>\n";
	
		print "<td>", $FontFace, $FontSize;
		print "&nbsp;<a href=javascript:selectAll('delchildren')>Select&nbsp;All</a>$ImgIndent";
		print "<br>&nbsp;<a href=javascript:deselectAll('delchildren')>Deselect&nbsp;All</a>";
		print "<br>&nbsp;<a href=javascript:selectInverse('delchildren')>Select&nbsp;Inverse</a>";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
	
		print "<td>", $FontFace, $FontSize;
		print "&nbsp;<a href=javascript:selectAll('delthread')>Select&nbsp;All</a>$ImgIndent";
		print "<br>&nbsp;<a href=javascript:deselectAll('delthread')>Deselect&nbsp;All</a>";
		print "<br>&nbsp;<a href=javascript:selectInverse('delthread')>Select&nbsp;Inverse</a>";
		print "</td>\n";
	
		print "<td width=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td>\n";
		
		print "<td colspan=7>";
		print "$ImgClearDot</td></tr>\n\n";
		
		print "<tr><td colspan=13 height=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td></tr>\n\n";
	} else {
		# print "<tr><td colspan=13 height=1 bgcolor=$FCheaderback>";
		print "<tr><td colspan=11 height=1 bgcolor=$FCheaderback>";
		print "$ImgClearDot</td></tr>\n\n";
	}
	
	if (! &IS_ADMIN($U_PermsOrig) && @keys > 0) {
		# print "<tr><td colspan=13>", $FontFace, $FontSize;
		print "<tr><td colspan=11>", $FontFace, $FontSize;
		print "<br>$FontRed Note:</font>\n";
		print "If there are no checkboxes next to a post, ";
		print "it means you do not have permission to delete that post.\n";
		print "</td></tr>\n";
	}
	
	if (@keys > 0) {
		# print "<tr><td colspan=13>", $FontFace, $FontSize;
		print "<tr><td colspan=11>", $FontFace, $FontSize;
		if (&IS_ADMIN($U_PermsOrig)) {
			print "<br>";
		}
		print "$FontRed Note:</font>\n";
		print "Click the title to view the post content.\n";
		print "<br>&nbsp;</td></tr>\n";
	}
	
	print "</table>\n";
	
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "</form>\n";
}

sub doMsgsDel {
	local($i, $j);

	@delmsg = $CGIQuery->param('delmsg');
	@delchildren = $CGIQuery->param('delchildren');
	@delthread = $CGIQuery->param('delthread');

	$delmsg = "," . join(",", @delmsg) . ",";
	$delchildren = "," . join(",", @delchildren) . ",";
	$delthread = "," . join(",", @delthread) . ",";
	
	&showHeaderBackHTML("Deleting Messages");
	
	# Turn on signal Handling
	# Once we start deleting, we really need to finish it all
	$trapSignals = 1;
	
	# Start with the threads
	$threadstodel = ",";
	for ($i=0; $i < @delthread; $i++) {
	
		($msgid, $subject) = split(/\:/, @delthread[$i]);
		if ($msgid =~ /\./) {
			@gettop = split(/\./, $msgid);
			$topid = @gettop[0];
		} else {
			$topid = $msgid;
		}
		
		if ($threadstodel =~ /\,$topid\,/) {
			next;
		}
		
		print "Deleting Thread: $topid<br>\n";
		
		$threadstodel .= $topid . ",";
		
		$command = $delMsgThread . " " . $C_rootpath . " " . $subject . " " . $topid;
		@retval = `$command`;
		
		$status = &dbErrorCheck($?, @retval[0]);
		
		if ($status) {
			print "$status: Couldn't Delete ID $msgid<br>\n";
		}
		
		#$what = "thread";
		
		#&delFromMsg($subject, $topid, $what);
		#&delFromSubjThreads($subject, $topid, $what);
		#&delFromAuth($subject, $topid, $what, "global");
		#&delFromAuth($subject, $topid, $what, "local");
		#&delFromReplies($topid, $what);
		#&delFromNew($topid, $what);
	}
	
	# Now delete messages and replies
	$childtodel = ",";
	for ($i=0; $i < @delchildren; $i++) {
	
		($msgid, $subject) = split(/\:/, @delchildren[$i]);
		if ($msgid =~ /\./) {
			@gettop = split(/\./, $msgid);
			$topid = @gettop[0];
		} else {
			$topid = $msgid;
		}
		
		if ($threadstodel =~ /\,$topid\,/ || $childtodel =~ /\,$msgid[\,\.]/) {
			next;
		}
		
		print "Deleting Message and Replies: $msgid<br>\n";
		
		$childtodel .= $msgid . ",";
		
		$command = $delMsgThread . " " . $C_rootpath . " " . $subject . " " . $msgid;
		@retval = `$command`;
		
		$status = &dbErrorCheck($?, @retval[0]);
		
		if ($status) {
			print "$status: Couldn't Delete ID $msgid<br>\n";
		}
		
		#$what = "children";
		
		#&delFromMsg($subject, $msgid, $what);
		#&delFromSubjThreads($subject, $msgid, $what);
		#&delFromAuth($subject, $msgid, $what, "global");
		#&delFromAuth($subject, $msgid, $what, "local");
		#&delFromReplies($msgid, $what);
		#&delFromNew($msgid, $what);
	}
	
	# Finally individual messages
	for ($i=0; $i < @delmsg; $i++) {
	
		($msgid, $subject) = split(/\:/, @delmsg[$i]);
		if ($msgid =~ /\./) {
			@gettop = split(/\./, $msgid);
			$topid = @gettop[0];
		} else {
			$topid = $msgid;
		}
		
		if ($threadstodel =~ /\,$topid\,/ || $childtodel =~ /\,$msgid[\,\.]/) {
			next;
		}
		
		print "Deleting Message: $msgid<br>\n";
		
		# This is currently not allowed, and won;'t work
		#$command = $delMsgThread . " " . $C_rootpath . " " . $subject . " " . $topid;
		#@retval = `$command`;
		
		#print @retval, "<br>\n";
		
		$what = "single";
		
		&delFromMsg($subject, $msgid, $what);
		&delFromSubjThreads($subject, $msgid, $what);
		&delFromAuth($subject, $msgid, $what, "global");
		&delFromAuth($subject, $msgid, $what, "local");
		&delFromReplies($msgid, $what);
		&delFromNew($msgid, $what);
	}
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	print "<p>Finished!\n";
	
}


sub byDate {
	($mon1, $day1, $yr1) = split(/\./, $::a);
	($mon2, $day2, $yr2) = split(/\./, $::b);
	
	$mon1 =~ s/^0//;
	$day1 =~ s/^0//;
	$mon2 =~ s/^0//;
	$day2 =~ s/^0//;
	
	if ($yr1 < 70) { $yr1 += 100; }
	if ($yr2 < 70) { $yr2 += 100; }
	
	if ($yr1 != $yr2) {
		return ($yr1 <=> $yr2);
	}
	if ($mon1 != $mon2) {
		return ($mon1 <=> $mon2);
	}
	return ($day1 <=> $day2);
}

sub byDateReverse {
	($mon1, $day1, $yr1) = split(/\./, $::a);
	($mon2, $day2, $yr2) = split(/\./, $::b);
	
	$mon1 =~ s/^0//;
	$day1 =~ s/^0//;
	$mon2 =~ s/^0//;
	$day2 =~ s/^0//;
	
	if ($yr1 < 70) { $yr1 += 100; }
	if ($yr2 < 70) { $yr2 += 100; }
	
	if ($yr1 != $yr2) {
		return ($yr2 <=> $yr1);
	}
	if ($mon1 != $mon2) {
		return ($mon2 <=> $mon1);
	}
	return ($day2 <=> $day1);
}
