#!/usr/local/bin/perl

# panFora initialization script.
# Copyright wiTHinc 1999

use Config;

# $< is the numerical user id
$uid = getpwuid($<);

# Perl version
$version = $];

print "This updater will walk you through the steps required to update\n";
print "the panFora system. You may need to be logged in as root during\n";;
print "the update process.\n\n";

print "This installer will ask you several questions. Defaults will be\n";
print "provided in brackets after each question (e.g. [YES]). Just hit\n";
print "the enter key to accept the default, or you can type in a different\n";
print "value.\n\n";

print "Press the Enter key to continue. ";
&readinput;
print "\n";

# Is this person root?
$isroot = ($uid eq "root");

if (! $isroot) {
	print "You are not logged in as root. Would you like to continue with\n";
	print "the installation anyway (Y/N)? [N]: ";
	if ( ! &yesno("N")) {
		&doCancel;
	}
}

print "\n";

# Perl path
$perlpath = @ARGV[0];
if ($perlpath eq "") {
	$perlpath = $Config{"perlpath"};
	
	if ($perlpath !~ /perl/i) {
		$perlpath = "/usr/local/bin/perl";
	}
	
	$vers = 0;
	while ($vers < 5) {
		print "Please enter the full path to your perl interpreter [$perlpath]: ";
		$perlloc = &readinput;
		
		if ($perlloc eq "") {
			$perlloc = $perlpath;
		}
	
		$vers = `$perlloc \-e "print $]"`;
	}
	$perlpath = $perlloc;
} else {
	$vers = 0;
	while ($vers < 5) {
		print "Please enter the full path to your perl interpreter [$perlpath]: ";
		$perlloc = &readinput;
		
		if ($perlloc eq "") {
			$perlloc = $perlpath;
		}
	
		$vers = `$perlloc \-e "print $]"`;
	}
	$perlpath = $perlloc;
}

$vers = `$perlpath \-e "print $]"`;

# Run fixperl to change #!/usr/local/bin/perl to what it should be in
# all programs.

print "Changing the loction of perl in all programs.\n";
print "Using perl version $vers at $perlpath...\n\n";
print "Press Enter to continue. ";
&readinput;
print "\n";

@results = `$perlpath ./fixperl.pl PerlFileList $perlpath`;
for ($i=0; $i < @results; $i++) {
	if (@results[$i] !~ /skipping/i) {
		print @results[$i];
	}
}
print "\nFinished changing perl location in all programs.\n\n";


# Where is the current panFora installation?
print "Please enter the location of the panFora installation on your system.\n";

print "Location of panFora []: ";
$sm = &readinput;

if ($sm !~ /\/$/) {
	$sm .= "/";
}

while (! -e $sm || ! -d $sm || ! -e $sm . "Forum.cgi") {
	print "The specified location was invalid.\n";
	print "Location of panFora [$sm]: ";
	$sm2 = &readinput;
	if ($sm2 ne "") {
		$sm = $sm2;
	}
	if ($sm !~ /\/$/) {
		$sm .= "/";
	}
}
print "\n";

print "Updating Files...\n";

@files = glob("*");
for ($i=0; $i < @files; $i++) {
	if (@files[$i] ne "update.pl" && @files[$i] ne "update" && @files[$i] ne "fixperl.pl" && @files[$i] ne "PerlFileList") {
		&copy(@files[$i], $sm . @files[$i]);
	}
}

print "\npanFora initialization finished!\n\n";

# Subroutines
sub yesno {
	local($default) = @_;
	local($response) = &readinput;
	
	if ($response eq "") {
		$response = $default;
	}
	if ($response =~ /^y/i) {
		return(1);
	}
	
	return(0);
}

sub readinput {
	local($linein);
	
	chomp($linein = <STDIN>);
	return($linein);
}

sub doCancel {
	print "\n*** Installation Cancelled ***\n\n";
	exit;
}

sub warnOwnership {
	print "It was not possible to change onwnership of the panFora files.\n";
	print "In order for the system to work, the panFora directory has been\n";
	print "made world writable. This action could be considered a security\n";
	print "hazard. It is recommended that you change the ownership of all\n";
	print "files in the panFora directory to the User ID of the web server.\n";
	print "Then you can remove world write permission from the panFora\n";
	print "directory. You will need to be logged in as root to change the\n";
	print "ownership as required.\n\n";
}

sub getPassword {
	print "Password: ";
	$pass1 = &readinput;
	print "Verify Password: ";
	$pass2 = &readinput;
	
	if ($pass1 ne $pass2) {
		print "\nThe passwords you entered do not match. Try again.\n\n";
		&getPassword;
	}
	
	return $pass1;
}

sub setPassword {
	local($pass) = @_;
	
	require "_STR.pl";
	
	$pw = &cryptPass($pass);
        
	open(f, ">./.forumadmin");
	print f $pw;
	close(f);

}

sub copy {
	# copy a file
	local($src, $target) = @_;
	if (!open(sf, $src)) {
		print "Couldn't open the file, $src, for reading. Does it exist?\n\n";
		print "Update aborted!!!\n\n";
		exit();
	}
	binmode(sf);
	@sd = <sf>;
	close(sf);
	
	if (!open(tf, ">$target")) {
		print "Couldn't write to file, $target. Check file permissions and try again.";
		print "Update aborted!!!\n\n";
		exit();
	}
	binmode(tf);
	print tf @sd;
	close(tf);
}

