#!/usr/bin/perl

###############################################################################
#
# _STR.pl - an include file for perl...
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/09/06 17:17:48 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _STR.pl,v 1.26.2.3 2001/09/06 17:17:48 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

1;

sub cleanHTML {
	local ($var) = @_;
	$var =~ s/\>/\&gt\;/g;
	$var =~ s/\</\&lt\;/g;
	return($var);
}

sub makeHTML {
	local ($var) = @_;
	$var =~ s/\r//g;
	# $var =~ s/\n/\<br\>\n/g;
	$tmpfile = time();
	while (-e $tmpfile) {
		$tmpfile += 10;
	}
	open(safe, "| $mkHTML -f $tmpfile");
	print safe $var;
	close(safe);
	
	open(safe, "$tmpfile");
	$var = join("", <safe>);
	close(safe);
	
	unlink($tmpfile);
	
	return($var);
}

sub safeHTML {
	local ($var) = @_;

	$tmpfile = time();
	while (-e $tmpfile) {
		$tmpfile += 10;
	}
	open(safe, "| $safehtml -f $tmpfile");
	print safe $var;
	close(safe);
	
	open(safe, "$tmpfile");
	$var = join("", <safe>);
	close(safe);
	
	unlink($tmpfile);
	
	return($var);
}

sub cleanTabs {
	local ($var) = @_;
	$var =~ s/\t/    /g;
	return($var);
}

sub cleanNonAlpha {
	local ($var) = @_;
	# $var =~ s/[^a-zA-Z0-9_\-\:]+//g;
	$var =~ s/[^a-zA-Z0-9_\-]+//g;
	return($var);
}

sub cleanWinPath {
	local ($var) = @_;
	$var =~ s/[^a-zA-Z0-9_\-\.\/\:\\]+//g;
	# Replace all backslashes with forward slashes
	$var =~ s/\\/\//g;
	return($var);
}

sub replaceNonAlpha {
	local ($var) = @_;
	$var =~ s/[^a-zA-Z0-9_\-\.\/\:]+/_/g;
	return($var);
}

sub replaceWhiteSpace {
	local ($var) = @_;
	$var =~ s/\s+/_/g;
	return($var);
}

sub replaceSlash {
	local ($var) = @_;
	$var =~ s/\//-/g;
	return($var);
}

sub swapSlashes {
	local ($var) = @_;
	$var =~ s/\\/\//g;
	return($var);
}

sub escapeAllButSlashes {
	local ($var) = @_;
	$var = escape($var);
	# Now unescape /
	$var =~ s/\%2F/\//ig;
	return($var);
}

sub escapeAllButSlashesAndTilde {
	local ($var) = @_;
	$var = escape($var);
	# Now unescape / and ~
	$var =~ s/\%7E/\~/ig;
	$var =~ s/\%2F/\//ig;
	return($var);
}

sub realClean {
	local ($var) = @_;
	$var = &cleanNonAlpha(&replaceWhiteSpace($var));
	return($var);
}

sub cleanUser {
	local ($var) = @_;
	$var =~ s/[\:\s]//g;
	return($var);
}

sub maxLength {
	local($var, $len) = @_;
	while (length($var) > $len) {
		chop($var);
	}
	return($var);
}

sub genSalt {
	local($i, $p, $num);
	# Generate a random 2 character salt for crypt
	# The range of numbers and letters in ascii is 48-57, 65-90 and 97-122 
	srand();
	for ($i=0; $i < 2; $i++) {
		$num = rand(122);
		while($num < 48 || ($num > 57 && $num < 65) || ($num > 90 && $num < 97)) {
			$num = rand(122);
		}
		$p .= chr($num);
	}
	return($p);
}

sub Xcrypt {
	local($pw,$salt) = @_;
	local($xstr);
	if ($isWin) {
		$xstr = `$crypt \"$pw\"`;
	} else {
		$xstr = crypt($pw,$salt);
	}
	return($xstr);
}

sub cryptPass {
	local($pw) = @_;

	$salt = &genSalt;
	$pw = &Xcrypt($pw, $salt);
	return($pw);
}

sub checkAdminPass {
	local($adminpass) = @_;
	local($udate, $decAdminPass, @tmppass, $tmppass, $datediff, $dateok);
	
	if ($adminpass ne "") {
		if ($Demo) {
			if ($adminpass eq "Demo") {
				$cryptAdminPass = "Demo";
				return(1);
			} else {
				return(0);
			}
		}
		
		open(f, "./.forumadmin");
		$cryptAdminPass = <f>;
		close(f);
		$cryptAdminPass =~ s/\s+//g;
		
		# Decode $adminpass
		($udate, $decAdminPass) = split(/\s/, `$decodeUser \"$adminpass\"`);
		chomp($decAdminPass);
		
		$dateok = 0;
		if ($udate !~ /\=ERROR\=/) {
			$datediff = time() - $udate;
			if ($datediff < 15 * 60) {
				# Cookie is less than 15 minutes old = good
				$dateok = 1;
			} else {
				return(-1);
			}
		}
		
		if ($cryptAdminPass eq &Xcrypt($adminpass, $cryptAdminPass)) {
			# Password checks out - just entered
			@tmppass = `$encodeUser \"$adminpass\"`;
			$tmppass = @tmppass[0];
			chomp($tmppass);
			if ($tmppass !~ /\=ERROR\=/) {
				$cryptAdminPass = $tmppass;
				return(1);
			} else {
				return(0);
			}
		} elsif ($udate !~ /\=ERROR\=/ && 
				$cryptAdminPass eq &Xcrypt($decAdminPass, $cryptAdminPass)) {
			# Password checks out, in cookie
			@tmppass = `$encodeUser \"$decAdminPass\"`;
			$tmppass = @tmppass[0];
			chomp($tmppass);
			if ($tmppass !~ /\=ERROR\=/ && $dateok) {
				$cryptAdminPass = $tmppass;
				return(1);
			} else {
				return(0);
			}
		} else {
			return(0);
		}
	} else {
		return(0);
	}
}

# Build a URl to redirect to after admin login
sub buildNextURL {
	local($i,$z);
	local($nurl) = $CGIEnvScript . "?";
	local(@nams) = $CGIQuery->param;
	$z = 0;
	for ($i=0; $i < @nams; $i++) {
		if ($i > 0) {
			$nurl .= '&';
		}
		#$nurl .= @nams[$i] . "=" . $CGIQuery->param(@nams[$i]);
		
		# add unique param to hopefully avoid caching of this page.
		if (@nams[$i] eq "z") {
			$nurl .= @nams[$i] . "=" . ($CGIQuery->param(@nams[$i]) + 1);
			$z = 1;
		} else {
			$nurl .= @nams[$i] . "=" . $CGIQuery->param(@nams[$i]);
		}
		#==========================================================
	}
	
	# add unique param to hopefully avoid caching of this page.
	if (! $z) {
		if ($i > 0) {
			$nurl .= '&';
		}
		$nurl .= "z=" . time();
	}
	#==============================================================
	return($nurl);
}

sub unescapeUserSave {
	local($u) = @_;
	local($k, @ret, $asc, $hex);
	local(@val) = split(//, $u);
	
	for ($k=0; $k < @val; $k += 2) {
		$hex = @val[$k] . @val[$k + 1];
		$asc = hex($hex);
		if (chr($asc) eq ":") {
			last;
		}
		push(@ret, chr($asc));
	}
	$u = join("", @ret);
	return($u);
}

sub escapeTopic {
	local($value) = @_;
	local($k, $ord);
	local(@val) = split(//, $value);
	for ($k=0; $k < @val; $k++) {
		@val[$k] =~ s/\s/_/;
		if (@val[$k] =~ /[^a-zA-Z0-9_\-\.\/]/) {
			$ord = ord(@val[$k]);

			$ord = sprintf("%X", $ord);
			while (length($ord) < 2) {
				$ord = "0" . $ord;
			}
			@val[$k] = "+" . $ord;
		}
	}
	$value = join("", @val);
	return($value);
}

sub escapeTopicSlash {
	local($value) = @_;
	local($k, $ord);
	local(@val) = split(//, $value);
	for ($k=0; $k < @val; $k++) {
		if (@val[$k] eq "/" || @val[$k] eq "\\") {
			$ord = ord(@val[$k]);

			$ord = sprintf("%X", $ord);
			while (length($ord) < 2) {
				$ord = "0" . $ord;
			}
			@val[$k] = "+" . $ord;
		}
	}
	$value = join("", @val);
	return($value);
}

sub unEscapeTopic {
	local($value) = @_;
	local($k, $asc, $hex);
	local(@val) = split(//, $value);
	
	# hex(23) => 35
	# chr(hex(23)) => # 
	
	for ($k=0; $k < @val; $k++) {
		@val[$k] =~ s/_/ /;
		if (@val[$k] eq "+" && @val[$k + 1] =~ /^[0-9A-Fa-f]$/ 
									&& @val[$k + 2] =~ /^[0-9A-Fa-f]$/) {
			$hex = @val[$k + 1] . @val[$k + 2];
			$asc = hex($hex);
			while (length($asc) < 4) {
				$asc = "0" . $asc;
			}
			@val[$k] = "&#" . $asc . ";";
			@val[$k + 1] = @val[$k + 2] = "";
		}
	}
	$value = join("", @val);
	
	return($value);
}

sub Escape {
	local($value) = @_;
	$value =~ s/\n/\\n/g;
	$value =~ s/\r/\\r/g;
	$value =~ s/\t/\\t/g;
	return($value);
}

sub UnEscape {
	local($value) = @_;
	$value =~ s/\\n/\n/g;
	$value =~ s/\\r/\r/g;
	$value =~ s/\\t/\t/g;
	return($value);
}
