#!/usr/bin/perl

###############################################################################
#
# _AFEdUserPhoto.cgi - User photo selection
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/09/12 17:29:52 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFEdUserPhoto.cgi,v 1.27.2.3 2001/09/12 17:29:52 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "U_Init.pl";
require "NewClass_Init.pl";

# Where are the unzipping programs?
if ($isWin) {
	# Generate absolute paths for programs
	use Cwd;
	$util = cwd;
	$util =~ s/\//\\/g;
	# Remove trailing slash
	$util =~ s/\\$//;
	$util .= "\\util";
	$unzip = $util . "\\unzip.exe";
	$tar = $util . "\\tar.exe";
	$paext = $util . "\\paext.exe";
	$gzip = $util . "\\gzip.exe";
} else {
	$unzip = &findProg("unzip") . " -o";
	$tar = &findProg("tar");
	$gzip = &findProg("gzip");
}

$Class = $CGIQuery->param('fid');
$getuser = $CGIQuery->param('getuser');
$format = $CGIQuery->param('smalllarge');
$multiple = $CGIQuery->param('multiple');
$func = $CGIQuery->param('func');

if ($Class eq "") {
	@getclass = split("/", $CGIEnvScript);
	$index = @getclass - 3;
	$Class = @getclass[$index];
}

&lookupClass;
&lookupUser($CGIEnvUser);

&checkCookieGuest($CGIEnvUser, $C_authtype);

if (!&IS_ADMIN($U_Perms) && $getuser ne $user) {
	&showErrorHTML("You do not have permission to access this resource.");
	exit();
}

$exists = &lookupUser($getuser);

# Load up color variables
&loadColors($ColorQueryString);

$BodyTag = &makeBodyTag("Content");

# Handle image size
if ($format eq "large") {
	$cols = 5;
	$rowsperpage = 5;
	$wid = 36;
	$hei = 46;
	$imwid = 32;
	$imhei = 42;
} else {
	$cols = 5;
	$rowsperpage = 5;
	$wid = 20;
	$hei = 25;
	$imwid = 16;
	$imhei = 21;
}

if (&IS_FAC($U_Perms) && $exists == 0) {
	$highlight = $Ffacultyhilight;
} else {
	$highlight = $Fstudenthilight;
}

# Do some processing on the "dir" parameter

$dir = $CGIQuery->param('dir');
if ($dir eq "") {
	$dir = "/";
}

$gettop = $C_photodir;
chop($gettop);
# Get the directory name that we are in. Photo is the usual default
$gettop =~ s/(.*)\/([^\/]+$)//;
$toproot = $1;
$gettop = $2;

$dirname = $dir;
# $dirname =~ s/^$toproot\///;

$reltop = $C_photourl;
# $reltop =~ s/\/$gettop\///;

# Handle the func parameter, to display frameset or frames
if ($func eq "") {
	# Show the frameset
	print $CGIQuery->header(-expires=>'-1d', -cache-control=>$CacheControl);
	print "<html><head><title>Photo Browser</title>\n";
	&printchosephoto;
	&printJavascript();
	print "</head>\n";
	print "<frameset cols='160,*' border=1>\n";
	if ($format eq "large") {
		print "	<frameset rows='180,*' border=1>\n";
	} else {
		print "	<frameset rows='160,*' border=1>\n";
	}
	print "		<frame name=selectedimg src=\"$CGIEnvScript?func=selected&fid=$Class&getuser=$getuser&smalllarge=$format&multiple=$multiple\" frameborder=yes marginwidth=0 marginheight=0 scrolling=no>\n";
	print "		<frame name=folders src=\"$CGIEnvScript?func=folders&fid=$Class&getuser=$getuser&smalllarge=$format&multiple=$multiple\" frameborder=yes marginwidth=0 marginheight=0>\n";
	print "	</frameset>\n";
	print "	<frame name=photos src=\"$CGIEnvScript?func=browse&fid=$Class&getuser=$getuser&smalllarge=$format&multiple=$multiple\" frameborder=yes marginwidth=0 marginheight=0>\n";
	print "</frameset>\n";
	exit();
	
} elsif ($func eq "selected") {
	# Show upper left frame with selected photo.

	$helplink = "file=UsersAddPhotosCORP_Admin.html&anchor=SelectedPhotoDisplaySummary";
	$helplink .= "&helptitle=Selected%20Photo%20Frame";
	&showHeaderBackHTML("Selected Photo","", 0, 0, 0, $helplink);
	
	if ($exists != 0) {
		$U_Photo = $C_photourl . "Guest.gif";
		$U_PhotoLarge = $C_photourl . "Guest.jpg";
	}
	
	if ($format eq "large") {
		$U_Photo = $U_PhotoLarge;
	}
	
	print "<br><center>\n";
	
	print "<table cellpadding=0 cellspacing=0 border=0 width=$wid><tr>";
	print "<td valign=middle align=center height=$hei width=$wid bgcolor=$highlight nowrap>";
	print "<img src=", $U_Photo, "?",time(), "border=0 width=$imwid height=$imhei>";
	print "</td></tr></table><p>\n";
	
	if ($getuser ne "") {
		print "<a href=javascript:top.selectIt()>";
		print $BtnPhotoApply;
		print "</a>";
	} else {
		if ($format eq "large") {
			print "<a href=$CGIEnvScript?fid=$Class&smalllarge=small target=_parent>";
			print "[ Show small photos ]";
			print "</a>";
		} else {
			print "<a href=$CGIEnvScript?fid=$Class&smalllarge=large target=_parent>";
			print "[ Show large photos ]";
			print "</a>";
		}
	}
		
	print "</center>";
	exit();
	
} elsif ($func eq "folders") {
	# Show file browser view
	$open = $CGIQuery->param('expand');
	@exptmp = split(/\,/, $open);
	for ($i=0; $i < @exptmp; $i++) {
		if (@exptmp[$i] ne "") {
			push(@expand, @exptmp[$i]);
		}
	}
	@expand = &unique(@expand);
	
	$helplink = "file=UsersAddPhotosCORP_Admin.html&anchor=UploadPhotosSummary";
	$helplink .= "&helptitle=Folders%20Frame";

	&showHeaderBackHTML("Folders", "", 0, 0, 0, $helplink);
	
	print "<table border=0 cellpadding=1 cellspacing=0 width=100%>\n"; 
	
	# Yes! This is necessary!
	$C_photourl =~ s/\/$//;
	
	@folders = &genDirList($C_photodir);
	
	@folders = sort(@folders);
	
	#@gettoplen = split(/\//, $C_photodir);
	#$toplen = @gettoplen;
	for ($i=0; $i < @folders; $i++) {
		# Replace \ with / for windows
		if ($isWin) {
			@folders[$i] =~ s/\\/\//g;
		}
	
		# Remove $C_photourl for dir name
		# Note that C_photodir has had the trailing slash removed
		@folders[$i] =~ s/^$C_photodir//;
		
		# Check for blank entry => "/"
		if (@folders[$i] eq "") {
			@folders[$i] = "/";
		}
	
		if (@folders[$i] ne "/") {
			@getname = split(/\//, @folders[$i]);
			$fview{"@folders[$i]"}{"name"} = @getname[$#getname];
			$fview{"@folders[$i]"}{"indents"} = $#getname;
		} else {
			$fview{"@folders[$i]"}{"name"} = "/&nbsp;&nbsp;(Top_Level)";
			$fview{"@folders[$i]"}{"indents"} = 0;
		}
		
		@getpar = @getname[0..($#getname - 1)];
		if (@folders[$i] ne "/") {
			$fview{"@folders[$i]"}{"parent"} = join("/", @getpar);
			if ($fview{"@folders[$i]"}{"parent"} eq "") {
				$fview{"@folders[$i]"}{"parent"} = "/";
			}
		}
		
		if ($fview{$fview{"@folders[$i]"}{"parent"}}{"name"} ne "") {
			$fview{$fview{"@folders[$i]"}{"parent"}}{"children"} = @folders[$i];
		}

		if ($open =~ /\,@folders[$i]\,/) {
			$fview{"@folders[$i]"}{"open"} = 1;
			# Mark parent as open
			$par = $fview{"@folders[$i]"}{"parent"};
			while ($par ne "") {
				$fview{$par}{"open"} = 1;
				$par = $fview{$par}{"parent"};
			}
		}
	}
	
	for ($i=0; $i < @folders; $i++) {
		if ($fview{$fview{"@folders[$i]"}{"parent"}}{"open"} == 1 || @folders[$i] eq "/") {
			# Start table row
			print "<tr><td valign=middle align=left>", $FontFace, $FontSize;
			
			for ($j=0; $j <= $fview{"@folders[$i]"}{"indents"}; $j++) {
				print $ImgClear88;
			}
			
			if ($fview{"@folders[$i]"}{"open"}) {
				# @thisexp = ("");
				splice(@thisexp, 0);
				for ($j=0; $j < @expand; $j++) {
					if (@expand[$j] !~ /^@folders[$i]/) {
						push (@thisexp, @expand[$j]);
					}
				}
				
				$exp = "," . join(",", @thisexp) . ",";
				
				# Need to modify expansion list to remove all children also

				print "<a href=\"$CGIEnvScript?fid=$Class&getuser=$getuser&smalllarge=$format&multiple=$multiple&func=$func&expand=$exp\">";
				print $BtnExpanded;
				print "</a>";
			} else {
				if ($fview{"@folders[$i]"}{"children"} ne "") {
					if (@expand > 0) {
						$exp = "," . join(",", @expand);
					} else {
						$exp = "";
					}
					
					if ($exp !~ /\,@folders[$i]\,|\,@folders[$i]$/) {
					# if ($exp !~ /\,@folders[$i]\,/) {
						$exp .= "," . @folders[$i] . ",";
					} else {
						$exp .= ",";
					}
					
					print "<a href=\"$CGIEnvScript?fid=$Class&getuser=$getuser&smalllarge=$format&multiple=$multiple&func=$func&expand=$exp\">";
					print $BtnCollapsed;
					print "</a>";
				} else {
					print $IcoNoReplies;
				}
			}
			
			# Link to update browse window
			print "<a href=\"$CGIEnvScript?fid=$Class&getuser=$getuser";
			print "&smalllarge=$format&multiple=$multiple&func=browse";
			print "&dir=", @folders[$i], "\" target=photos>";
			print &printPretty($fview{"@folders[$i]"}{"name"});
			print "</a>";
			print "</td>\n";
			
			# Spacer
			print "<td>$ImgIndentSmall</td>\n";
			
			# Upload link
			&lookupUser($CGIEnvUser);
			if (&IS_ADMIN($U_Perms)) {
				print "<td align=right valign=middle>", $FontFace, $FontSize;
				print "<a href=\"$CGIEnvScript?fid=$Class&getuser=$getuser";
				print "&smalllarge=$format&multiple=$multiple&func=upload";
				print "&dir=", @folders[$i], "\" target=photos>";
				print $BtnPhotoUp;
				print "</a>";
				print "</td>\n";
			}
			
			print "</tr>\n\n";
		}
	}
	
	print "</table>\n</body>\n</html>";
	
	exit();
	
} elsif ($func eq "upload") {
	# Photo upload handling

	$upload = $CGIQuery->param('upload');
	@qnames = $CGIQuery->param;
	
	if ($upload eq "") {
		# Print file upload page
		$helplink = "file=UsersAddPhotosCORP_Admin.html&anchor=UploadPhotosSummary";
		$helplink .= "&helptitle=Upload%20Frame";

		$header = "Upload Photos to Directory: " . &printPretty($dirname);
		&showHeaderBackHTML($header, "<br>", 0, 0, 0, $helplink);
		
		print "You may upload photos one at a time, or as a group in a ";
		print "compressed file.\n Supported compressed file formats are: ";
		print "<ul><li>.zip <li>.tar <li> .tar.gz <li> .tgz</ul>\n";
		print "Any directory structure in ";
		print "the compressed file will be maintained in the directory ";
		print "structure on the server.<br>\n";
		print "All photos must have one of the following extensions, exactly as shown: ";
		print "<ul><li>.gif <li> .jpg</ul> Note that Macintosh Stuffit ";
		print "archives are not supported.\n Make sure that the file you are ";
		print "uploading has the correct filename extension. ";
		print "(.gif, .jpg, .zip, .tar, .tar.gz or .tgz)\n";
		print "<p>\n";
		
		print "Your photos MUST be sized correctly before you upload them.\n";
		print "<ul><li>";
		print "Large photos must be $FontRed JPEG</font> format, with a width of $FontRed";
		print "32</font> pixels\n";
		print "and a height of $FontRed 42</font> pixels. ";
		print "<li>Small photos must be $FontRed GIF</font> format,\n";
		print "with a width of $FontRed 16</font> pixels ";
		print "and a height of $FontRed 21</font> pixels.</ul><p>\n";
		
		print "<form action=$CGIEnvScript method=POST enctype='multipart/form-data'>\n";
		
		for ($i=0; $i < @qnames; $i++) {
			print "<input type=hidden name=\"", @qnames[$i], "\" ";
			print "value=\"", $CGIQuery->param(@qnames[$i]), "\">\n";
		}
		
		print "<input type=file name=upload size=40><p>\n";
		
		print "<table border=0 cellpadding=0 cellspacing=1 width=100%>\n";
		print "<tr><td bgcolor=$FTheaderback>", $FontFace, $FontSize;	
		print "<img src=$ImgSrcClearDot width=20 height=2>";
		print "</td></tr>\n";
		print "</table>\n";
		
		if ($Demo) {
			print $BtnFormSubmitDemo;
		} else {
			print $BtnFormSubmit;
		}
		print "\n</form>\n";
		
	} else {
		if ($Demo) {
			print $CGIQuery->redirect("Demo.html");
			exit();
		}
		
		# Chop the trailing slash from $C_photourl
		$C_photourl =~ s/\/$//;
	
		# Process uploaded file
		if ($CGIEnvUserAgent =~ /mac/i) {
			@getname = split(/:/, $upload);
		} elsif ($CGIEnvUserAgent =~ /win/i) {
			@getname = split(/\\/, $upload);
		} else {
			@getname = split(/\//, $upload);
		}
		$temp = @getname;
		$filename = @getname[$temp-1];
		$filename =~ s/\s+$//g;
		$filename =~ s/\s+/_/g;
		$filename =~ s/[^_\-0-9a-zA-Z\.]+/_/g;
		
		$savefile = $C_photodir . $dir . "/" . $filename;
		
		if ($savefile =~ /(\.gif)$|(\.jpg)$/i) {
			$m = $1;
		} elsif ($upload !~ /\.zip|\.tar|\.tar\.gz|\.tgz/i) {
			&showErrorBackHTML("The file you uploaded was not in one of the specified formats.", 1);
			exit();
		}
		
		open (filesave, ">$savefile");
		binmode(filesave);
		while (<$upload>) {
			print filesave $_;
		}
		close (filesave);
		
		# chdir($dir);
		chdir($C_photodir . $dir);
		
		if ($savefile =~ /\.zip/i) {
			system("$unzip -o \"$savefile\"");
			unlink($savefile);
		} elsif ($savefile =~ /\.tar\.gz|\.tgz/i) {
			if ($isWin) {
				system("$gzip -cd \"$savefile\" > _picts.tar");
				system("$paext -e -o -d -c _picts.tar > _palog");
				unlink("_palog");
				unlink("_picts.tar");
			} else {
				system("$gzip -cd \"$savefile\" | $tar xf - > _tar.errlog");
				unlink("_tar.errlog");
			}
			unlink($savefile);
		} elsif ($savefile =~ /\.tar/i) {
			if ($isWin) {
				system("$paext -e -o -d -c \"$savefile\" > _paerr");
				unlink("_paerr");
			} else {
				system("$tar xf \"$savefile\"");
			}
			unlink($savefile);
		}
		
		&showHeaderBackHTML("Got uploaded file");
		print "Your file has been received and processed.<p>\n";
		print "<a href=$CGIEnvScript?";
		for ($i=0; $i < @qnames; $i++) {
			if (@qnames[$i] eq "func") {
				print "&func=browse";
			} elsif (@qnames[$i] ne "upload") {
				print "\&", @qnames[$i], "=" , $CGIQuery->param(@qnames[$i]);
			}
		}
		print " onClick=parent.folders.location.reload()>[Return to Browsing]</a>\n"
	}
	
	exit();
}

# Print photo browsing frame
$page = $CGIQuery->param("page");
if ($page eq "") {
	$page = 1;
}

$helplink = "file=UsersAddPhotosCORP_Admin.html&anchor=PhotoSelectionSummary";
$helplink .= "&helptitle=Photo%20Selection%20Frame";

$header = "Photo Selection ";
if ($getuser ne "") {
	$header .= "for User: $getuser ";
}
$header .= "in Directory: " . &printPretty($dirname);
&showHeaderBackHTML($header, "<br>", 0, 0, 0, $helplink);

# Get the list of photos
$C_photodir =~ s/\/$//;
chdir($C_photodir . $dir);
if ($format eq "large") {
	@photos = grep(/\.jpg/i, glob("*"));
} else {
	@photos = grep(/\.gif/i, glob("*"));
}

if (@photos <= 0) {
	print $ImgIndent, $FontRed, "There were no photos found in the selected directory.";
	exit();
} else {
	if ($getuser ne "") {
		print $ImgIndent, $FontRed;
		print "Click a photo link to select it, then click the Apply button on the ";
		print "left to finalize your choice.</font><br><br>\n";
	} else {
		print $ImgIndent, $FontRed;
		print "Click a photo link to view the photo.</font><br><br>\n";
	}
}

$rows = @photos / $cols;
if ($rows =~ /\./) {
	($rows, $junk) = split(/\./, $rows);
	$rows += 1;
}

if ($rows > $rowsperpage) {
	$pages = $rows / $rowsperpage;
	if ($pages =~ /\./) {
		($pages, $junk) = split(/\./, $pages);
		$pages += 1;
	}
} else {
	$pages = 1;
}

$C_photourl =~ s/\/$//;
for ($i=0; $i < @photos; $i++) {
	@photourl[$i] = $C_photourl . $dir . ($dir ne "/" ? "/" : "") . @photos[$i];
}

# &printchosephoto;

# Got the urls of all of the photos
print "<table border=0 cellpadding=5 cellspacing=0>\n";

$start = 0;
$end = $#photourl;

if ($pages > 1) {
	$end = ($page * $rowsperpage * $cols) - 1;
	$start = $end - ($rowsperpage * $cols) + 1;
	if ($end > $#photourl) {
		$end = $#photourl;
	}
}

for ($i=$start; $i <= $end; $i++) {
	if (($i % $cols) == 0) {
		print "<tr>\n";
	}
	
	print "<td align=center valign=top>", $FontFace, $FontSize;
	if (@photourl[$i] ne "") {
		print "<a href=javascript:parent.ChosePhoto(\"", @photourl[$i];
		print "\",\"";
		$short = @photourl[$i];
		$short =~ s/^$C_photourl//;
		print $short;
		print "\")>";
		print "<img src=\"", @photourl[$i], "?", time(), "\" border=0 width=\"$imwid\" height=\"$imhei\">";
		print "</a>";
		print "<br>";
		print @photos[$i];
	} else {
		print "&nbsp;";
	}
	print "</td>\n";
	
	if ($i == $end) {
		# That was the last image. Need to fill the rest of the row
		# with empty cells
		for ($j = $i + 1; $j < $rows * $cols; $j++) {
			print "<td>", $FontFace, $FontSize;
			print "&nbsp;";
			print "</td>";
		}
	}
	
	if ((($i + 1) % $cols) == 0) {
		print "</tr>\n";
	}
}

if ($pages > 1) {
	print "<tr><td colspan=$cols align=center>", $FontFace, $FontSize;
	if ($page > 1) {
		print "<a href=\"$CGIEnvScript?fid=$Class&func=$func&dir=$dir";
		print "&page=1";
		print "&getuser=$getuser&smalllarge=$format&multiple=$multiple\">";
		print "&lt;&lt;</a>&nbsp;&nbsp;";
		
		print "<a href=\"$CGIEnvScript?fid=$Class&func=$func&dir=$dir";
		print "&page=", $page - 1;
		print "&getuser=$getuser&smalllarge=$format&multiple=$multiple\">";
		print "&lt;</a>&nbsp;&nbsp;";
	}
	
	print "Page $page of $pages";
	
	if ($page < $pages) {		
		print "&nbsp;&nbsp;";
		print "<a href=\"$CGIEnvScript?fid=$Class&func=$func&dir=$dir";
		print "&page=", $page + 1;
		print "&getuser=$getuser&smalllarge=$format&multiple=$multiple\">";
		print "&gt;</a>";
		
		print "&nbsp;&nbsp;";
		print "<a href=\"$CGIEnvScript?fid=$Class&func=$func&dir=$dir";
		print "&page=", $pages;
		print "&getuser=$getuser&smalllarge=$format&multiple=$multiple\">";
		print "&gt;&gt;</a>";
	}
}

print "</table>\n</body>\n</html>";

#######

sub printchosephoto {
	if ($multiple) {
		$addname = $getuser . "_";
	} else {
		$addname = "";
	}

	print "<script language=javascript>\n";
	print "var choseName = \"\";\n";
	print "var choseShort = \"\";\n";
	print "function ChosePhoto(thename, shortname) {\n";
	print "	if (\"$format\" == \"large\") {\n";
	print "		choseName = thename;\n";
	print "		choseShort = shortname;\n";
	print "	} else {\n";
	print "		choseName = thename;\n";
	print "		choseShort = shortname;\n";
	print "	}\n";
	print "	selectedimg.document.images[3].src = thename;\n";
	print "}\n";
	print "\n";
	print "function selectIt() {\n";
	print "	if (\"$format\" == \"large\") {\n";
	print "		window.opener.document.", $addname, "large.src = choseName;\n";
	print "		window.opener.document.forms[0].", $addname, "photo2.value = choseShort;\n";
	print "	} else {\n";
	print "		window.opener.document.", $addname, "small.src = choseName;\n";
	print "		window.opener.document.forms[0].", $addname, "photo.value = choseShort;\n";
	print "	}\n";
	print "top.window.close();\n";
	print "}\n";
	print "</script>\n\n";
}
