#!/usr/bin/perl

###############################################################################
#
# _AFEdUserBatch.cgi - User photo selection
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:52 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFEdUserBatch.cgi,v 1.30.2.3 2001/08/21 17:50:52 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "U_Init.pl";

$adminpass = $CGIQuery->cookie('panForaAdmin');
$forumadmin = &checkAdminPass($adminpass);

$Class = $CGIQuery->param('fid');
$upload = $CGIQuery->param('upload');
$func = $CGIQuery->param('func');
$emailpassword = $CGIQuery->param('emailpassword');

if ($Class ne "") {
	&lookupClass;
	&lookupUser($CGIEnvUser);
} else {
	$ColorQueryString = &lookupColors("1");
}

# Load up color variables
&loadColors($ColorQueryString);

$BodyTag = &makeBodyTag("Content");

if (!$forumadmin) {
	&checkCookieGuest($CGIEnvUser, $C_authtype);
}

if (!&IS_ADMIN($U_Perms) && !$forumadmin) {
	&showErrorBackHTML("You do not have permission to access this resource, or have not logged on properly.", 0);
	exit();
}

$adminemail = $U_Email;

$SUIDlabel = "University ID";
if (!$Edu) {
	$SUIDlabel = "Password Hint";
}

# Handle the func parameter
if ($func eq "") {
	# Show the initial upload page
	$helplink = "file=UsersBatchUploadCORP_Admin.html&anchor=BatchUserUploadEdtFSummary";
	$helplink .= "&helptitle=Batch%20User%20Upload";
	
	&showHeaderBackHTML("Batch User Upload", "<br>", 0, 0, 0, $helplink);
	
	print "You can upload a text file with user data here to populate the users ";
	print "database.<br>\n $FontRed Note that any existing users will be ";
	print "overwritten if duplicate IDs exist in the data file.</font><p>\n ";
	print "The format of the file MUST be as follows:<p>\n";
	
	print "<ul>";
	print "<li>$FontRed Important!!!! </font>";
	print "The file must be a plain text file (.txt) and have either Unix ";
	print "or DOS line breaks. This means the file can not be created on a ";
	print "Macintosh unless it is saved with Unix or DOS line breaks.</li>\n";
	print "<li>One user per line</li>\n";
	print "<li>Each user must have a unique ID</li>\n";
	print "<li>The user data must be tab delimited</li>\n";
	
	print "<li>If the password is left blank a random 8 character ";
	print "password will be assigned.</li>\n";
	
	print "<li>Permissions is sum of the numbers below to provide the ";
	print "associated permissions:\n";
	print "<ul><li>Write = 1</li>\n";
	print "<li>Read = 2</li>\n";
	print "<li>$ForM = 4</li>\n";
	print "<li>Admin = 8</li>\n";
	print "</ul>\n";
	print "If this field is left blank, the user will be given Read and Write ";
	print "permissions (a value of 3).\n";
	print "</li>\n";
	
	print "<li>$CorF $SorG can either be the system internal section ID ";
	print "(e.g. \"2\" or \"", $Class, ":2\"), or the ";
	print "textual name of the $sorg (e.g. \"$SorG 3\"). Any $sorg names ";
	print "specified that do not already exist will be added. If you leave ";
	print "the $sorg blank, the user will be assigned to an existing ";
	print "$sorg.</li>\n";
	
	print "<li>The Photo field can be left blank and a default will be put ";
	print "in place. Also if the large photo field is left blank, it will ";
	print "be determined by the name of the small photo. It is recommended ";
	print "that you leave this field blank, and it will be filled for ";
	print "you.</li>\n";
	
	print "<li>Put User on $SorG Email List is:\n";
	print "<ul><li>1 for yes</li>\n";
	print "<li>0 for no</li>\n";
	print "</ul>\n";
	print "If it is left blank, the user WILL be put on the email list.\n";
	print "</li>\n";
	
	print "<li>The user data fields MUST be in the order specified below</li>\n";
	print "<li>Fields in red are required. Empty fields before Email Address must still be delimited by tabs</li>\n";
	
	print "</ul>\n\n";

	print "<table border=1 cellpadding=1 cellspacing=0>\n";
	print "<tr><td colspan=15>", $FontFace, $FontSize2;
	print "<b>User Data Fields</b></td></tr>\n";
	
	&printHeadRow;
	
	print "</table>\n\n";
	
	print "<form action=$CGIEnvScript method=POST enctype='multipart/form-data'>\n";
	
	print "<input type=file name=upload size=40><br>\n";
	
	if ($Class eq "") {
		@classlist = &lookupClassList;
		print "<select name=class>\n";
		for ($i=0; $i < @classlist; $i++) {
			print "<option value=", @classlist[$i];
			print "> ", @classlist[$i], "\n";
		}
		print "</select>\n";
	} else {
		print "<input type=hidden name=fid value=$Class>\n";
	}
	
	print "<input type=checkbox name=emailpassword value=\"YES\">";
	print "Send account information to new users through email. <br>\n";
	
	print "<input type=hidden name=func value=upload>\n";
	
	print "<table border=0 cellpadding=0 cellspacing=1 width=100%>\n";
	print "<tr><td bgcolor=$FTheaderback>", $FontFace, $FontSize;	
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	print "</table>\n";
	
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "\n</form>\n";
	
	exit();
	
} elsif ($func eq "upload") {
	# upload handling
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}

	$upload = $CGIQuery->param('upload');
	@qnames = $CGIQuery->param;
	
	if ($upload eq "") {
		&showErrorBackHTML("You must select a file to upload.");
		exit();
	} else {
		# Process uploaded file
		if ($CGIEnvUserAgent =~ /mac/i) {
			@getname = split(/:/, $upload);
		} elsif ($CGIEnvUserAgent =~ /win/i) {
			@getname = split(/\\/, $upload);
		} else {
			@getname = split(/\//, $upload);
		}
		$temp = @getname;
		$filename = @getname[$temp-1];
		$filename =~ s/\s+$//g;
		$filename =~ s/\s+/_/g;
		$filename =~ s/[^_\-0-9a-zA-Z\.]+/_/g;
		
		$savefile = $C_rootpath . "/" . $DIR_CONFIG . "/UserUpload.txt";
		
		@rawdata = <$upload>;
		
		for ($i=0; $i < @rawdata; $i++) {
			if (@rawdata[$i] !~ /\*/) {
				push(@fdata, @rawdata[$i]);
			}
		}
		
		@required = (0,3,4,6);
		for ($i=0; $i < @fdata; $i++) {
			@line = split(/\t/, @fdata[$i]);
			@line[0] = &maxLength(&cleanNonAlpha(@line[0]), 16);
			if (@line < 6) {
				push(@rejects, @fdata[$i]);
			} else {
				$rejected = 0;
				for ($j=0; $j < @required; $j++) {
					if (@line[@required[$j]] eq "" && !$rejected) {
						push (@rejects, @fdata[$i]);
						$rejected = 1;
					}
				}
				
				if (!$rejected) {
					push(@accepted, @fdata[$i]);
				}
			}
		}
		
		@accepted = sort(@accepted);
		open (filesave, ">$savefile");
		for ($i=0; $i < @accepted; $i++) {
			print filesave @accepted[$i];
		}
		close (filesave);
		
		if (@rejects > 0) {
			$num = @rejects;
			$helplink = "file=UsersBatchUploadCORP_Admin.html&anchor=BatchUserUploadEdtFSummary";
			$helplink .= "&helptitle=Batch%20User%20Upload";
			
			&showHeaderBackHTML("Invalid Data", "<br>", 0, 0, 0, $helplink);
			print "There were $num lines of data that were invalid. \n";
			print "These lines were rejected because of an insufficient number ";
			print "of data fields, usernames with invalid characters or \n";
			print "required fields were missing.<p>\n";
			print "The invalid lines follow:<br>\n";
			print "<table border=1 cellpadding=1 cellspacing=0>\n";
			&printHeadRow;
			for ($i=0; $i < @rejects; $i++) {
				@line = split(/\t/, @rejects[$i]);
				print "<tr>";
				for ($j=0; $j < @line; $j++) {
					print "<td nowrap>", $FontFace, $FontSize;
					print @line[$j], "&nbsp;";
					print "</td>\n";
				}
				print "</tr>\n\n";
			}
			print "</table><p>\n\n";
			
			if (@accepted > 0) {
				print "Would you like to input the users that were valid?\n";
				print "<form action=$CGIEnvScript method=POST>\n";
				print "<input type=hidden name=fid value=$Class>\n";
				print "<input type=hidden name=func value=confirmadd>\n";
				print "<input type=hidden name=emailpassword value=\"$emailpassword\">\n";
				print "<input type=radio name=confirm value=YES>Yes \n";
				print "<input type=radio name=confirm value=NO>No \n";
				
				print "<table border=0 cellpadding=0 cellspacing=1 width=100%>\n";
				print "<tr><td bgcolor=$FTheaderback>", $FontFace, $FontSize;	
				print "<img src=$ImgSrcClearDot width=20 height=2>";
				print "</td></tr>\n";
				print "</table>\n";
				
				print $BtnFormSubmit;
				print "</form>\n";
			} else {
				print "<a href=javascript:history.back()>[Back]</a>\n";
			}
		} else {
			&addUsers;
		}
	}
	
	exit();

} elsif ($func eq "confirmadd") {
	$confirm = $CGIQuery->param('confirm');
	
	if ($confirm eq "YES") {
		&addUsers;
		exit();
	} else {
		&showHeaderBackHTML("User Addition Cancelled", "<br>The user upload has been cancelled. No changes have been made to the database.", 2);
		exit();
	}
}

sub addUsers {
	&clearUserData;

	&showHeaderBackHTML("Adding Users");

	$savefile = $C_rootpath . "/" . $DIR_CONFIG . "/UserUpload.txt";
	open (f, "$savefile");
	@u = <f>;
	close (f);
	chomp(@u);
	for ($i=0; $i < @u; $i++) {
		&clearUserData;
	
		# Format of file has already been checked, so just dump the users in
		($DB_Key, $U_SUID, $U_Pass, $U_NameFirst, $U_NameLast, $U_NamePref, $U_Email, $U_Phone, $U_Perms, $U_C_Sect, $U_Photo, $U_Classify, $U_ProfileText, $U_Sig, $U_HideEmail) = split(/\t/, @u[$i]);
		
		$DB_Key = &maxLength(&cleanNonAlpha($DB_Key), 16);
		
		# Check for password, and create if necessary
		if ($U_Pass eq "") {
			if ($U_SUID ne "") {
				$U_Pass = $U_SUID;
			} else {
				$U_Pass = &genPass();
			}
		}
		
		if ($C_EncryptUserPass) {
			$newpass = $U_Pass;		# save password before encrypt for emailing
			$U_Pass = &cryptPass($U_Pass);
		}
		
		if ($U_SUID eq "") {
			$U_SUID = "";
		}
		
		# correct for incorrect section specification, or add section
		if ($U_C_Sect =~ /$Class\:/) {
			($junk, $sectnum) = split(/\:/, $U_C_Sect);
			$U_C_Sect = $Class . ":" . $sectnum;
		} elsif ($U_C_Sect =~ /\D/) {
			# User specifed the name of the section.
			$foundsect = 0;
			for ($j=1; $j <= $C_Sect_n; $j++) {
				if ($U_C_Sect eq $C_Sects{$j}{"name"}) {
					$U_C_Sect = $Class . ":" . $j;
					$foundsect = 1;
					next;
				}
			}
			
			if (! $foundsect) {
				# Add the section that was specified. Use the section leader
				# from the first section.
				$newsect = $C_Sect_n + 1;
				
				# Put the new section in the class database
				$value = "$newsect\\t";
				$value .= "$U_C_Sect\\t";
				$value .= $C_Sects{1}{"login"} . "\\t\\t\\t";
				$value .= $Class . "-Sect" . $newsect;
				$key = "C_Sect_" . $newsect; 
				
				$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_CLASSINFO;
				
				# Ignore errors here for now...
				@retval = `$setDB $dbfile -thash -q -k \"$key\" -d \"$value\"`;
				$status = &dbErrorCheck($?, @retval[0]);
				@retval = `$setDB $dbfile -thash -k \"C_Sect_n\" -d \"$newsect\"`;
				$status = &dbErrorCheck($?, @retval[0]);
				
				$U_C_Sect = $Class . ":" . $newsect;
			}
		} elsif ($U_C_Sect > 0) {
			$U_C_Sect = $Class . ":" . $U_C_Sect;
		} else {
			if ($C_Sects{2}{"name"} =~ /^student/i) {
				$U_C_Sect = $Class . ":2";
			} else {
				$U_C_Sect = $Class . ":1";
			}
		}
		
		# Default Permissions
		if ($U_Perms eq "" || $U_Perms !~ /^[0-9]*$/) {
			$U_Perms = 3;
		} elsif ($U_Perms >= 16 || $U_Perms < 0) {
			$U_Perms = 3;
		}
		
		# Handle Classification (now email list)
		if ($U_Classify !~ /^0/) {
			$U_Classify = 1;
		} else {
			$U_Classify = 0;
		}
			
		# Default HideEmail
		if ($U_HideEmail !~ /^1/) {
			$U_HideEmail = 0;
		} else {
			$U_HideEmail = 1;
		}
		
		# Turn on signal Handling
		$trapSignals = 1;
			
		$status = &addtodb($DB_Key);
		if ($status) {
			print $status, "Unable to add user $DB_Key to the database!<br>";
		} else {
			if ($DB_Key ne "Anonymous") {
				# Not necessary. ht files are rebuilt at the end
				# &addtoht($DB_Key, $U_C_Sect);
			}
			if ($DB_Key ne "Anonymous" && $DB_Key ne "Guest") {
				&procUserPhoto;
				&addphoto($DB_Key, 1);

				# Not necessary, mailing lists rebuilt at the end
				# &addtomail($DB_Key);
			}
			print "Added $DB_Key<br>";
			
			if ($emailpassword eq "YES") {
				&emailUserAccountInfo($DB_Key, $adminemail);
			}
		}
		
		# If we got a signal, exit here.
		if ($gotSignal) {
			close(DEVNULL);
			exit(0);
		} else {
			$trapSignals = 0;
		}	
	}
	
	# rebuild mailing lists from scratch
	&rebuildAllMailAndHT();
	
	print "<p>$FontRed Finished!";
	
	
}

sub printHeadRow {	
	print "<tr>";
	print "<td nowrap>", $FontFace,$FontSize, $FontRed;
	print "User ID";
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize;
	print $SUIDlabel;
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize;
	print "Password";
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize, $FontRed;
	print "First Name";
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize, $FontRed;
	print "Last Name";
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize;
	print "Preferred Name";
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize, $FontRed;
	print "Email Address";
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize;
	print "Phone Number";
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize;
	print "Permissions";
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize;
	print "$CorF $SorG";
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize;
	print "Small Photo,Large Photo";
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize;
	print "Put User on $SorG Email List";
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize;
	print "Personal Information";
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize;
	print "Signature";
	print "</td>\n";
	print "<td nowrap>", $FontFace,$FontSize;
	print "Hide Email";
	print "</td>\n";
	
	print "</tr>\n";
}
