#!/usr/bin/perl

###############################################################################
#
# _AClassDisable.cgi - Disable or Enable Forums
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:51 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AClassDisable.cgi,v 1.16.2.2 2001/08/21 17:50:51 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";

$adminpass = $CGIQuery->cookie('panForaAdmin');
$forumadmin = &checkAdminPass($adminpass);

$Class = $CGIQuery->param('fid');
$func = $CGIQuery->param('func');
$mode = $CGIQuery->param('mode');

if ($Class ne "") {
	&lookupClass;
	&lookupUser($CGIEnvUser);
} else {
	$ColorQueryString = &lookupColors("1");
}
&loadColors($ColorQueryString);


if ($func ne "menu") {
	$BodyTag = &makeBodyTag("Content");
} else {
	$BodyTag = &makeBodyTag("Threads");
}

if ($CGIEnvUser ne "Guest" && $CGIEnvUser ne "") {
	&checkCookieGuest($CGIEnvUser, $C_authtype);
}

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !&IS_FAC($U_Perms) && !$forumadmin) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}

###############################################################################
#
# Process submitted data

# Get list of all classes
@allClasses = &lookupClassList;

foreach $cl (@allClasses) {
	&lookupClass($cl);
	$cdata{$cl}{"disabled"} = $C_Disable;
	$cdata{$cl}{"title"} = $C_title;
	$cdata{$cl}{"rootpath"} = $C_rootpath;
}	

if ($func eq "showedit") {
	&showedit;
} elsif ($func eq "doedit") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&doedit;
} elsif ($func eq "menu") {

	#####################################################
	# Menu Frame
	#####################################################
	
	if ($forumadmin) {
		$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
	}
	
	$helplink = "file=ForumEnableDisableCORP_Admin.html";
	$helplink .= "&anchor=DisableForumTskFSummary";
	$helplink .= "&helptitle=Enable/Disable%20".$CorFs."%20Task%20Frame";
		
	&showHeaderBackHTML("Enable/Disable $CorFs",
						"", 0, 1, 0, $helplink, $cookie);

	# Start Form
	print "<form action=$CGIEnvScript method=GET target=disableedit>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=func value=showedit>\n\n";
	
	# Print form
	print "<table cellpadding=0 cellspacing=2 border=0>\n";
	
	# Headings row
	print "<tr>";
	print "<td rowspan=4>$ImgClear88</td>\n";
	print "<td valign=bottom>";
	print $FontFace, $FontSize;
	print "Enable/Disable";
	print "</td>\n";
	print "<td>$ImgClear88</td>\n";
	print "<td valign=bottom>";
	print $FontFace, $FontSize;
	print "Currently Enabled";
	print "</td>\n";
	print "<td>$ImgClear88</td>\n";
	print "<td valign=bottom>";
	print $FontFace, $FontSize;
	print "Currently Disabled";
	print "</td>\n";
	print "</tr>\n\n";
	
	# Divider line
	print "<tr>";
	print "<td bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td>\n";
	print "<td><img src=$ImgSrcClearDot width=8 height=2></td>\n";
	print "<td bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td>\n";
	print "<td><img src=$ImgSrcClearDot width=8 height=2></td>\n";
	print "<td bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td>\n";
	print "</tr>\n\n";
	
	# Enable/Disable selection box
	print "<tr><td valign=top>\n";
	print $FontFace, $FontSize;
	print "<select name=classes size=4 multiple>\n";
	print "<option value='(ALL)'> All $CorFs\n";
	foreach $cl (@allClasses) {
		print "<option value=\"", $cl, "\"> ";
		print $cl, " (", $cdata{$cl}{"title"}, ")\n";
	}
	print "</select>\n";
	print $BtnFormEdit;
	print "</td>\n";
	
	print "<td>$ImgClear88</td>\n";
	
	# Print list of Enabled Classses
	print "<td valign=top nowrap>\n";
	print $FontFace, $FontSize;
	$printed = 0;
	foreach $cl (@allClasses) {
		if ($cdata{$cl}{"disabled"} == 0) {
			print "&#0149; ", $cl, " (", $cdata{$cl}{"title"}, ")<br>\n";
			$printed = 1;
		}
	}
	if (! $printed) {
		print "&#0149; No $CorFs Enabled\n";
	}
	print "</td>\n";
	
	print "<td>$ImgClear88</td>\n";
	
	# print list of Disabled Classes
	print "<td valign=top nowrap>\n";
	print $FontFace, $FontSize;
	$printed = 0;
	foreach $cl (@allClasses) {
		if ($cdata{$cl}{"disabled"} > 0) {
			print "&#0149; ", $cl, " (", $cdata{$cl}{"title"}, ")<br>\n";
			$printed = 1;
		}
	}
	if (! $printed) {
		print "&#0149; No $CorFs Disabled\n";
	}
	print "</td>\n";

	print "</tr>\n\n";
	
	print "<tr><td colspan=5>", $FontFace, $FontSize;
	print $FontRed, "*</font> Note: Selecting \"All $CorFs\" or any ";
	print $CorF, " other than the current $CorF requires an additional password.";
	print "</td></tr>\n";

	print "</form>\n";
	

	print "</table>\n";
	print "</body></html>\n";
	
} elsif ($func eq "nothing") {
	# User input nothing, tell them to select something
	&printEmptyTaskFrame("Please make a selection above.");
	
} else {
	# Print out frameset
	if ($forumadmin) {
		$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
								
		print $CGIQuery->header(-cookie=>$cookie);
	} else {
		print $CGIQuery->header;
	}
	
	print "<html><head><title>Enable/Disable $CorFs</title>\n";
	&printJavascript;
	print "</head>\n";
	print "<frameset rows='150,*' border=2>\n";
	print "	<frame name=disablemenu ";
	print "src=$CGIEnvScript?fid=$Class&func=menu ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=disableedit ";
	print "src=$CGIEnvScript?fid=$Class&func=nothing ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}

sub showedit {
	@allClasses = $CGIQuery->param('classes');
	
	$applyAll = 0;
	$selectedOther = 0;
	foreach $cl (@allClasses) {
		if ($cl eq "(ALL)") {
			$applyAll = 1;
		}
		if ($cl ne $Class) {
			$selectedOther = 1;
		}
	}
	
	if (@allClasses <= 0) {
		&showErrorBackHTML("You must choose one or more $corfs to edit.");
		exit();
	}
	
	if (($applyAll || $selectedOther) && !$forumadmin) {
		$nexturl = escape(&buildNextURL);
		print $CGIQuery->redirect("$CGI_ClassCreate?what=login&fid=$Class&nexturl=$nexturl");
		exit();
	}

	if ($forumadmin) {
		$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
	}
	
	$helplink = "file=ForumEnableDisableCORP_Admin.html";
	$helplink .= "&anchor=DisableForumEdtFSummary";
	$helplink .= "&helptitle=Enable/Disable%20".$CorFs."%20Edit%20Frame";
		
	&showHeaderBackHTML("Enable/Disable $CorFs",
						"", 0, 0, 0, $helplink, $cookie);

	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=func value=doedit>\n\n";

	if ($applyAll) {
		print "<input type=hidden name=classes value=\"(ALL)\">\n";
	
		print $FontRed, $FontSize2;
		print "<b>Warning: Changes will be applied to ALL $corfs.";
		print "</b></font></font><p>\n";
		
		print "<table border=0 cellpadding=0 cellspacing=2>\n";
		print "<tr><td bgcolor=$FTheaderback colspan=3>";
		print "<img src=$ImgSrcClearDot width=20 height=2>";
		print "</td></tr>\n";
		
		print "<tr><td colspan=3>", $FontFace, $FontSize, "<b>";
		print "ALL $CorFs</b>";
		print "</td></tr>\n";
		
		print "<tr><td valign=top>", $FontFace, $FontSize;
		print "<br><input type=radio name=\"disable\" value=0";
		print "> Enable<br>\n";
		print "<input type=radio name=\"disable\" value=1";
		print "> Disable\n";
		print "</td>\n";
		
		print "<td>$ImgClear88</td>\n";
		
		print "<td valign=top>", $FontFace, $FontSize;
		print "Message to Users (seen when disabled)<br>\n";
		print "<textarea rows=4 cols=72 name=\"text\" ";
		print "wrap=virtual>";
		$file = "./" . $FILE_DISABLED;
		if (-e $file) {
			open(f, $file);
			$text = join("", <f>);
			close(f);
			
			if ($text =~ /\<[^br].*\>/s) {
				print $text;
			} else {
				# Strip <br>'s
				$text =~ s/\<br\>//gs;
				print $text;
			}
		} else {
			print "This $CorF has been temporarily disabled. Please try ";
			print "again later.\n";
		}
		print "</textarea>\n";
		print "</td></tr>\n";
	} else {
		print "<table border=0 cellpadding=0 cellspacing=2>\n";
		
		foreach $cl (@allClasses) {
			print "<tr><td bgcolor=$FTheaderback colspan=3>";
			print "<img src=$ImgSrcClearDot width=20 height=2>";
			print "</td></tr>\n";
		
			print "<tr><td colspan=3>", $FontFace, $FontSize, "<b>";
			print $cl, " (", $cdata{$cl}{"title"}, ")</b>";
			print "</td></tr>\n";
		
			print "<tr><td valign=top>", $FontFace, $FontSize;
			print "<br><input type=radio name=\"", $cl, ".disable\" value=0";
			if ($cdata{$cl}{"disabled"} ne "1") {
				print " checked";
			}
			print "> Enable<br>\n";
			print "<input type=radio name=\"", $cl, ".disable\" value=1";
			if ($cdata{$cl}{"disabled"} eq "1") {
				print " checked";
			}
			print "> Disable\n";
			print "</td>\n";
			
			print "<td>$ImgClear88</td>\n";
			
			print "<td valign=top>", $FontFace, $FontSize;
			print "Message to Users<br>\n";
			print "<textarea rows=4 cols=72 name=\"", $cl, ".text\" ";
			print "wrap=virtual>";
			$file = $cdata{$cl}{"rootpath"} . "/" . $DIR_CONFIG . "/" . $FILE_DISABLED;
			if (-e $file) {
				open(f, $file);
				$text = join("", <f>);
				close(f);
			
				if ($text =~ /\<[^br].*\>/s) {
					print $text;
				} else {
					# Strip <br>'s
					$text =~ s/\<br\>//gs;
					print $text;
				}
			} else {
				print "This $CorF has been temporarily disabled. Please try ";
				print "again later.\n";
			}
			print "</textarea>\n";
			print "</td></tr>\n";
			
			print "<input type=hidden name=classes value=\"$cl\">\n\n";
		}
	}
				
	print "<tr><td bgcolor=$FTheaderback colspan=3>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	
	print "<tr><td colspan=3>";
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "</td></tr>\n";
	
	print "</table>\n";
	
	print "</form>\n</body></html>\n";
}

sub doedit {
	@subClasses = $CGIQuery->param('classes');
	
	if (@subClasses[0] eq "(ALL)") {
		$text  = $CGIQuery->param('text');
		$disable = $CGIQuery->param('disable');
		$file = "./" . $FILE_DISABLED;
		
		if (!$forumadmin) {
			$nexturl = escape(&buildNextURL);
			print $CGIQuery->redirect("$CGI_ClassCreate?what=login&fid=$Class&nexturl=$nexturl");
			exit();
		}
		
		# HTMLize text
		if ($text =~ /\</ && $text =~ /\>/) {
			# Assume already HTML - do validation
			open(safe, "| $safehtml -f $file");
			print safe $text;
			close(safe);
		} else {
			$text = &makeHTML($text);
			
			# Write out text file, regardless of enable/disable
			open(f, ">$file");
			print f $text;
			close(f);
		}
		
		# Turn on signal Handling
		$trapSignals = 1;
		
		if ($disable eq "1") {
			# Disable all forums
			foreach $cl (@allClasses) {
				&lookupClass($cl);
				if ($C_Disable <= 1) {
					$C_Disable += 2;
				}
				&setDisable($cl, $C_rootpath, $C_Disable);
			}
		} else {
			# Enable all forums
			foreach $cl (@allClasses) {
				&lookupClass($cl);
				if ($C_Disable >= 2) {
					$C_Disable -= 2;
				}
				&setDisable($cl, $C_rootpath, $C_Disable);
				
				if ($C_Disable > 0) {
					push(@stillDisabled, $cl);
				}
			}
		}
		
		# If we got a signal, exit here.
		if ($gotSignal) {
			close(DEVNULL);
			exit(0);
		}
		
		# Confirm for user
		if ($disable) {
			&showHeaderBackHTML("Disabled All $CorFs",
							"", 0, 0, 0, $helplink, $cookie);
			
			print "The following $CorFs have been disabled:\n";
			print "<ul>";
			foreach $cl (@allClasses) {
				print "<li>", $cl, " (", $cdata{$cl}{"title"}, ")\n";
			}
			print "</ul>\n";
		} else {
			&showHeaderBackHTML("Enabled All $CorFs",
							"", 0, 0, 0, $helplink, $cookie);
			
			print "The following $CorFs have been enabled:\n";
			print "<ul>";
			foreach $cl (@allClasses) {
				print "<li>", $cl, " (", $cdata{$cl}{"title"}, ")\n";
			}
			print "</ul>\n";
				
			if (@stillDisabled > 0) {
				print "<p>";
				print "The following $CorFs are still disabled:<br>\n";
				
				print "<ul>";
				foreach $cl (@stillDisabled) {
					print "<li>", $cl, " (", $cdata{$cl}{"title"}, ")\n";
				}
				print "</ul><p>\n";

				print "These $CorFs must be re-enabled individually, because ";
				print "they were originally disabled individually.\n";
			}
		}
	} else {
		foreach $cl (@subClasses) {
			$text = $CGIQuery->param($cl . '.text');
			$disable = $CGIQuery->param($cl . '.disable');
			
			$file = $cdata{$cl}{"rootpath"} . "/" . $DIR_CONFIG . "/" . $FILE_DISABLED;
			
			if (!$forumadmin && $cl ne $Class) {
				$nexturl = escape(&buildNextURL);
				print $CGIQuery->redirect("$CGI_ClassCreate?what=login&fid=$Class&nexturl=$nexturl");
				exit();
			}
			
			# HTMLize text
			if ($text =~ /\</ && $text =~ /\>/) {
				# Assume already HTML - do validation
				open(safe, "| $safehtml -f $file");
				print safe $text;
				close(safe);
			} else {
				$text = &makeHTML($text);
				
				# Write out text file, regardless of enable/disable
				open(f, ">$file");
				print f $text;
				close(f);
			}
		
			# Turn on signal Handling
			$trapSignals = 1;
		
			if ($disable eq "1") {
				# Disable forum
				&lookupClass($cl);
				if ($C_Disable == 0 || $C_Disable == 2) {
					$C_Disable += 1;
				}
				&setDisable($cl, $C_rootpath, $C_Disable);
				
				push(@disabled, $cl);
			} else {
				# Enable forum
				&lookupClass($cl);
				if ($C_Disable == 3 || $C_Disable == 1) {
					$C_Disable -= 1;
				}
				&setDisable($cl, $C_rootpath, $C_Disable);
				
				if ($C_Disable > 0) {
					push(@stillDisabled, $cl);
				} else {
					push(@enabled, $cl);
				}
			}
		}
		
		# If we got a signal, exit here.
		if ($gotSignal) {
			close(DEVNULL);
			exit(0);
		}
		
		# done with modifications. print web page
		&showHeaderBackHTML("Disabled/Enabled $CorFs",
							"", 0, 0, 0, $helplink, $cookie);
		
		if (@enabled > 0) {
			print "The following $CorFs have been enabled:\n";
			print "<ul>";
			foreach $cl (@enabled) {
				print "<li>", $cl, " (", $cdata{$cl}{"title"}, ")\n";
			}
			print "</ul><p>\n";
		}
		
		if (@disabled > 0) {
			print "The following $CorFs have been disabled:\n";
			print "<ul>";
			foreach $cl (@disabled) {
				print "<li>", $cl, " (", $cdata{$cl}{"title"}, ")\n";
			}
			print "</ul><p>\n";
		}
				
		if (@stillDisabled > 0) {
			print "<p>";
			print "The following $CorFs are still disabled:<br>\n";
			
			print "<ul>";
			foreach $cl (@stillDisabled) {
				print "<li>", $cl, " (", $cdata{$cl}{"title"}, ")\n";
			}
			print "</ul><p>\n";

			print "These $CorFs must be re-enabled by re-enabling ALL $CorFs,\n";
			print "because they were originally disabled globally.\n";
		}
	}
	
	print "<script language=javascript>\n<!--\n",
			"parent.disablemenu.document.location.reload();\n",
			"// -->\n</script>\n";
	
	print "</body></html>\n";
}

sub setDisable {
	local($c, $c_path, $val) = @_;
	local($dbfile, $retval, $status);
	$dbfile = $c_path . "/" . $DIR_CONFIG . "/" . $DBFILE_CLASSINFO;

	@retval = `$setDB $dbfile -thash -k \"C_Disable\" -d \"$val\"`;
	
	$status = &dbErrorCheck($?, @retval[0]);
	if ($status) {
		&showErrorBackHTML("$status<p>Unable to write to $dbfile. Check file permissions and try again.", 1);
		exit();
	}
}
