#!/usr/bin/perl

###############################################################################
#
# M_Init.pl - Message Deletion Functions
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:51 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: M_Init.pl,v 1.7.2.3 2001/08/21 17:50:51 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

1;

sub delFromMsg {
	local($subject, $id, $what) = @_;
	local($i, $j, $msgid, $key, $value, @keys, @values, @ids);
	local($topid) = "";
	
	if ($id =~ /\./) {
		@gettop = split(/\./, $id);
		$topid = @gettop[0];
	} else {
		$topid = $id;
	}

	# Start with the Message content db
	$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$subject/$topid" . ".db";
	
	if (! -e $dbfile) {
		return;
	}
	
	foreach (`$prtDB $dbfile -tbtree -a -q`) {
		($key, $value) = split(/\t/, $_);
		$value = &UnEscape($value);
		chomp($value);
		
		if ($what eq "thread" 
			 || ($what eq "children" && ($key =~ /^$id\./ || $key eq $id)) 
			 || ($what eq "single" && $key eq $id)) {
			push(@values, $value);
			push(@keys, $key);
		}
	}
	
	for ($j=0; $j < @keys; $j++) {
		$key = @keys[$j];
		#$err = $db->del("$key\0");
		
		@retval = `$delDB $dbfile -sn -tbtree -k \"$key\"`;
		$status = &dbErrorCheck($?, @retval[0]);
		
		if ($status) {
			print "$status: Couldn't Delete ID $key from $dbfile<br>\n";
		}
	}
	
	# Back up deleted messges
	$dbfile =~ s/\.db$/\.del\.db/;

	if ($MsgBackup) {
		for ($j=0; $j < @keys; $j++) {
			$key = @keys[$j];
			$value = @values[$j];
		
			$value = &Escape($value);
			$retval = `$setDB $dbfile -tbtree -q -sn -k \"$key\" -d \"$value\"`;
			# Ignore errors here. No big deal.
		}
	}		

	splice(@keys, 0);
	splice(@values, 0);
}	

sub delFromSubjThreads {
	local ($subject, $id, $what) = @_;
	local ($i, $j, $msgid, $key, $value, @keys, @values);
	local($topid) = "";

	if ($id =~ /\./) {
		@gettop = split(/\./, $id);
		$topid = @gettop[0];
	} else {
		$topid = $id;
	}

	$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$subject/$DBFILE_FTHREAD";
	
	if (! -e $dbfile) {
		return;
	}
	
	foreach (`$prtDB $dbfile -tbtree -a -q`) {
		($key, $value) = split(/\t/, $_);
		$value = &UnEscape($value);
		chomp($value);
		
		if (($what eq "thread" && ($key =~ /^$topid\./ || $key eq $topid)) 
			|| ($what eq "children" && ($key =~ /^$id\./ || $key eq $id)) 
			|| ($what eq "single" && $key eq $id)) {
			push(@values, $value);
			push(@keys, $key);
		}
	}
	
	for ($j=0; $j < @keys; $j++) {
		$key = @keys[$j];
		
		@retval = `$delDB $dbfile -sn -tbtree -k \"$key\"`;
		$status = &dbErrorCheck($?, @retval[0]);
		
		if ($status) {
			print "$status: Couldn't Delete ID $key from $dbfile<br>\n";
		}
	}

	$dbfile =~ s/\.db$/\.del\.db/;

	if ($MsgBackup) {
		for ($i=0; $i < @keys; $i++) {
			$key = @keys[$i];
			$value = @values[$i];
		
			$value = &Escape($value);
			$retval = `$setDB $dbfile -tbtree -q -sn -k \"$key\" -d \"$value\"`;
			# Ignore errors here. No big deal.
		}
	}

	splice(@keys, 0);
	splice(@values, 0);
}

sub delFromAuth {
	local ($subject, $id, $what, $gl) = @_;
	local ($i, $j, $msgid, $key, $value, @keys, @values, @gettop);
	local($topid) = "";

	if ($id =~ /\./) {
		@gettop = split(/\./, $id);
		$topid = @gettop[0];
	} else {
		$topid = $id;
	}

	if ($gl eq "global") {
		$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FAUTHOR";
	} else {
		$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$subject/$DBFILE_FAUTHOR";
	}
	
	if (! -e $dbfile) {
		return;
	}

	foreach (`$prtDB $dbfile -tbtree -a -q`) {
		($key, $value) = split(/\t/, $_);
		$value = &UnEscape($value);
		chomp($value);
		
		($junk, $junk, $msgid, $junk) = split(/\t/, $value);
	
		if (($what eq "thread" && ($msgid eq $topid || $msgid =~ /^$topid\./))
			 || ($what eq "children" && ($msgid eq $id || $msgid =~ /^$id\./))
			 || ($what eq "single" && $msgid eq $id)) {
			push(@values, $value);
			push(@keys, $key);
		} 
	}
	
	for ($j=0; $j < @keys; $j++) {
		$key = @keys[$j];
		
		@retval = `$delDB $dbfile -tbtree -k \"$key\"`;
		$status = &dbErrorCheck($?, @retval[0]);
		
		if ($status) {
			print "$status: Couldn't Delete ID $key from $dbfile<br>\n";
		}
	}

	$dbfile =~ s/\.db$/\.del\.db/;
	if ($MsgBackup) {
		for ($j=0; $j < @keys; $j++) {
			$key = @keys[$j];
			$value = @values[$j];
		
			$value = &Escape($value);
			$retval = `$setDB $dbfile -tbtree -q -san -k \"$key\" -d \"$value\"`;
			# Ignore Errors
		}
	}
	
	splice(@keys, 0);
	splice(@values, 0);
}

sub delFromReplies {
	local ($id, $what) = @_;
	local ($i, $j, $k, $msgid, $key, $value, @keys, @values);
	local($topid) = "";
	
	# This is really inefficient, since it goes through every user database.
	# This is to insure that every reference to the message gets deleted. If
	# This program gets interrupted, message remnants may be left. Therefore,
	# A thorough check must be done through all databases to make sure all
	# references to the specified messages are removed.
	
	$repdir = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DIR_FORUMREPLIES;
	@files = <$repdir/*.db>;

	if ($id =~ /\./) {
		@gettop = split(/\./, $id);
		$topid = @gettop[0];
	} else {
		$topid = $id;
	}
	
	for ($k=0; $k < @files; $k++) {
		$dbfile = @files[$k];
		
		if ($dbfile =~ /\.del\.db$/) {
			next;
		}
		
		foreach (`$prtDB $dbfile -tbtree -a -q`) {
			($key, $value) = split(/\t/, $_);
			$value = &UnEscape($value);
			chomp($value);
			
			($junk, $junk, $junk, $junk, $msgid, $junk) = split(/\t/, $value);
	
			if (($what eq "thread" && ($msgid eq $topid || $msgid =~ /^$topid\./))
				 || ($what eq "children" && ($msgid eq $id || $msgid =~ /^$id\./))
				 || ($what eq "single" && $msgid eq $id)) {
				push(@values, $value);
				push(@keys, $key);
			} 
		}
	
		for ($j=0; $j < @keys; $j++) {
			$key = @keys[$j];
			
			@retval = `$delDB $dbfile -tbtree -k \"$key\"`;
			$status = &dbErrorCheck($?, @retval[0]);
		
			if ($status) {
				print "$status: Couldn't Delete ID $key from $dbfile<br>\n";
			}
		}

		if ($MsgBackup) {
			if (@keys > 0) {
				$dbfile =~ s/\.db$/\.del\.db/;

				for ($j=0; $j < @keys; $j++) {
					$key = @keys[$j];
					$value = @values[$j];
				
					$value = &Escape($value);
					$retval = `$setDB $dbfile -tbtree -q -sna -k \"$key\" -d \"$value\"`;
					# Ignore Errors
				}
			}
		}
		
		splice(@keys, 0);
		splice(@values, 0);
	}
}

sub delFromNew {
	local ($id, $what) = @_;
	local ($i, $j, $k, $msgid, $key, $value, @keys, @values);
	local ($junk, $tot, $p, $r, $last, $x, $last2, $val);
	local ($topid) = "";

	if ($id =~ /\./) {
		@gettop = split(/\./, $id);
		$topid = @gettop[0];
	} else {
		$topid = $id;
	}

	$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FALL";
	if (! -e $dbfile) {
		$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FNEW";
	}
	
	foreach (`$prtDB $dbfile -tbtree -a -q`) {
		($key, $value) = split(/\t/, $_);
		$value = &UnEscape($value);
		chomp($value);
		
		($msgid, @junk) = split(/\t/, $value);
		
		if (($what eq "thread" && ($msgid eq $topid || $msgid =~ /^$topid\./))
			 || ($what eq "children" && ($msgid eq $id || $msgid =~ /^$id\./))
			 || ($what eq "single" && $msgid eq $id)) {
			push(@values, $value);
			push(@keys, $key);
			
			#######################################################
			# Rename any uploads here too!
			#######################################################
			
			$delfile = "$C_rootpath/$DIR_CLASSFORUM/$DIR_FORUMUPLOADS/";
			$delfile .= $msgid;
			
			# if (-e $delfile) { rename($delfile, $delfile . ".del"); }
			# Delete it, not rename it
			if (-e $delfile) { unlink($delfile); }
		}
	}

	for ($j=0; $j < @keys; $j++) {
		$key = @keys[$j];
		$value = @values[$j];

		################# Handle stats here too!!!
		($sec, $min, $hr, $day, $mon, $yr, $dow, $doy, $dls) = localtime($key);
		$mon += 1;
		if ($yr >= 100) {
			$yr = $yr - 100;
		}
		while(length($yr) < 2) {
			$yr = "0" . $yr;
		}
		while(length($mon) < 2) {
			$mon = "0" . $mon;
		}
		while(length($yr) < 2) {
			$day = "0" . $day;
		}
		$statdate = $mon . "." . $day . "." . $yr;
		
		$dbf = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_STATS";
		($junk, $val) = split(/\t/, `$prtDB $dbf -tbtree -k \"$statdate\"`);
		if ($val > 0) {
			$val = $val - 1;
		}
		@retval = `$setDB $dbf -tbtree -k \"$statdate\" -d \"$val\"`;
		$status = &dbErrorCheck($?, @retval[0]);
		if ($status) {
			print "$status: Couldn't Update Stats DB ($dbf) for $statdate.<br>\n";
		}
		
		($junk, $val) = split(/\t/, `$prtDB $dbf -tbtree -k \"_Total\"`);
		if ($val > 0) {
			$val = $val - 1;
		}
		@retval = `$setDB $dbf -tbtree -k \"_Total\" -d \"$val\"`;
		$status = &dbErrorCheck($?, @retval[0]);
		if ($status) {
			print "$status: Couldn't Update Stats DB ($dbf) for _Total.<br>\n";
		}
		
		($junk, $junk, $junk, $u, @junk) = split(/\t/, $value);
		($junk, $tot, $p, $r, $last, $x, $last2) = split(/\t/, `$prtDB $dbf -tbtree -k \"$u\"`);
		if ($tot > 0) {
			$tot = $tot - 1;
		}
		@val = split(/\t/, $value);
		if (@val[0] =~ /\./) {
			if ($r > 0) {
				$r = $r - 1;
			}
		} else {
			if ($p > 0) {
				$p = $p - 1;
			}
		}
		if ($last2 eq "$statdate" && $x > 0) {
			$x = $x - 1;
		}
		
		$val = $tot . "\\t" . $p . "\\t" . $r . "\\t" . $last . "\\t" . $x . "\\t" . $last2;
		@retval = `$setDB $dbf -tbtree -q -k \"$u\" -d \"$val\"`;
		$status = &dbErrorCheck($?, @retval[0]);
		if ($status) {
			print "$status: Couldn't Update Stats DB ($dbf) for $u.<br>\n";
		}
		################# End Stats
		
		################# Update subjects.db for number of posts
		# @val already contains value from new.db
		$topic = @val[1];
		$dbf = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FSUBJ";
		($junk, @subjval) = split(/\t/, `$prtDB $dbf -tbtree -k \"$topic\"`);
		if (@subjval[6] > 0) {
			@subjval[6] = @subjval[6] - 1;
		}
		$val = join("\\t", @subjval);
		@retval = `$setDB $dbf -tbtree -q -k \"$topic\" -d \"$val\"`;
		$status = &dbErrorCheck($?, @retval[0]);
		if ($status) {
			print "$status: Couldn't Update Topics DB ($dbf) for $topic.<br>\n";
		}
		################# End Update subjects.db
		
		################# Delete form new.db	
		@retval = `$delDB $dbfile -tbtree -k \"$key\"`;
		$status = &dbErrorCheck($?, @retval[0]);
		
		if ($status) {
			print "$status: Couldn't Delete ID $key from $dbfile<br>\n";
		}
		################# End Delete from new
	}

	$dbfile =~ s/\.db$/\.del\.db/;

	if ($MsgBackup) {
		for ($j=0; $j < @keys; $j++) {
			$key = @keys[$j];
			$value = @values[$j];
			
			$value = &Escape($value);
			$retval = `$setDB $dbfile -tbtree -q -sn -k \"$key\" -d \"$value\"`;
			# Ignore Errors
		}
	}

	splice(@keys, 0);
	splice(@values, 0);

}
