// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : trace.cpp
//
//  DESCRIPTION :
//         Auxiliary Trace class implementation
//
// #################################################################


// ===============
#include "trace.h"
// ===============


// ---------------------
size_t	ClassTrace::shift_s = 0;
size_t	ClassTrace::count_s = 0;


// ---------------------
ClassTrace::ClassTrace (
		const string&	file_name_i,
		size_t 		line_no_i,
		const string&	func_name_i,
		const string&	pretty_func_name_i,
		const string&	extra_info_str_i
		)
		:
		file_name_ (file_name_i),
		line_no_ (line_no_i),
		func_name_ (func_name_i),
		pretty_func_name_ (pretty_func_name_i),
		extra_info_vect_ (vector<string> ()),
		count_ (++count_s)
{
  shift_s++;
  show_trace ("ENTER", "", extra_info_str_i, line_no_);
}
		

// ---------------------
ClassTrace::~ClassTrace ()
{
  show_trace ("EXIT", "", "", 0);
  shift_s--;
}


// ---------------------
void ClassTrace::show_trace (
		const string& step_i, 
		const string& msg_i, 
		const string& extra_info_i, 
		size_t line_no_i
		)
{
#define	ALIGN_VAL1	5
  // assert (ALIGN_VAL1 > shift_s);

  if (!extra_info_i.empty())
  {
    extra_info_vect_.push_back (extra_info_i);
  }
  tout	<< ""
	<< std::right
	<< setw (4)
	<< setfill (' ')
	<< count_
	<< " ->:   "
	<< string (shift_s - 1, ' ')
	<< setw (ALIGN_VAL1)
	<< std::left
	<< step_i
	// << setw (ALIGN_VAL1 - shift_s)
	<< ""
	<< " [ "
	<< std::left
	<< setw (12)
	<< file_name_
	<< " , #"
	<< std::right
	<< setw(4)
	<< ((line_no_i)	? to_string(line_no_i) : string())
	<< ";  "
	<< std::left
	<< setw (12)
	<< func_name_
	// << pretty_func_name_
	<< " ]  ";

  if (!msg_i.empty())
  {
    tout << msg_i << " === ";
  }

  copy (
	extra_info_vect_.begin(), 
	extra_info_vect_.end(),
	ostream_iterator<string> (tout, " --- ")
	);

  tout	<< endl;
}




