// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : server.h
//
//  DESCRIPTION :
//         Server related class definition
//
// #################################################################


/////////////////////////
#ifndef INCLUDED_SERVER_H
#define INCLUDED_SERVER_H
/////////////////////////


// ==================
#include "partner2.h"
// ==================


// ---------------------------
class PreServer : public BasicPartner
{
  private :

  protected :
    TCPSocketWrapper	sockserver_;

  public :
    // Constructor-1
    PreServer (int ip_port_no_i);

    // Destructor
    ~PreServer ();

};



// ---------------------------
class ServerRun	: public PreServer
{
friend class ApplicationRun;

  private :
    TCPSocketWrapper	sock_;
    TCPStream		stream_;

    // -----------------------------
    string	get_outcoming_packet_desr () const;
    string	get_incoming_packet_desr () const;

    string	get_peer_name () const;

    string	get_peer_ip_address() const;
    string	get_connected_client_ip_address () const;
    string	get_connection_ip_desr () const;

    void	set_local_sent_packets ();
    void	set_local_recv_packets ();

    void	read_from_stream (string& data_o);
    bool	write_to_stream (const string& data_i, const string& msg_i = string());

    void	demo1 ();

  public :
    // Constructor-1
    ServerRun (int ip_port_no_i);

    // Destructor
    ~ServerRun ();

};

//////
#endif
//////

