// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : demotype.h
//
//  DESCRIPTION :
//         User defined class definition for Demo2 application
//
// #################################################################


///////////////////////////
#ifndef INCLUDED_DEMOTYPE_H
#define INCLUDED_DEMOTYPE_H
///////////////////////////


// =================
#include "packet2.h"
// =================


// ---------------------------

#define Too_IO_PREFIX	'('
#define Too_IO_DELIM	'-' // If Too_IO_DELIM == ' ' then it is necessary to redefine operator>> and operator<<
#define Too_IO_SUFFIX	')'
#define Too_IO_SPACE	' '
#define Too_IO_TAB	'\t'

// ---------------------------
// User_Defined_Demo_Type
class Too
{
friend istream& operator>> (istream& is, Too& instance_o);
friend ostream& operator<< (ostream& os, const Too& instance_i);

  private :
    string	var1_;	// Must not contain Too_IO_DELIM
    int		var2_;
    string	var3_;	// Must not contain Too_IO_DELIM
    string	var4_;	// Must not contain Too_IO_DELIM
    string	var5_;	// Must not contain Too_IO_DELIM

  public :
    Too (
	const string&	var1_i = "VAR1",
	int		var2_i = 0, 
	const string&	var3_i = "VAR3",
	const string&	var4_i = "VAR4",
	const string&	var5_i = "VAR5"
	);
    ~Too ();

   string get_var1 () const;
   int    get_var2 () const;
   string get_var3 () const;
   string get_var4 () const;
   string get_var5 () const;

};

istream&        operator>> (istream& is, Too& instance_o);
ostream&        operator<< (ostream& os, const Too& instance_i);


//////
#endif
//////


