// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : client.h
//
//  DESCRIPTION :
//         Client related class definition
//
// #################################################################


/////////////////////////
#ifndef INCLUDED_CLIENT_H
#define INCLUDED_CLIENT_H
/////////////////////////


// ==================
#include "partner2.h"
// ==================


// ---------------------------
class ClientRun : public BasicPartner
{
friend class ApplicationRun;

  private :
    const string	ip_server_address_;
    TCPClientStream	stream_;

    // -------------------------------
    bool	check_ip_server_address () const;
    string	get_ip_server_address () const;
    string	get_peer_ip_address() const;

    string	get_connection_ip_desr () const;

    string	get_peer_name () const;

    string	get_outcoming_packet_desr () const;
    string	get_incoming_packet_desr () const;

    void	set_local_sent_packets ();
    void	set_local_recv_packets ();

    void	read_from_stream (string& data_o);
    bool	write_to_stream (const string& data_i, const string& msg_i);

    size_t read_size_from_stream();

    void demo1 ();


  public :
    // Constructor-1
    ClientRun (int ip_port_no_i, const string& ip_server_address_i);

    // Destructor
    ~ClientRun ();

};

//////
#endif 
//////

