<%@ Language=VBScript %>
<%Option Explicit%>
<%
On Error Resume Next
' Response.Expires = -1

' check whether the logged on user can access this page
If Session("AppUserID") = "" Then
	Response.Redirect "UserLogon.asp"
End If

Const cPageTitle = "Log Reports"

Dim m_sql
Dim m_textSql
Dim objGsElg
Set objGsElg = Server.CreateObject("GsElgReportsCom.Reports")

Dim m_objXml
Set m_objXml = Server.CreateObject("Microsoft.XMLDom")

' selected menu item id's
Dim m_sServerLogTypeFilter
Dim m_sELSource
Dim m_sEventType
Dim m_sEventID
Dim m_sEventIDExclude
Dim m_sEventCategory

Dim m_check_all	' set it to "checked" where loading first time

'form fields
Dim m_sel_DateRange
Dim m_chk_DateRange
Dim m_chk_EventID
Dim m_txtStartDate
Dim m_txtEndDate
Dim m_sRefresh

Dim m_nSelectedPage
Dim m_nSortOrder
Dim m_sSortBy
Dim m_nPageSize
Dim m_nPageOfPagesSize
Dim m_SavedReportDescription

Dim m_alertHdrID

m_sServerLogTypeFilter = Request.Form("hServerLogTypeFilter")
m_sELSource = Request.Form("hELSource")
m_sEventType = Request.Form("hEventType")
m_chk_EventID = Request.Form("chk_EventID")
m_sEventID = Request.Form("txtEventID")
m_sEventCategory = Request.Form("hEventCategory")

m_sEventIDExclude = Request.Form("radio_EventIDExclude")
If m_sEventIDExclude = "" Then
	m_sEventIDExclude = "include"
End If

m_sRefresh = Request.Form("hRefresh")

If m_sRefresh = "" Then 'loading first time.  check all the check boxes
	m_check_all = "checked"
Else
	m_check_all = ""
End If

m_sel_DateRange = Request.Form("sel_DateRange")
m_chk_DateRange = Request.Form("chk_DateRange")
m_txtStartDate = Request.Form("txtStartDate")
m_txtEndDate = Request.Form("txtEndDate")
If m_sel_DateRange = "" Then	' default to today
	m_sel_DateRange = 0
End If
If m_txtEndDate = "" Then	' default to today
	m_txtEndDate = Date()
	m_txtEndDate = DateAdd("d", 1, m_txtEndDate)
End If
If m_txtStartDate = "" Then	' default to today
	m_txtStartDate = Date()
End If

m_nSelectedPage = Request.Form("hSelectedPage")
If m_nSelectedPage = "" Then
	m_nSelectedPage = 1
End If

m_nSortOrder = Request.Form("hSortOrder")
If m_nSortOrder = "" Then
	m_nSortOrder = 1
End If

m_sSortBy = Request.Form("hSortBy")
If m_sSortBy = "" Then
	m_sSortBy = "TimeGenerated"
End If

m_nPageSize = Request.Form("hPageSize")
if m_nPageSize = "" Then
	m_nPageSize = Application("PageSize")
End If

m_nPageOfPagesSize = Request.Form("hPageOfPagesSize")
if m_nPageOfPagesSize = "" Then
	m_nPageOfPagesSize = Application("PageOfPagesSize")
End If

m_SavedReportDescription = Request.Form("hSavedReportDescription")

' alert
m_alertHdrID = Request.Form("hAlertHdrID")
%>
<%

Function MakeMenu()
	Dim strServer 
	Dim strPath
	Dim objXml
	Dim root
	Dim nRetVal
	Dim sXml
		
	' create XML instance for menu items
	nRetVal = objGsElg.MenuXmlGet(sXml)
	If nRetVal <> 0 Then
		Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=GsElgReportPage.asp';</script>"
		Response.End
	End If	
		
	Set objXml = Server.CreateObject("Microsoft.XMLDom")
	objXml.loadXml(sXml)
	Set root = objXml.documentElement

	' create the tree	
	nRetVal = XmlTreeIterate(root)
	
End Function

Function XmlTreeIterate(el)
	Dim nRetVal
	Dim objChildren
	Dim objChildNode
	Dim bHideChildren
	
	If el.GetAttribute("ParentID") <> "null" And el.GetAttribute("LogTypeID") = "0" Then
		bHideChildren = True
	Else
		bHideChildren = False
	End If	

	Response.Write "<table class=""tblMenu"" cellspacing=""1"" cellpadding=""0"" border=""0"">"
	
	' create menu node
	Response.Write "<tr ID=""sup_" & el.GetAttribute("ID") & """><td><image onclick=""MenuIconOnClick()"" id=""ico_" & el.GetAttribute("ID") & """ align=""absmiddle"" src="""
	' hide log types branches
	If bHideChildren Then
		Response.Write el.GetAttribute("IconClosed") & """></td><td>"
	Else
		Response.Write el.GetAttribute("IconOpened") & """></td><td>"
	End If
	Response.Write "<input value=""checked"" NAME=""cks_" & el.GetAttribute("ID") & """ ID=""cks_" & el.GetAttribute("ID") & """ ParentID=""cks_" & el.GetAttribute("ParentID") & """ type=""checkbox"" onclick=""MenuCheckOnClick()"" " & Request.Form("cks_" & el.GetAttribute("ID")) & " ServerID=""" & el.GetAttribute("ServerID") & """ LogTypeID=""" & el.GetAttribute("LogTypeID") & """ " & m_check_all & ">"
	Response.Write "<label id=""lab_" & el.GetAttribute("ID") & """ onmouseover=""MenuOnMouseOver()"" onmouseout=""MenuOnMouseOut()"" for=""cks_" & el.GetAttribute("ID") & """>" & el.getAttribute("DisplayText") & "</label></td></tr>"

	' may have some children
	Set objChildren = el.childNodes
	If objChildren.length > 0 Then
		If bHideChildren Then
			Response.Write "<tr ID=""sub_" & el.GetAttribute("ID") & """ style=""display:none""><td>&nbsp;</td><td>"
		Else
			Response.Write "<tr ID=""sub_" & el.GetAttribute("ID") & """><td>&nbsp;</td><td>"
		End If
		
		For Each objChildNode in objChildren
			nRetVal = XmlTreeIterate(objChildNode)
		Next
		Response.Write "</td></tr>"
	End If
	
	Response.Write "</table>"
	
	XmlTreeIterate = 0
End Function

' get global variables and load them into the DOM instance
Function GatherQueryParameters(ByRef objXml)
	Dim curEl
	Dim newEl
	Dim nRetVal

	'set attributes using global variables
	Set curEl = objXml.documentElement
	Call curEl.setAttribute("PageSize", m_nPageSize)
	Call curEl.setAttribute("PageOfPagesSize", m_nPageOfPagesSize)
	Call curEl.setAttribute("SelectedPage", m_nSelectedPage)
	
	' set query parameters
	Set newEl = objXml.CreateElement("QueryParameters")
	
	Call newEl.setAttribute("ServerLogTypeFilter", m_sServerLogTypeFilter)
	
	If m_chk_DateRange <> "" Then
		Call newEl.setAttribute("StartDate", m_txtStartDate)
		Call newEl.setAttribute("EndDate", m_txtEndDate)
	End If

	If m_sELSource <> "" And InStr(1, m_sELSource, "All") <= 0 Then
		Call newEl.setAttribute("ELSource", m_sELSource)
	End If

	If m_sEventType <> "" And InStr(1, m_sEventType, "All") <= 0 Then
		Call newEl.setAttribute("EventType", m_sEventType)
	End If

	If m_chk_EventID <> "" Then
		Call newEl.setAttribute("EventID", m_sEventID)
		Call newEl.setAttribute("EventIDExclude", m_sEventIDExclude)
	End If

	If m_sEventCategory <> ""  And InStr(1, m_sEventCategory, "All") <= 0 Then
		Call newEl.setAttribute("EventCategory", m_sEventCategory)
	End If
	
	Call newEl.setAttribute("SortBy", m_sSortBy)
	If m_nSortOrder = 1 Then
		Call newEl.setAttribute("SortOrder", "DESC")
	Else	
		Call newEl.setAttribute("SortOrder", "ASC")
	End If
	
	objXml.documentElement.appendChild(newEl)
	
	GatherQueryParameters = nRetVal
End Function

Function PageLinksDisplay(ByRef objXml)
	Dim objPageLinkList
	Dim objPl
	
	Set objPageLinkList = objXml.selectNodes("//PageLink")

	Response.Write "<td colspan=""6"">&nbsp;"
	For Each objPl In objPageLinkList
		If objPl.GetAttribute("PageNumberText") = "Next" Then
			Response.Write "&nbsp;&nbsp;"
		End If
		
		If objPl.getAttribute("ShowLink") = 1 Then
			Response.Write "<a href=""JavaScript:LoadPage(" & objPl.getAttribute("PageNumber") & ")"">"
		Else
			Response.Write "<font color=""red"">"
		End If

		Response.Write objPl.getAttribute("PageNumberText")
		
		If objPl.getAttribute("ShowLink") = 1 Then
			Response.Write "</a>"
		Else
			Response.Write "</font>"
		End If

		If objPl.GetAttribute("PageNumberText") = "Prev" Then
			Response.Write "&nbsp;&nbsp;"
		End If

		Response.Write " "
	Next
	
	Response.Write "</td>"
	Response.Write "<td colspan=""5"" align=""right"">Record count: " & objXml.documentElement.getAttribute("RecordCount") & "&nbsp;&nbsp;Page count: " & objXml.documentElement.getAttribute("PageCount") & "</td>"
	End Function

Function LogEntriesDisplay(ByRef objXml)
	Dim nRetVal
	nRetVal = 0
	Dim objRoot
	Dim objElList
	Dim objEl
	Dim sBgColor
	
	Set objRoot = objXml.documentElement
	Set objElList = objRoot.SelectNodes("LogEntry")

	
	sBgColor = "white"
	For Each objEl In objElList
		If sBgColor = "whitesmoke" Then
			sBgColor = "white"
		Else
			sBgColor = "whitesmoke"
		End If

		Response.Write "<tr style=""background:" & sBgColor & """>"
		Response.Write "<td valign=""top"">" & objEl.getAttribute("ELServerName") & "</td>"
		Response.Write "<td valign=""top"">" & objEl.getAttribute("LogTypeName") & "</td>"
		Response.Write "<td valign=""top"">" & objEl.getAttribute("RecordNumber") & "</td>"
		Response.Write "<td valign=""top"">" & objEl.getAttribute("TimeGenerated") & "</td>"
		Response.Write "<td valign=""top"">" & objEl.getAttribute("EventID") & "</td>"
		Response.Write "<td valign=""top""><img align=""absmiddle"" src=""images/" & objEl.getAttribute("EventTypeCode") & ".gif"">&nbsp;" & objEl.getAttribute("EventTypeName") & "</td>"
		Response.Write "<td valign=""top"">" & objEl.getAttribute("EventCategoryName") & "</td>"
		Response.Write "<td valign=""top"">" & objEl.getAttribute("ELUserName") & "</td>"
		Response.Write "<td valign=""top"">" & objEl.getAttribute("ELSourceName") & "</td>"
		Response.Write "<td valign=""top"">" & objEl.getAttribute("FullMessage") & "</td>"
		Response.Write "</tr>"
	Next
	
	' Response.Write Server.HTMLEncode(objXml.xml)
	
	LogEntriesDisplay = nRetVal
End Function

Function LogEntriesMakeXml(ByRef objXml)
	Dim nRetVal
	Dim sql
	Dim sXml

	objXml.loadXml("<ResultsPage><HeaderInfo /></ResultsPage>")
	
	' get the query string params and load them into the XML tree
	nRetVal = GatherQueryParameters(objXml)

	' generate SQL query
	nRetVal = objGsElg.SqlQueryGenerate(objXml.documentElement.SelectSingleNode("QueryParameters").xml, sql)
	If nRetVal <> 0 Then
		Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=GsElgReportPage.asp';</script>"
		Response.End
	End If

	 m_sql = sql ' save the sql query in the global variable
	 
	 ' create the SQL query to be displayed in the browser
	m_textSql = objGsElg.TextSqlMake(m_sql)
	
	' get the results id's
	sXml = objXml.xml
	nRetVal = objGsElg.LogEntryPageIdsGetFromDB(sql, sXml)
	If nRetVal < 0 Then
		Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=GsElgReportPage.asp';</script>"
		Response.End
	End If	
	
	If nRetVal = 0 Then
		'get the page details
		nRetVal = objGsElg.LogEntryPageDetailsGetFromDB(sXml)
		If nRetVal <> 0 Then
			Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=GsElgReportPage.asp';</script>"
			Response.End
		End If
	ElseIf nRetVal = 203 Then
		Response.Write "<font color=""red"">No records found</font>"
	End If
	objXml.loadXml sXml
	
	LogEntriesMakeXml = nRetVal
End Function

Function TwoFieldListGet(sSpName, sTagNameSuffix)
	Dim nRetVal
	Dim sBuff
	Dim sOut
	Dim objXml
	Dim objXmlNodes
	Dim objXmlNode
	Dim sXml

	nRetVal = objGsElg.TwoFieldListFromDBGet(sSpName, sXml)
	If nRetVal <> 0 Then
		Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=GsElgReportPage.asp';</script>"
		Response.End
	End If	
	
	Set objXml = Server.CreateObject("Microsoft.XMLDom")
	objXml.loadXml sXml

	Set objXmlNodes = objXml.documentElement.selectNodes("NODE")
	For Each objXmlNode In objXmlNodes
		sBuff = sTagNameSuffix & objXmlNode.getAttribute("Field0")
		sOut = "<tr><td><input onclick=""MenuCheckOnClick()"" type=""checkbox"" name=""" & sBuff & """ ID=""" & sBuff & """ ParentID=""" & sTagNameSuffix & "All"""
		sOut = sOut & " value=""" & objXmlNode.getAttribute("Field0") & """ "
		If Request.Form(sBuff) <> "" Then ' selected
			sOut = sOut & " checked"
		End If
		sOut = sOut & " " & m_check_all & ">" & objXmlNode.getAttribute("Field1")
		sOut = sOut & "</td></tr>"
		Response.Write(sOut)

	Next	
End Function

Function TextSqlMake(sql)
	Dim idx
	Dim orderBy
	
	sql = Replace(sql, "'", "\'")
	idx = InStr(1, sql, "FROM")
	sql = Right(sql, Len(sql)-idx+1)
	
	idx = InStr(1, sql, "ORDER BY")
	orderBy = Right(sql, Len(sql)-(idx+8))
	sql = Left(sql, idx-1)
	
	sql = "SELECT LEID " & sql

	sql = "select le.LEID,s.ELServerName,lt.LogTypeName,le.RecordNumber,le.TimeGenerated,le.EventID,et.EventTypeCode,et.EventTypeName,ec.EventCategoryID,ec.EventCategoryName,elu.ELUserName,els.ELSourceName,le.FullMessage,le.CreatedAt FROM " _
	& "(" & sql & ")d " _
	& ",LogEntry le,ELServer s,LogType lt,EventType et,EventCategory ec,ELUser elu,ELSource els " _
	& "WHERE	le.LEID = d.LEID AND le.ELServerID = s.ELServerID AND le.LogTypeID = lt.LogTypeID AND le.EventTypeID = et.EventTypeID AND le.EventCategoryID = ec.EventCategoryID AND le.ELUserID = elu.ELUserID AND le.ELSourceID = els.ELSourceID " _
	& "ORDER BY le." & orderBy
	
	TextSqlMake = sql
End Function
%>
<!--
GsElg Reports Version 1.5 
Copyright 2002-2003 Gravity Square, Inc. - http://www.gravitysquare.com
Developed by Alpentia Software. Inc. - http://www.alpentia.com
-->
<HTML>
	<HEAD>
		<title>GsElg Reports - <%=cPageTitle%></title>
		<link rel="STYLESHEET" href="stylesheets/style.css">
		</link>
		<script language="JavaScript" src="scripts/global.js"></script>
		<script language="JavaScript">

var checkBoxTree = new ActiveXObject("Msxml2.DOMDocument");

function FormValidate(){
	if(frmMain.hServerLogTypeFilter.value == 'ERROR'){
		alert('Select servers and log types.')
		return false;
	}

	else if(frmMain.chk_DateRange.checked){
		if(!Date.parse(frmMain.txtStartDate.value)){
			alert('Invalid start date');
			return false;
		}
		if(!Date.parse(frmMain.txtEndDate.value)){
			alert('Invalid end date');
			return false;
		}
	}

	// filter values
	else if(frmMain.hELSource.value == ''){
		alert('Invalid Source Name selection.')
		return false;
	}
	else if(frmMain.hEventType.value == ''){
		alert('Invalid Event Type selection.')
		return false;
	}
	else if(frmMain.chk_EventID.checked == true && frmMain.txtEventID.value == ''){
		alert('Invalid Log ID(s)')
		return false;
	}
	else if(frmMain.hEventCategory.value == ''){
		alert('Invalid Event Category selection.')
		return false;
	}


	return true;
}

function QuerySubmit()
{
	OptionsQueryCreate();
	ServerAndLogTypeFilterMake();
	PredefinedDateRangeSet();

	if(FormValidate() == false){
		return false;
	}

	// re-enable tags.  Otherwise, the values will not be submitted with the form
	frmMain.sel_DateRange.disabled = false;
	frmMain.txtStartDate.disabled = false;
	frmMain.txtEndDate.disabled = false;
	return true;
}

function SaveLogReportOnClick()
{
	OptionsQueryCreate();
	ServerAndLogTypeFilterMake();
	PredefinedDateRangeSet();

	if(FormValidate() == false){
		return false;
	}

	// re-enable tags.  Otherwise, the values will not be submitted with the form
	frmMain.sel_DateRange.disabled = false;
	frmMain.txtStartDate.disabled = false;
	frmMain.txtEndDate.disabled = false;

	frmMain.action = 'SaveLogReport.asp';
	frmMain.submit();
	return true;
}

// create alert based on the filter criteria
function CreateAlertOnClick()
{
	OptionsQueryCreate();
	ServerAndLogTypeFilterMake();

	// re-enable tags.  Otherwise, the values will not be submitted with the form
	frmMain.sel_DateRange.disabled = false;
	frmMain.txtStartDate.disabled = false;
	frmMain.txtEndDate.disabled = false;
	
	// disable time filter
	frmMain.chk_DateRange.checked = false;

	if(FormValidate() == false){
		return false;
	}

	frmMain.action = 'AlertDetail.asp';
	frmMain.submit();
	return true;
}

function ReSort(sSortBy, nSortOrder){
	OptionsQueryCreate();
	ServerAndLogTypeFilterMake();
	PredefinedDateRangeSet();

	frmMain.hSortBy.value = sSortBy;
	if(nSortOrder == 1){
		nSortOrder = 0;
	}
	else{
		nSortOrder = 1;
	}
	frmMain.hSortOrder.value = nSortOrder;
	
	if(FormValidate() == false){
		return false;
	}

	// re-enable tags.  Otherwise, the values will not be submitted with the form
	frmMain.sel_DateRange.disabled = false;
	frmMain.txtStartDate.disabled = false;
	frmMain.txtEndDate.disabled = false;

	frmMain.submit();
}

function LoadPage(nPage){
	OptionsQueryCreate();
	ServerAndLogTypeFilterMake();
	PredefinedDateRangeSet();

	frmMain.hSelectedPage.value = nPage;
	if(FormValidate() == false){
		return false;
	}


	// re-enable tags.  Otherwise, the values will not be submitted with the form
	frmMain.sel_DateRange.disabled = false;
	frmMain.txtStartDate.disabled = false;
	frmMain.txtEndDate.disabled = false;

	frmMain.submit();
}

function FilterPlusOnClick()
{
	var el = window.event.srcElement;
	var elChild;
	var elid = el.id;
	var idToHideShow = elid.replace('img_', 'tbl_');
	
	elChild = document.all.item(idToHideShow);
	if(elChild.style.display== 'none'){
		elChild.style.display = '';
		el.src = 'images/minus.gif';
	}
	else{
		elChild.style.display= 'none';
		el.src = 'images/plus.gif';
	}
}

// construct the other options query string
function OptionsQueryCreate(){
	var objInput;
	var nIdx = 0;
	var objNodes = document.all.tags('input');
	var nLength = objNodes.length;
	var sBuff;
	var sCurFilterName = '-1';
	
	sBuff = '';
	
	for(nIdx = 0; nIdx < nLength; nIdx++){
		objInput = objNodes[nIdx];
		if(objInput.id.substr(0, 4) == 'ckf_'){
			if(objInput.id.indexOf(sCurFilterName) == 0){	//check if we are within the same filter group
			}	
			else{	// new region -- reset variables
				if(sCurFilterName != '-1'){
					sBuff = sBuff.substr(0, sBuff.length-1);
					frmMain(sCurFilterName.replace('ckf_', 'h')).value = sBuff;
				}
				sBuff = '';
				
				sCurFilterName = (objInput.id).replace('_All', '');
			}
		
			if(objInput.checked == true){
				sBuff = sBuff + objInput.value + ',';
//				alert(sBuff);
			}
		}

	}
	// last group, which is outside of the main loop
	if(sCurFilterName != '-1'){
		sBuff = sBuff.substr(0, sBuff.length-1);
		frmMain(sCurFilterName.replace('ckf_', 'h')).value = sBuff;
	}
}

// construct the list of server and log types to be used in the query
function ServerAndLogTypeFilterMake(){
	var objInput;
	var nIdx = 0;
	var objNodes = document.all.tags('input');
	var nLength = objNodes.length;
	var sOr = '';
	var sBuff;
	var nServerID
	var nCurServerID = -1;
	var nLogTypeID

	// no nodes
	if(nLength == 0){
		m_sServerLogTypeFilter = 'ERROR';
		return;
	}
	
	sBuff = '';
	for(nIdx = 0; nIdx < nLength; nIdx++){
		objInput = objNodes[nIdx];
		if(objInput.id.substr(0, 4) == 'cks_' && objInput.checked == true){
			nServerID = objInput.getAttribute('ServerID');
			nLogTypeID = objInput.getAttribute('LogTypeID');
		
			// if all servers are checked, then we don't need a filter
			if(nServerID == 0){	// all servers
				sBuff = '';
				nCurServerID = 0;
				break;
			}
			else if(nCurServerID != nServerID){
				if(nLogTypeID == 0){	// one server, all logs
					sBuff = sBuff + sOr + '(ELServerID=' + nServerID + ')';
					sOr = ' OR ';
					nCurServerID = nServerID; // don't do it more than once
				}
				else{ // selective logs
					sBuff = sBuff + sOr + '(ELServerID=' + nServerID + ' AND LogTypeID=' + nLogTypeID + ')';
					sOr = ' OR ';
				}
			}
		}
	}
	
	if(nCurServerID != -1){
		if(sBuff.length > 0){
			sBuff = '(' + sBuff + ')';
		}
		frmMain.hServerLogTypeFilter.value = sBuff;
	}
	else if(sBuff != ''){
		frmMain.hServerLogTypeFilter.value = '(' + sBuff + ')';
	}
	else{
		frmMain.hServerLogTypeFilter.value = 'ERROR';
	}
}

function FilterCheckOnClick(){
	var el = window.event.srcElement;

	if(el.id == 'chk_DateRange'){
		if(frmMain(el.id).checked){
			frmMain.sel_DateRange.disabled = false;
			SelDateRangeOnChange();
		}
		else{
			frmMain.sel_DateRange.disabled = true;
			frmMain.txtStartDate.disabled = true;
			frmMain.txtEndDate.disabled = true;
		}
	}
	else if(el.id == 'chk_EventID'){
		if(frmMain(el.id).checked){
			frmMain.txtEventID.disabled = false;
			frmMain.radio_IDEventIDInclude.disabled = false;
			frmMain.radio_IDEventIDExclude.disabled = false;
		}
		else{
			frmMain.txtEventID.disabled = true;
			frmMain.radio_IDEventIDInclude.disabled = true;
			frmMain.radio_IDEventIDExclude.disabled = true;
		}
	}
}

function BodyOnLoad(){
	CheckBoxTreeMake();
	
	// get the root checkbox and check the children if necessary
	var el = checkBoxTree.documentElement.selectSingleNode("input")
	if(el.getAttribute("checked") == "true"){
		MenuCheckChildren(el);
	}

	// initialize date selection tags
	SelDateRangeOnChange();
}

function CheckBoxTreeMake(){
	var el = null;
	var objNodes = document.all.tags('input');
	var nLength = objNodes.length;
	var tempNode
	var tempNew

	checkBoxTree.loadXML("<CheckBoxTree />");

	// insert the checkboxes into the Xml doc
	for(nIdx = 0; nIdx < nLength; nIdx++){
		el = objNodes[nIdx];
		
		// see if the node's parent is in the tree
		if((el.id.indexOf('cks_') >= 0 || el.id.indexOf('ckf_') >= 0)){
			tempNode = checkBoxTree.selectSingleNode("//input[@id='" + el.ParentID + "']");
			tempNew = checkBoxTree.createElement("input");

			tempNew.setAttribute('id', el.getAttribute('id'));
			tempNew.setAttribute('name', el.getAttribute('name'));
			if(el.getAttribute('CHECKED')){
				tempNew.setAttribute('checked', 'true');
			}
			else{
				tempNew.setAttribute('checked', 'false');
			}			

			if(tempNode != null){
				tempNew.setAttribute('ParentID', el.ParentID);
				tempNode.appendChild(tempNew);
			}
			else{
				checkBoxTree.documentElement.appendChild(tempNew);
			}
		}
	}		
}

function SelDateRangeOnChange(){
	if(frmMain.sel_DateRange.disabled == false && frmMain.sel_DateRange.selectedIndex == 0){
		frmMain.txtStartDate.disabled = false;
		frmMain.txtEndDate.disabled = false;
	}
	else{
		frmMain.txtStartDate.disabled = true;
		frmMain.txtEndDate.disabled = true;
	}
}

function PredefinedDateRangeSet(){
	if(frmMain.chk_DateRange.checked == true && frmMain.sel_DateRange.selectedIndex != 0){
		// compute start end end dates
		var datNow = new Date();
		var datTemp;
		var nTemp;
		var sBuff;
		
		// calc end of today
		datTemp = new Date(datNow.getMonth()+1 + '/' + datNow.getDate() + '/' + datNow.getYear());
		nTemp = datTemp.valueOf() + (24*3600*1000)
		datTemp = new Date(nTemp);
		
		frmMain.txtEndDate.value = datTemp.getMonth()+1 + '/' + datTemp.getDate() + '/' + datTemp.getYear();
		
		switch(frmMain.sel_DateRange.selectedIndex){
			case 1:		// last hour
				nTemp = datNow.valueOf() - 3600*1000;
				datTemp = new Date(nTemp)
				break;
			case 2:		// today
				datTemp = new Date(datNow.getMonth()+1 + '/' + datNow.getDate() + '/' + datNow.getYear() + ' ' + '00:00');
				break;
			case 3:		// last 24 hours
				nTemp = datNow.valueOf() - 24*3600*1000;
				datTemp = new Date(nTemp)
				break;
			case 4:		// last 7 days
				nTemp = datNow.valueOf() - 7*24*3600*1000;
				datTemp = new Date(nTemp)
				datTemp = new Date(datTemp.getMonth()+1 + '/' + datTemp.getDate() + '/' + datTemp.getYear() + ' ' + '00:00');
				break;
			case 5:		// this month
				datTemp = new Date(datNow.getMonth()+1 + '/1/' + datNow.getYear() + ' ' + '00:00');
				break;
			case 6:		// last 30 days
				nTemp = datNow.valueOf() - 30*24*3600*1000;
				datTemp = new Date(nTemp)
				datTemp = new Date(datTemp.getMonth()+1 + '/' + datTemp.getDate() + '/' + datTemp.getYear() + ' ' + '00:00');
				break;
			default:
				alert('Unsupported date range');
				return -1;
		}

		sBuff = datTemp.getMonth()+1 + '/' + datTemp.getDate() + '/' + datTemp.getYear();
		if(datTemp.getHours() > 9){
			sBuff = sBuff + ' ' + datTemp.getHours();
		}
		else{
			sBuff = sBuff + ' 0' + datTemp.getHours();
		}

		if(datTemp.getMinutes() > 9){
			sBuff = sBuff + ':' + datTemp.getMinutes();
		}
		else{
			sBuff = sBuff + ':0' + datTemp.getMinutes();
		}
		
		frmMain.txtStartDate.value = sBuff;
	}
	return 0;
}

function PickDate(dateInputToSelect){
	if(frmMain.chk_DateRange.checked == false || frmMain.sel_DateRange.selectedIndex != 0){
		return;
	}

	if(FormValidate() == true){
		selectedDateInput = document.all.item(dateInputToSelect);
	}
	else{
		selectedDateInput = null;
	}

	var hWnd = window.open("Calendar/CSCal.htm", "wndCal1", "width=210,height=178");
	hWnd.focus();
}

function CalendarCallback(selDate){
	var datNow = new Date();
	var datTemp = new Date(selDate);

	selectedDateInput.value = datTemp.getMonth()+1 + '/' + datTemp.getDate() + '/' + datTemp.getYear();
	window.focus();
}

</script>
</HEAD>
	<BODY onload="BodyOnLoad();" bgcolor="white">
		<table border="0" width="800" bgcolor="whitesmoke">
		<!-- #INCLUDE FILE="include/TopNav.asp" -->
		<tr><td style="height:5;font-size:1;background:white">&nbsp;</tr>
		<tr>
		<td>
		<form method="post" name="frmMain" onsubmit="return QuerySubmit();" action="GsElgReportPage.asp">
			<input type="hidden" name="hServerLogTypeFilter" id="hServerLogTypeFilter">
			<input type="hidden" name="hELSource" id="hELSource">
			<input type="hidden" name="hEventType" id="hEventType">
			<input type="hidden" name="hEventCategory" id="hEventCategory">
			<input type="hidden" name="hSelectedPage" id="hSelectedPage">
			<input type="hidden" name="hSortOrder" id="hSortOrder" value="<%=m_nSortOrder%>">
			<input type="hidden" name="hSortBy" id="hSortBy" value="<%=m_sSortBy%>">
			<input type="hidden" name="hPageSize" name="hPageSize" value="<%=m_nPageSize%>">
			<input type="hidden" name="hPageOfPagesSize" name="hPageOfPagesSize" value="<%=m_nPageOfPagesSize%>">
			<input type="hidden" name="hRefresh" value="true" name="hPageSize" ID="hPageSize">
			<INPUT type="hidden" value="<%=m_alertHdrID%>" name="hAlertHdrID" ID="hAlertHdrID">
			<%If m_SavedReportDescription <> "" Then%>
				<input type="hidden" name="hSavedReportDescription" value="<%=m_SavedReportDescription%>">
			<%End If%>
			
			<table border="0" width="100%" cellpadding="0" cellspacing="0" bgcolor="white">
				<tr>
					<td colspan="2" align="left" bgcolor="white">
						<b><font size="3">
							&nbsp;<%=cPageTitle%>
						</font></b>
						<%If m_SavedReportDescription <> "" Then%>
							<font size="2" color="darkgreen"><b>&nbsp;&nbsp;-&nbsp;Loaded&nbsp;<i><%=m_SavedReportDescription%></i></b></font>
						<%End If%>
					</td>
				</tr>
				<tr><td  colspan="2" style="height:10;font-size:1;background:white">&nbsp;</tr>
				<tr>
					<td valign="top" bgcolor="white" width="150" height="100%" style="border-right-color:black;border-right-style:solid;border-right-width:1;border-top-color:black;border-top-style:solid;border-top-width:1">
						<table cellpadding="0" cellspacing="0" width="150" bgcolor="white">
							<tr>
								<td>
						<%
						Dim nID
						nID="0"
						MakeMenu()
						%>
								</td>
							</tr>
							<tr><td>&nbsp;</td></tr>
						</table>
					</td>
					<td valign="top" style="border-color:black;border-style:solid;border-width:0;border-top-color:black;border-top-style:solid;border-top-width:1">
						<table cellpadding="0" cellspacing="0" width="100%" height="100%" border="0">
							<tr>
								<td valign="top">
									<table border="0" cellpadding="0" cellspacing="1" width="100%" bgcolor="SILVER">
										<tr><td style="border-top-color:grey;border-top-style:outset;border-top-width:2;height:2;font-size:1">&nbsp;</tr>
										<tr>
											<td>
												&nbsp;<img alt="Expand/collapse filter options" src="images/minus.gif" onclick="FilterPlusOnClick()" id="img_DateRange">&nbsp;Date&nbsp;Range
											</td>
										</tr>
										<tr>
											<td>
												<table style="display:" id="tbl_DateRange" width="100%">
													<tr>
														<td>
															<input type="checkbox" NAME="chk_DateRange" value="checked" id="chk_DateRange" onclick="FilterCheckOnClick()" <%=m_chk_DateRange%><%=m_check_all%>>
														</td>
														<td>
															<select name="sel_DateRange" id="sel_DateRange" onchange="SelDateRangeOnChange()" <%If m_chk_DateRange = "" And m_check_all = "" Then%>DISABLED<%End If%>>
																<option value="0">Custom Dates</option>
																<option value="1" <%If m_sel_DateRange="1" Then Response.Write("selected")%>>Last hour</option>
																<option value="2" <%If m_sel_DateRange="2" Then Response.Write("selected")%>>Today</option>
																<option value="3" <%If m_sel_DateRange="3" Then Response.Write("selected")%>>Last 24 hours</option>
																<option value="4" <%If m_sel_DateRange="4" Then Response.Write("selected")%>>Last 7 days</option>
																<option value="5" <%If m_sel_DateRange="5" Then Response.Write("selected")%>>This month</option>
																<option value="6" <%If m_sel_DateRange="6" Then Response.Write("selected")%>>Last 30 days</option>
															</select>
															Start Date:&nbsp;<a href="javascript:PickDate('txtStartDate')">Pick</a>&nbsp;<input type="text" NAME="txtStartDate" ID="txtStartDate" value="<%=m_txtStartDate%>" <%If m_chk_DateRange = "" Then%>DISABLED<%End If%>>&nbsp;&nbsp;End&nbsp;Date:&nbsp;<a href="javascript:PickDate('txtEndDate')">Pick</a>&nbsp;<input type="text" NAME="txtEndDate" ID="txtEndDate" value="<%=m_txtEndDate%>" <%If m_chk_DateRange = "" Then%>DISABLED<%End If%>>
														</td>
													</tr>
												</table>
											</td>	
										</tr>
										<tr><td style="border-top-color:grey;border-top-style:groove;border-top-width:2;height:2;font-size:1">&nbsp;</tr>
										<tr>
											<td>
												&nbsp;<img alt="Expand/collapse filter options" src="images/plus.gif" onclick="FilterPlusOnClick()" id="img_ELSource">&nbsp;Source&nbsp;Name
											</td>
										</tr>
										<tr>
											<td>
												<table style="display:none" id="tbl_ELSource">
													<tr>
														<td>
															<input type="checkbox" NAME="ckf_ELSource_All" id="ckf_ELSource_All" ParentID="null" value="All" <%If Request.Form("ckf_ELSource_All") <> "" Then%>checked<%End If%><%=m_check_all%> onclick="MenuCheckOnClick()"><b>All</b>
														</td>
														<td valign="top" colspan="2" id="td_ELSource">
																<%Call TwoFieldListGet("SourceNameListGet", "ckf_ELSource_")%>
														</td>
													</tr>
												</table>
											</td>	
										</tr>
										<tr><td style="border-top-color:grey;border-top-style:groove;border-top-width:2;height:2;font-size:1">&nbsp;</tr>
										<tr>
											<td>
												&nbsp;<img alt="Expand/collapse filter options" src="images/plus.gif" onclick="FilterPlusOnClick()" id="img_EventType">&nbsp;Event&nbsp;Type
											</td>
										</tr>
										<tr>
											<td>
												<table style="display:none" id="tbl_EventType">
													<tr>
														<td>
															<input type="checkbox" NAME="ckf_EventType_All" value="All" id="ckf_EventType_All" ParentID="null" <%If Request.Form("ckf_EventType_All") <> "" Then%>checked<%End If%><%=m_check_all%> onclick="MenuCheckOnClick()"><b>All</b>
														</td>
														<td colspan="2" id="td_EventType">
																<%Call TwoFieldListGet("EventTypeListGet", "ckf_EventType_")%>
														</td>
													</tr>
												</table>
											</td>	
										</tr>
										<tr><td style="border-top-color:grey;border-top-style:groove;border-top-width:2;height:2;font-size:1">&nbsp;</tr>
										<tr>
											<td>
												&nbsp;<img alt="Expand/collapse filter options" src="images/plus.gif" onclick="FilterPlusOnClick()" id="img_EventID">&nbsp;Event&nbsp;ID
											</td>
										</tr>
										<tr>
											<td>
												<table style="display:none" id="tbl_EventID">
													<tr>
														<td valign="top">
															<input type="checkbox" NAME="chk_EventID" value="checked" id="chk_EventID" ParentID="null" <%=m_chk_EventID%> onclick="FilterCheckOnClick()"><b>Filter by ID's</b>
															<br><input type="radio" NAME="radio_EventIDExclude" ID="radio_IDEventIDInclude" value="include" <%If m_sEventIDExclude="include" Then%>checked<%End If%> <%If m_chk_EventID = "" Then%>DISABLED<%End If%>>Include&nbsp;<input type="radio" NAME="radio_EventIDExclude" ID="radio_IDEventIDExclude" value="exclude" <%If m_sEventIDExclude="exclude" Then%>checked<%End If%> <%If m_chk_EventID = "" Then%>DISABLED<%End If%>>Exclude
															&nbsp;comma delimited id's<br>
															<input type="text" id="txtEventID" name="txtEventID" value="<%=m_sEventID%>" size="60" <%If m_chk_EventID = "" Then%>DISABLED<%End If%>><br>
														</td>
													</tr>
												</table>
											</td>	
										</tr>
										<tr><td style="border-top-color:grey;border-top-style:groove;border-top-width:2;height:2;font-size:1">&nbsp;</tr>
										<tr>
											<td>
												&nbsp;<img alt="Expand/collapse filter options" src="images/plus.gif" onclick="FilterPlusOnClick()" id="img_EventCategory">&nbsp;Event&nbsp;Category
											</td>
										</tr>
										<tr>
											<td>
												<table style="display:none" id="tbl_EventCategory">
													<tr>
														<td>
															<input type="checkbox" NAME="ckf_EventCategory_All" value="All" id="ckf_EventCategory_All" ParentID="null" <%If Request.Form("ckf_EventCategory_All") <> "" Then%>checked	<%End If%><%=m_check_all%> onclick="MenuCheckOnClick()"><b>All</b>
														</td>
														<td colspan="2" id="td_EventCategory">
																<%Call TwoFieldListGet("EventCategoryListGet", "ckf_EventCategory_")%>
														</td>
													</tr>
												</table>
											</td>	
										</tr>
										<tr><td style="border-top-color:grey;border-top-style:groove;border-top-width:2;height:2;font-size:1">&nbsp;</tr>

										<tr>
											<td>
												&nbsp;<img alt="show/hide executed SQL" src="images/plus.gif" onclick="FilterPlusOnClick()" id="img_sql">&nbsp;Executed&nbsp;SQL
											</td>
										</tr>
										<tr>
											<td>
												<table style="display:none" id="tbl_sql">
													<tr>
														<td colspan="2" id="td_sql">
																<textarea cols="75" rows="5" name="textSql"></textarea>
														</td>
													</tr>
												</table>
											</td>	
										</tr>
										<tr><td style="border-top-color:grey;border-top-style:groove;border-top-width:2;height:2;font-size:1">&nbsp;</tr>

										<tr>
											<td colspan="2">
												<input type="submit" NAME="btnRefresh" value="Refresh">
												&nbsp;<input type="button" NAME="btnReset" value="Reset" onclick="document.location.href = document.location.href;">
												&nbsp;&nbsp;<input type="button" NAME="btnSaveLogReport" value="Save Log Report" onclick="SaveLogReportOnClick()">
												&nbsp;&nbsp;<INPUT type="button" NAME="btnCreateAlert" value="Create Alert" onclick="CreateAlertOnClick()">
											</td>
										</tr>
										<tr><td style="border-bottom-color:grey;border-bottom-style:outset;border-bottom-width:2;height:5;font-size:1">&nbsp;</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td valign="top" height="100%">
									<%
									If m_sRefresh <> "" Then
										' get the records
										LogEntriesMakeXml(m_objXml)
										'Response.write m_objXml.xml
									%>
									<table width="100%" cellspacing="2" cellpadding="2" border="0" style="font-size:12;font-family:arial" bgcolor="beige">
										<tr>
											<%PageLinksDisplay(m_objXml)%>
										</tr>
										<tr style="font-weight:bold;background:black;color:white">
											<td>
												<%If m_sSortBy = "ELServerID" Then
													If m_nSortOrder = 1 Then
														Response.Write("<img src=""images/triangle_down.gif"">")
													Else
														Response.Write("<img src=""images/triangle_up.gif"">")
													End if
												End If
												%><a class="Header" href="JavaScript:ReSort('ELServerID', <%=CInt(m_nSortOrder)%>)">Server</a>
											</td>
											<td>
												<%If m_sSortBy = "LogTypeID" Then
													If m_nSortOrder = 1 Then
														Response.Write("<img src=""images/triangle_down.gif"">")
													Else
														Response.Write("<img src=""images/triangle_up.gif"">")
													End if
												End If
												%><a class="Header" href="JavaScript:ReSort('LogTypeID', <%=CInt(m_nSortOrder)%>)">Log&nbsp;Type</a>
											</td>
											<td>
												<%If m_sSortBy = "RecordNumber" Then
													If m_nSortOrder = 1 Then
														Response.Write("<img src=""images/triangle_down.gif"">")
													Else
														Response.Write("<img src=""images/triangle_up.gif"">")
													End if
												End If
												%><a class="Header" href="JavaScript:ReSort('RecordNumber', <%=CInt(m_nSortOrder)%>)">Event&nbsp;#</a>
											</td>
											<td>
												<%If m_sSortBy = "TimeGenerated" Then
													If m_nSortOrder = 1 Then
														Response.Write("<img src=""images/triangle_down.gif"">")
													Else
														Response.Write("<img src=""images/triangle_up.gif"">")
													End if
												End If
												%><a class="Header" href="JavaScript:ReSort('TimeGenerated', <%=CInt(m_nSortOrder)%>)">Generated</a>
											</td>
											<td>
												<%If m_sSortBy = "EventID" Then
													If m_nSortOrder = 1 Then
														Response.Write("<img src=""images/triangle_down.gif"">")
													Else
														Response.Write("<img src=""images/triangle_up.gif"">")
													End if
												End If
												%><a class="Header" href="JavaScript:ReSort('EventID', <%=CInt(m_nSortOrder)%>)">Event&nbsp;ID</a>
											</td>
											<td>
												<%If m_sSortBy = "EventTypeID" Then
													If m_nSortOrder = 1 Then
														Response.Write("<img src=""images/triangle_down.gif"">")
													Else
														Response.Write("<img src=""images/triangle_up.gif"">")
													End if
												End If
												%><a class="Header" href="JavaScript:ReSort('EventTypeID', <%=CInt(m_nSortOrder)%>)">Event&nbsp;Type</a>
											</td>
											<td>
												<%If m_sSortBy = "EventCategoryID" Then
													If m_nSortOrder = 1 Then
														Response.Write("<img src=""images/triangle_down.gif"">")
													Else
														Response.Write("<img src=""images/triangle_up.gif"">")
													End if
												End If
												%><a class="Header" href="JavaScript:ReSort('EventCategoryID', <%=CInt(m_nSortOrder)%>)">Category</a>
											</td>
											<td>
												<%If m_sSortBy = "ELUserID" Then
													If m_nSortOrder = 1 Then
														Response.Write("<img src=""images/triangle_down.gif"">")
													Else
														Response.Write("<img src=""images/triangle_up.gif"">")
													End if
												End If
												%><a class="Header" href="JavaScript:ReSort('ELUserID', <%=CInt(m_nSortOrder)%>)">User</a>
											</td>
											<td>
												<%If m_sSortBy = "ELSourceID" Then
													If m_nSortOrder = 1 Then
														Response.Write("<img src=""images/triangle_down.gif"">")
													Else
														Response.Write("<img src=""images/triangle_up.gif"">")
													End if
												End If
												%><a class="Header" href="JavaScript:ReSort('ELSourceID', <%=CInt(m_nSortOrder)%>)">Source</a>
											</td>
											<td>
												Description
											</td>
										</tr>
										<%	If m_sRefresh <> "" Then
												LogEntriesDisplay(m_objXml)
											End If
										%>
										<tr>
											<%PageLinksDisplay(m_objXml)%>
										</tr>
									</table>
								<%End If ' If Refresh%>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</form>
		</td>
		</tr>
		<!-- #INCLUDE FILE="include/Footer.inc" -->
		</table>
	</BODY>
	<script>frmMain.textSql.value = '<%=m_textSql%>';</script>
</HTML>

<%
Set objGsElg = Nothing
%>
