CREATE TABLE t_users
(
    f_nick          %VARCHAR%(20)        NOT NULL,
    f_name          %VARCHAR%(32)        %ALLOWSNULL%,
    f_password      %VARCHAR%(32)        %ALLOWSNULL%,
    f_uin           %SHORT%           NOT NULL,
    f_description   %VARCHAR%(255)       %ALLOWSNULL%
);

CREATE TABLE t_groups
(
    f_name             %VARCHAR%(32)     NOT NULL,
    f_uin              %BYTE%        NOT NULL,
    f_role             %BYTE%        %ALLOWSNULL%,
    f_description      %VARCHAR%(255)    %ALLOWSNULL%,
    f_hourcoef         %FLOAT%            %ALLOWSNULL%,
    f_intrafficcoef    %FLOAT%            %ALLOWSNULL%,
    f_outtrafficcoef   %FLOAT%            %ALLOWSNULL%
);

CREATE TABLE t_hosts
(
    f_address1         %BYTE%        NOT NULL,
    f_address2         %BYTE%        NOT NULL,
    f_address3         %BYTE%        NOT NULL,
    f_address4         %BYTE%        NOT NULL,
    f_address          %VARCHAR%(15)     %ALLOWSNULL%,
    f_name             %VARCHAR%(64)     %ALLOWSNULL%,
    f_uin              %BYTE%        NOT NULL,
    f_description      %VARCHAR%(255)    %ALLOWSNULL%,
    f_combinetraffic   %BOOLEAN%         NOT NULL
);

CREATE TABLE t_hostpriviledgedports
(
    f_host          %BYTE%     NOT NULL,
    f_startnumber   %SHORT%     NOT NULL,
    f_endnumber     %SHORT%     NOT NULL
);

CREATE TABLE t_useringroup
(
    f_useruin    %SHORT%     NOT NULL,
    f_groupuin   %BYTE%     NOT NULL
);

CREATE TABLE t_sessions
(
    f_host         %BYTE%    NOT NULL,
    f_useruin      %SHORT%    NOT NULL,
    f_logon        %DATETIME%   NOT NULL,
    f_logoff       %DATETIME%   %ALLOWSNULL%,
    f_intraffic    %INTEGER%     %ALLOWSNULL%,
    f_outtraffic   %INTEGER%     %ALLOWSNULL%,
    f_calculated   %INTEGER%     %ALLOWSNULL%,
    f_paid         %INTEGER%     %ALLOWSNULL%,
    f_cashier      %SHORT%    %ALLOWSNULL%
);

CREATE TABLE t_intraffic
(
    f_protocol   %BYTE%      %ALLOWSNULL%,
    f_host       %BYTE%      %ALLOWSNULL%,
    f_port       %SHORT%      %ALLOWSNULL%,
    f_rhost      %VARCHAR%(64)   %ALLOWSNULL%,
    f_rport      %SHORT%      %ALLOWSNULL%,
    f_bytes      %INTEGER%       %ALLOWSNULL%,
    f_moment     %DATETIME%     %ALLOWSNULL%
);

CREATE TABLE t_outtraffic
(
    f_protocol   %BYTE%      %ALLOWSNULL%,
    f_host       %BYTE%      %ALLOWSNULL%,
    f_port       %SHORT%      %ALLOWSNULL%,
    f_rhost      %VARCHAR%(64)   %ALLOWSNULL%,
    f_rport      %SHORT%      %ALLOWSNULL%,
    f_bytes      %INTEGER%       %ALLOWSNULL%,
    f_moment     %DATETIME%     %ALLOWSNULL%
);

CREATE TABLE t_generaldata
(
    f_pauseafter         %BYTE%   %ALLOWSNULL%,
    f_pauseduration      %INTEGER%    %ALLOWSNULL%,
    f_resetafter         %INTEGER%    %ALLOWSNULL%,
    f_hourprice          %FLOAT%       %ALLOWSNULL%,
    f_intrafficprice     %FLOAT%       %ALLOWSNULL%,
    f_outtrafficprice    %FLOAT%       %ALLOWSNULL%,
    f_amountdifference   %INTEGER%    %ALLOWSNULL%
);

CREATE TABLE t_usercoefs
(
    f_useruin          %SHORT%    NOT NULL,
    f_hourcoef         %FLOAT%        %ALLOWSNULL%,
    f_intrafficcoef    %FLOAT%        %ALLOWSNULL%,
    f_outtrafficcoef   %FLOAT%        %ALLOWSNULL%
);

CREATE TABLE t_datetimein
(
    f_useruin    %SHORT%    NOT NULL,
    f_datetype   %BYTE%    %ALLOWSNULL%,
    f_datechar   %CHAR%        %ALLOWSNULL%,
    f_time24     %BOOLEAN%     ,
    f_timechar   %CHAR%        %ALLOWSNULL%
);

CREATE TABLE t_datetimeout
(
    f_useruin          %SHORT%       NOT NULL,
    f_datetype         %BYTE%        %ALLOWSNULL%,
    f_dateday          %BOOLEAN%     ,
    f_datemonth        %BYTE%        %ALLOWSNULL%,
    f_dateyear         %BYTE%        %ALLOWSNULL%,
    f_dateweek         %BOOLEAN%     ,
    f_datechar         %CHAR%        %ALLOWSNULL%,
    f_timehour         %BOOLEAN%     ,
    f_timeminute       %BOOLEAN%     ,
    f_timeseconds      %BOOLEAN%     ,
    f_time24           %BOOLEAN%     ,
    f_timechar         %CHAR%        %ALLOWSNULL%,
    f_timebeforedate   %BOOLEAN%
);

CREATE TABLE t_preferences
(
    f_useruin          %SHORT%       NOT NULL,
    f_locale           %BYTE%        %ALLOWSNULL%,
    f_moneyprecision   %BYTE%        %ALLOWSNULL%,
    f_menutype         %BYTE%        %ALLOWSNULL%,
    f_shownotes        %BOOLEAN%
);

CREATE TABLE t_locales
(
    f_uin        %BYTE%      NOT NULL,
    f_country    %VARCHAR%(2)    %ALLOWSNULL%,
    f_language   %VARCHAR%(2)    %ALLOWSNULL%
);

CREATE TABLE t_statepresets
(
    f_useruin      %SHORT%        NOT NULL,
    f_lastnhours   %SHORT%        %ALLOWSNULL%,
    f_reloadon     %BOOLEAN%         ,
    f_reloadtime   %SHORT%        %ALLOWSNULL%,
    f_reloadtype   %BYTE%        %ALLOWSNULL%
);

CREATE TABLE t_usagepresets
(
    f_useruin              %SHORT%       NOT NULL,
    f_uin                  %BYTE%       NOT NULL,
    f_name                 %VARCHAR%(64)    NOT NULL,
    f_fromdate             %VARCHAR%(32)    %ALLOWSNULL%,
    f_todate               %VARCHAR%(32)    %ALLOWSNULL%,
    f_nicknameon           %BOOLEAN%        ,
    f_nickname             %VARCHAR%(255)   %ALLOWSNULL%,
    f_groupnameon          %BOOLEAN%        ,
    f_groupname            %VARCHAR%(255)   %ALLOWSNULL%,
    f_hostfromon           %BOOLEAN%        ,
    f_hostfrom             %VARCHAR%(255)   %ALLOWSNULL%,
    f_hosttoon             %BOOLEAN%        ,
    f_hostto               %VARCHAR%(255)   %ALLOWSNULL%,
    f_porttoon             %BOOLEAN%        ,
    f_portto               %VARCHAR%(255)   %ALLOWSNULL%,
    f_recordtype           %BOOLEAN%        ,
    f_sessionlogondateon   %BOOLEAN%        ,
    f_sessionlogoffdateon  %BOOLEAN%        ,
    f_totalperiodon        %BOOLEAN%        ,
    f_totalperiodtime      %SHORT%       %ALLOWSNULL%,
    f_totalperiodtype      %BYTE%       %ALLOWSNULL%,
    f_timeon               %BOOLEAN%        ,
    f_trafficinon          %BOOLEAN%        ,
    f_trafficouton         %BOOLEAN%        ,
    f_trafficallon         %BOOLEAN%        ,
    f_amountcalculatedon   %BOOLEAN%        ,
    f_amountcollectedon    %BOOLEAN%        
);

CREATE TABLE t_trafficpresets
(
    f_useruin        %SHORT%       NOT NULL,
    f_uin            %BYTE%       NOT NULL,
    f_name           %VARCHAR%(64)    NOT NULL,
    f_fromdate       %VARCHAR%(32)    %ALLOWSNULL%,
    f_todate         %VARCHAR%(32)    %ALLOWSNULL%,
    f_hostfromon     %BOOLEAN%        ,
    f_hostfrom       %VARCHAR%(255)   %ALLOWSNULL%,
    f_hosttoon       %BOOLEAN%        ,
    f_hostto         %VARCHAR%(255)   %ALLOWSNULL%,
    f_porttoon       %BOOLEAN%        ,
    f_portto         %VARCHAR%(255)   %ALLOWSNULL%,
    f_periodon       %BOOLEAN%        ,
    f_periodtime     %SHORT%       %ALLOWSNULL%,
    f_periodtype     %BYTE%       %ALLOWSNULL%,
    f_trafficinon    %BOOLEAN%        ,
    f_trafficouton   %BOOLEAN%        ,
    f_trafficallon   %BOOLEAN%        
);

CREATE TABLE t_plugins
(
    f_name        %VARCHAR%(32)   NOT NULL,
    f_performer   %VARCHAR%(64)   %ALLOWSNULL%
);

CREATE VIEW v_alltraffic (f_host,f_rhost,f_rport,f_moment,f_inbytes,f_outbytes)
    AS SELECT f_host, f_rhost, f_rport, f_moment, f_bytes, 0 FROM t_intraffic
        UNION ALL
    SELECT f_host, f_rhost, f_rport, f_moment, 0, f_bytes FROM t_outtraffic;

ALTER TABLE t_users ADD CONSTRAINT c_users_pk PRIMARY KEY (f_uin);
ALTER TABLE t_users ADD CONSTRAINT c_users_u UNIQUE (f_nick);

ALTER TABLE t_groups ADD CONSTRAINT c_groups_pk PRIMARY KEY (f_uin);
ALTER TABLE t_groups ADD CONSTRAINT c_groups_u UNIQUE (f_name);

ALTER TABLE t_useringroup ADD CONSTRAINT c_useringroup_pk PRIMARY KEY
    (f_useruin, f_groupuin);
ALTER TABLE t_useringroup ADD CONSTRAINT c_useringroup_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);
ALTER TABLE t_useringroup ADD CONSTRAINT c_useringroup_group_fk FOREIGN KEY
    (f_groupuin) REFERENCES t_groups(f_uin);

ALTER TABLE t_hosts ADD CONSTRAINT c_hosts_pk PRIMARY KEY (f_uin);
ALTER TABLE t_hosts ADD CONSTRAINT c_hosts_u UNIQUE
    (f_address1,f_address2,f_address3,f_address4);
ALTER TABLE t_hosts ADD CONSTRAINT c_hosts_u1 UNIQUE (f_address);

ALTER TABLE t_hostpriviledgedports ADD CONSTRAINT c_hostprivports_pk
    PRIMARY KEY (f_host,f_startnumber,f_endnumber);
ALTER TABLE t_hostpriviledgedports ADD CONSTRAINT c_hostprivports_host_fk
    FOREIGN KEY (f_host) REFERENCES t_hosts(f_uin);

ALTER TABLE t_sessions ADD CONSTRAINT c_sessions_user_fk
    FOREIGN KEY (f_useruin) REFERENCES t_users(f_uin);
ALTER TABLE t_sessions ADD CONSTRAINT c_sessions_host_fk
    FOREIGN KEY (f_host) REFERENCES t_hosts(f_uin);
ALTER TABLE t_sessions ADD CONSTRAINT c_sessions_cashier_fk
    FOREIGN KEY (f_cashier) REFERENCES t_users(f_uin);
ALTER TABLE t_sessions ADD CONSTRAINT c_sessions_pk PRIMARY KEY
    (f_host,f_logon);

ALTER TABLE t_intraffic ADD CONSTRAINT c_intraffic_host_fk FOREIGN KEY
    (f_host) REFERENCES t_hosts(f_uin);
ALTER TABLE t_outtraffic ADD CONSTRAINT c_outtraffic_host_fk FOREIGN KEY
    (f_host) REFERENCES t_hosts(f_uin);

ALTER TABLE t_usercoefs ADD CONSTRAINT c_userprices_pk PRIMARY KEY (f_useruin);
ALTER TABLE t_usercoefs ADD CONSTRAINT c_userprices_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);

ALTER TABLE t_datetimein ADD CONSTRAINT c_datetimein_pk PRIMARY KEY (f_useruin);
ALTER TABLE t_datetimein ADD CONSTRAINT c_datetimein_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);

ALTER TABLE t_datetimeout ADD CONSTRAINT c_datetimeout_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);
ALTER TABLE t_datetimeout ADD CONSTRAINT c_datetimeout_pk PRIMARY KEY
    (f_useruin);

ALTER TABLE t_locales ADD CONSTRAINT c_locales_pk PRIMARY KEY (f_uin);

ALTER TABLE t_preferences ADD CONSTRAINT c_preferences_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);
ALTER TABLE t_preferences ADD CONSTRAINT c_preferences_pk PRIMARY KEY
    (f_useruin);
ALTER TABLE t_preferences ADD CONSTRAINT c_preferences_locale_fk FOREIGN KEY
    (f_locale) REFERENCES t_locales(f_uin);

ALTER TABLE t_statepresets ADD CONSTRAINT t_statepresets_pk PRIMARY KEY
    (f_useruin);
ALTER TABLE t_statepresets ADD CONSTRAINT t_statepresets_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);

ALTER TABLE t_usagepresets ADD CONSTRAINT c_usagepresets_pk PRIMARY KEY
    (f_useruin, f_uin);
ALTER TABLE t_usagepresets ADD CONSTRAINT c_usagepresets_u UNIQUE
    (f_useruin, f_uin, f_name);
ALTER TABLE t_usagepresets ADD CONSTRAINT c_usagepresets_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);

ALTER TABLE t_trafficpresets ADD CONSTRAINT c_trafficpresets_pk PRIMARY KEY
    (f_useruin, f_uin);
ALTER TABLE t_trafficpresets ADD CONSTRAINT c_trafficpresets_u UNIQUE
    (f_useruin, f_uin, f_name);
ALTER TABLE t_trafficpresets ADD CONSTRAINT c_trafficpresets_user_fk
    FOREIGN KEY (f_useruin) REFERENCES t_users(f_uin);

ALTER TABLE t_plugins ADD CONSTRAINT c_plugins_pk PRIMARY KEY (f_name);

INSERT INTO t_generaldata (f_pauseafter, f_pauseduration, f_resetafter,
    f_hourprice, f_intrafficprice, f_outtrafficprice, f_amountdifference)
    VALUES (3, 1000, 10000, 0, 0, 0, 0);

INSERT INTO t_users (f_nick, f_name, f_password, f_uin, f_description) VALUES
    ('admin', 'Administrator', 'd41d8cd98f0b24e980998ecf8427e', 1,
    'Default Administrator');
INSERT INTO t_groups (f_name, f_uin, f_role, f_description)
    VALUES ('administrators', 1, 3, 'Administrators');
INSERT INTO t_useringroup (f_useruin, f_groupuin) VALUES (1, 1);

INSERT INTO t_locales (f_uin, f_language, f_country) VALUES (0, '', '');
INSERT INTO t_locales (f_uin, f_language, f_country) VALUES (1, 'en', '');
INSERT INTO t_locales (f_uin, f_language, f_country) VALUES (2, 'ru', '');

CREATE TABLE t_menu
(
    f_id          %BYTE%      NOT NULL,
    f_parent      %BYTE%      %ALLOWSNULL%,
    f_sortorder   %BYTE%      %ALLOWSNULL%,
    f_role        %BYTE%      %ALLOWSNULL%,
    f_islist      %BOOLEAN%       NOT NULL,
    f_title       %VARCHAR%(4)     %ALLOWSNULL%,
    f_url         %VARCHAR%(64)    %ALLOWSNULL%
);

ALTER TABLE t_menu ADD CONSTRAINT c_menu_pk PRIMARY KEY (f_id);

INSERT INTO t_menu VALUES (01, 0, 1, 2, %TRUE%, 'af', NULL);
INSERT INTO t_menu VALUES (11, 1, 1, 2, %FALSE%, 'st', 'state.jsp');

INSERT INTO t_menu VALUES (02, 0, 2, 2, %TRUE%, 'st', NULL);
INSERT INTO t_menu VALUES (21, 2, 1, 2, %FALSE%, 'us', 'stat.usage.jsp');
INSERT INTO t_menu VALUES (22, 2, 2, 2, %FALSE%, 'tr', 'stat.traffic.jsp');

INSERT INTO t_menu VALUES (03, 0, 3, 3, %TRUE%, 'mg', NULL);
INSERT INTO t_menu VALUES (31, 3, 1, 3, %FALSE%, 'u', 'card.user.jsp');
INSERT INTO t_menu VALUES (32, 3, 2, 3, %FALSE%, 'g', 'card.group.jsp');
INSERT INTO t_menu VALUES (33, 3, 3, 3, %FALSE%, 'h', 'card.host.jsp');
INSERT INTO t_menu VALUES (35, 3, 5, 3, %FALSE%, 'p', 'prices.jsp');
INSERT INTO t_menu VALUES (36, 3, 6, 3, %FALSE%, 'd', 'data.remove.jsp');

INSERT INTO t_menu VALUES (04, 0, 4, 2, %TRUE%, 'se', NULL);
INSERT INTO t_menu VALUES (42, 4, 1, 2, %FALSE%, 'dti', 'datetimein.jsp');
INSERT INTO t_menu VALUES (43, 4, 2, 2, %FALSE%, 'dto', 'datetimeout.jsp');
INSERT INTO t_menu VALUES (44, 4, 3, 2, %FALSE%, 'pr', 'prefs.jsp');

INSERT INTO t_menu VALUES (07, 0, 7, 1, %FALSE%, 'lo', 'logout.jsp');
