CREATE TABLE t_users
(
    f_nick          VARCHAR(20)        NOT NULL,
    f_name          VARCHAR(32)        NULL,
    f_password      VARCHAR(32)        NULL,
    f_uin           SMALLINT           NOT NULL,
    f_description   VARCHAR(255)       NULL
);

CREATE TABLE t_groups
(
    f_name             VARCHAR(32)     NOT NULL,
    f_uin              TINYINT        NOT NULL,
    f_role             TINYINT        NULL,
    f_description      VARCHAR(255)    NULL,
    f_hourcoef         REAL            NULL,
    f_intrafficcoef    REAL            NULL,
    f_outtrafficcoef   REAL            NULL
);

CREATE TABLE t_hosts
(
    f_address1         TINYINT        NOT NULL,
    f_address2         TINYINT        NOT NULL,
    f_address3         TINYINT        NOT NULL,
    f_address4         TINYINT        NOT NULL,
    f_address          VARCHAR(15)     NULL,
    f_name             VARCHAR(64)     NULL,
    f_uin              TINYINT        NOT NULL,
    f_description      VARCHAR(255)    NULL,
    f_combinetraffic   BIT         NOT NULL
);

CREATE TABLE t_hostpriviledgedports
(
    f_host          TINYINT     NOT NULL,
    f_startnumber   SMALLINT     NOT NULL,
    f_endnumber     SMALLINT     NOT NULL
);

CREATE TABLE t_useringroup
(
    f_useruin    SMALLINT     NOT NULL,
    f_groupuin   TINYINT     NOT NULL
);

CREATE TABLE t_sessions
(
    f_host         TINYINT    NOT NULL,
    f_useruin      SMALLINT    NOT NULL,
    f_logon        DATETIME   NOT NULL,
    f_logoff       DATETIME   NULL,
    f_intraffic    INTEGER     NULL,
    f_outtraffic   INTEGER     NULL,
    f_calculated   INTEGER     NULL,
    f_paid         INTEGER     NULL,
    f_cashier      SMALLINT    NULL
);

CREATE TABLE t_intraffic
(
    f_protocol   TINYINT      NULL,
    f_host       TINYINT      NULL,
    f_port       SMALLINT      NULL,
    f_rhost      VARCHAR(64)   NULL,
    f_rport      SMALLINT      NULL,
    f_bytes      INTEGER       NULL,
    f_moment     DATETIME     NULL
);

CREATE TABLE t_outtraffic
(
    f_protocol   TINYINT      NULL,
    f_host       TINYINT      NULL,
    f_port       SMALLINT      NULL,
    f_rhost      VARCHAR(64)   NULL,
    f_rport      SMALLINT      NULL,
    f_bytes      INTEGER       NULL,
    f_moment     DATETIME     NULL
);

CREATE TABLE t_generaldata
(
    f_pauseafter         TINYINT   NULL,
    f_pauseduration      INTEGER    NULL,
    f_resetafter         INTEGER    NULL,
    f_hourprice          REAL       NULL,
    f_intrafficprice     REAL       NULL,
    f_outtrafficprice    REAL       NULL,
    f_amountdifference   INTEGER    NULL
);

CREATE TABLE t_usercoefs
(
    f_useruin          SMALLINT    NOT NULL,
    f_hourcoef         REAL        NULL,
    f_intrafficcoef    REAL        NULL,
    f_outtrafficcoef   REAL        NULL
);

CREATE TABLE t_datetimein
(
    f_useruin    SMALLINT    NOT NULL,
    f_datetype   TINYINT    NULL,
    f_datechar   CHAR        NULL,
    f_time24     BIT     ,
    f_timechar   CHAR        NULL
);

CREATE TABLE t_datetimeout
(
    f_useruin          SMALLINT       NOT NULL,
    f_datetype         TINYINT        NULL,
    f_dateday          BIT     ,
    f_datemonth        TINYINT        NULL,
    f_dateyear         TINYINT        NULL,
    f_dateweek         BIT     ,
    f_datechar         CHAR        NULL,
    f_timehour         BIT     ,
    f_timeminute       BIT     ,
    f_timeseconds      BIT     ,
    f_time24           BIT     ,
    f_timechar         CHAR        NULL,
    f_timebeforedate   BIT
);

CREATE TABLE t_preferences
(
    f_useruin          SMALLINT       NOT NULL,
    f_locale           TINYINT        NULL,
    f_moneyprecision   TINYINT        NULL,
    f_menutype         TINYINT        NULL,
    f_shownotes        BIT
);

CREATE TABLE t_locales
(
    f_uin        TINYINT      NOT NULL,
    f_country    VARCHAR(2)    NULL,
    f_language   VARCHAR(2)    NULL
);

CREATE TABLE t_statepresets
(
    f_useruin      SMALLINT        NOT NULL,
    f_lastnhours   SMALLINT        NULL,
    f_reloadon     BIT         ,
    f_reloadtime   SMALLINT        NULL,
    f_reloadtype   TINYINT        NULL
);

CREATE TABLE t_usagepresets
(
    f_useruin              SMALLINT       NOT NULL,
    f_uin                  TINYINT       NOT NULL,
    f_name                 VARCHAR(64)    NOT NULL,
    f_fromdate             VARCHAR(32)    NULL,
    f_todate               VARCHAR(32)    NULL,
    f_nicknameon           BIT        ,
    f_nickname             VARCHAR(255)   NULL,
    f_groupnameon          BIT        ,
    f_groupname            VARCHAR(255)   NULL,
    f_hostfromon           BIT        ,
    f_hostfrom             VARCHAR(255)   NULL,
    f_hosttoon             BIT        ,
    f_hostto               VARCHAR(255)   NULL,
    f_porttoon             BIT        ,
    f_portto               VARCHAR(255)   NULL,
    f_recordtype           BIT        ,
    f_sessionlogondateon   BIT        ,
    f_sessionlogoffdateon  BIT        ,
    f_totalperiodon        BIT        ,
    f_totalperiodtime      SMALLINT       NULL,
    f_totalperiodtype      TINYINT       NULL,
    f_timeon               BIT        ,
    f_trafficinon          BIT        ,
    f_trafficouton         BIT        ,
    f_trafficallon         BIT        ,
    f_amountcalculatedon   BIT        ,
    f_amountcollectedon    BIT        
);

CREATE TABLE t_trafficpresets
(
    f_useruin        SMALLINT       NOT NULL,
    f_uin            TINYINT       NOT NULL,
    f_name           VARCHAR(64)    NOT NULL,
    f_fromdate       VARCHAR(32)    NULL,
    f_todate         VARCHAR(32)    NULL,
    f_hostfromon     BIT        ,
    f_hostfrom       VARCHAR(255)   NULL,
    f_hosttoon       BIT        ,
    f_hostto         VARCHAR(255)   NULL,
    f_porttoon       BIT        ,
    f_portto         VARCHAR(255)   NULL,
    f_periodon       BIT        ,
    f_periodtime     SMALLINT       NULL,
    f_periodtype     TINYINT       NULL,
    f_trafficinon    BIT        ,
    f_trafficouton   BIT        ,
    f_trafficallon   BIT        
);

CREATE TABLE t_plugins
(
    f_name        VARCHAR(32)   NOT NULL,
    f_performer   VARCHAR(64)   NULL
);

CREATE VIEW v_alltraffic (f_host,f_rhost,f_rport,f_moment,f_inbytes,f_outbytes)
    AS SELECT f_host, f_rhost, f_rport, f_moment, f_bytes, 0 FROM t_intraffic
        UNION ALL
    SELECT f_host, f_rhost, f_rport, f_moment, 0, f_bytes FROM t_outtraffic;

ALTER TABLE t_users ADD CONSTRAINT c_users_pk PRIMARY KEY (f_uin);
ALTER TABLE t_users ADD CONSTRAINT c_users_u UNIQUE (f_nick);

ALTER TABLE t_groups ADD CONSTRAINT c_groups_pk PRIMARY KEY (f_uin);
ALTER TABLE t_groups ADD CONSTRAINT c_groups_u UNIQUE (f_name);

ALTER TABLE t_useringroup ADD CONSTRAINT c_useringroup_pk PRIMARY KEY
    (f_useruin, f_groupuin);
ALTER TABLE t_useringroup ADD CONSTRAINT c_useringroup_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);
ALTER TABLE t_useringroup ADD CONSTRAINT c_useringroup_group_fk FOREIGN KEY
    (f_groupuin) REFERENCES t_groups(f_uin);

ALTER TABLE t_hosts ADD CONSTRAINT c_hosts_pk PRIMARY KEY (f_uin);
ALTER TABLE t_hosts ADD CONSTRAINT c_hosts_u UNIQUE
    (f_address1,f_address2,f_address3,f_address4);
ALTER TABLE t_hosts ADD CONSTRAINT c_hosts_u1 UNIQUE (f_address);

ALTER TABLE t_hostpriviledgedports ADD CONSTRAINT c_hostprivports_pk
    PRIMARY KEY (f_host,f_startnumber,f_endnumber);
ALTER TABLE t_hostpriviledgedports ADD CONSTRAINT c_hostprivports_host_fk
    FOREIGN KEY (f_host) REFERENCES t_hosts(f_uin);

ALTER TABLE t_sessions ADD CONSTRAINT c_sessions_user_fk
    FOREIGN KEY (f_useruin) REFERENCES t_users(f_uin);
ALTER TABLE t_sessions ADD CONSTRAINT c_sessions_host_fk
    FOREIGN KEY (f_host) REFERENCES t_hosts(f_uin);
ALTER TABLE t_sessions ADD CONSTRAINT c_sessions_cashier_fk
    FOREIGN KEY (f_cashier) REFERENCES t_users(f_uin);
ALTER TABLE t_sessions ADD CONSTRAINT c_sessions_pk PRIMARY KEY
    (f_host,f_logon);

ALTER TABLE t_intraffic ADD CONSTRAINT c_intraffic_host_fk FOREIGN KEY
    (f_host) REFERENCES t_hosts(f_uin);
ALTER TABLE t_outtraffic ADD CONSTRAINT c_outtraffic_host_fk FOREIGN KEY
    (f_host) REFERENCES t_hosts(f_uin);

ALTER TABLE t_usercoefs ADD CONSTRAINT c_userprices_pk PRIMARY KEY (f_useruin);
ALTER TABLE t_usercoefs ADD CONSTRAINT c_userprices_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);

ALTER TABLE t_datetimein ADD CONSTRAINT c_datetimein_pk PRIMARY KEY (f_useruin);
ALTER TABLE t_datetimein ADD CONSTRAINT c_datetimein_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);

ALTER TABLE t_datetimeout ADD CONSTRAINT c_datetimeout_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);
ALTER TABLE t_datetimeout ADD CONSTRAINT c_datetimeout_pk PRIMARY KEY
    (f_useruin);

ALTER TABLE t_locales ADD CONSTRAINT c_locales_pk PRIMARY KEY (f_uin);

ALTER TABLE t_preferences ADD CONSTRAINT c_preferences_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);
ALTER TABLE t_preferences ADD CONSTRAINT c_preferences_pk PRIMARY KEY
    (f_useruin);
ALTER TABLE t_preferences ADD CONSTRAINT c_preferences_locale_fk FOREIGN KEY
    (f_locale) REFERENCES t_locales(f_uin);

ALTER TABLE t_statepresets ADD CONSTRAINT t_statepresets_pk PRIMARY KEY
    (f_useruin);
ALTER TABLE t_statepresets ADD CONSTRAINT t_statepresets_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);

ALTER TABLE t_usagepresets ADD CONSTRAINT c_usagepresets_pk PRIMARY KEY
    (f_useruin, f_uin);
ALTER TABLE t_usagepresets ADD CONSTRAINT c_usagepresets_u UNIQUE
    (f_useruin, f_uin, f_name);
ALTER TABLE t_usagepresets ADD CONSTRAINT c_usagepresets_user_fk FOREIGN KEY
    (f_useruin) REFERENCES t_users(f_uin);

ALTER TABLE t_trafficpresets ADD CONSTRAINT c_trafficpresets_pk PRIMARY KEY
    (f_useruin, f_uin);
ALTER TABLE t_trafficpresets ADD CONSTRAINT c_trafficpresets_u UNIQUE
    (f_useruin, f_uin, f_name);
ALTER TABLE t_trafficpresets ADD CONSTRAINT c_trafficpresets_user_fk
    FOREIGN KEY (f_useruin) REFERENCES t_users(f_uin);

ALTER TABLE t_plugins ADD CONSTRAINT c_plugins_pk PRIMARY KEY (f_name);

INSERT INTO t_generaldata (f_pauseafter, f_pauseduration, f_resetafter,
    f_hourprice, f_intrafficprice, f_outtrafficprice, f_amountdifference)
    VALUES (3, 1000, 10000, 0, 0, 0, 0);

INSERT INTO t_users (f_nick, f_name, f_password, f_uin, f_description) VALUES
    ('admin', 'Administrator', 'd41d8cd98f0b24e980998ecf8427e', 1,
    'Default Administrator');
INSERT INTO t_groups (f_name, f_uin, f_role, f_description)
    VALUES ('administrators', 1, 3, 'Administrators');
INSERT INTO t_useringroup (f_useruin, f_groupuin) VALUES (1, 1);

INSERT INTO t_locales (f_uin, f_language, f_country) VALUES (0, '', '');
INSERT INTO t_locales (f_uin, f_language, f_country) VALUES (1, 'en', '');
INSERT INTO t_locales (f_uin, f_language, f_country) VALUES (2, 'ru', '');

CREATE TABLE t_menu
(
    f_id          TINYINT      NOT NULL,
    f_parent      TINYINT      NULL,
    f_sortorder   TINYINT      NULL,
    f_role        TINYINT      NULL,
    f_islist      BIT       NOT NULL,
    f_title       VARCHAR(4)     NULL,
    f_url         VARCHAR(64)    NULL
);

ALTER TABLE t_menu ADD CONSTRAINT c_menu_pk PRIMARY KEY (f_id);

INSERT INTO t_menu VALUES (01, 0, 1, 2, 1, 'af', NULL);
INSERT INTO t_menu VALUES (11, 1, 1, 2, 0, 'st', 'state.jsp');

INSERT INTO t_menu VALUES (02, 0, 2, 2, 1, 'st', NULL);
INSERT INTO t_menu VALUES (21, 2, 1, 2, 0, 'us', 'stat.usage.jsp');
INSERT INTO t_menu VALUES (22, 2, 2, 2, 0, 'tr', 'stat.traffic.jsp');

INSERT INTO t_menu VALUES (03, 0, 3, 3, 1, 'mg', NULL);
INSERT INTO t_menu VALUES (31, 3, 1, 3, 0, 'u', 'card.user.jsp');
INSERT INTO t_menu VALUES (32, 3, 2, 3, 0, 'g', 'card.group.jsp');
INSERT INTO t_menu VALUES (33, 3, 3, 3, 0, 'h', 'card.host.jsp');
INSERT INTO t_menu VALUES (35, 3, 5, 3, 0, 'p', 'prices.jsp');
INSERT INTO t_menu VALUES (36, 3, 6, 3, 0, 'd', 'data.remove.jsp');

INSERT INTO t_menu VALUES (04, 0, 4, 2, 1, 'se', NULL);
INSERT INTO t_menu VALUES (42, 4, 1, 2, 0, 'dti', 'datetimein.jsp');
INSERT INTO t_menu VALUES (43, 4, 2, 2, 0, 'dto', 'datetimeout.jsp');
INSERT INTO t_menu VALUES (44, 4, 3, 2, 0, 'pr', 'prefs.jsp');

INSERT INTO t_menu VALUES (07, 0, 7, 1, 0, 'lo', 'logout.jsp');
