/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.util.cfg;

import com.rathedg.util.cfg.Config;
import com.rathedg.util.exception.InvalidConfigurationException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;

public class ConfigFile
extends Config {
    protected static final String COMMENT = "#;";
    protected static final char SEPARATOR = '=';
    protected Map map;

    public ConfigFile() {
    }

    public ConfigFile(String string) throws IOException, InvalidConfigurationException {
        this.setFilename(string);
    }

    public void setFilename(String string) throws IOException, InvalidConfigurationException {
        this.map = this.extract(string);
    }

    public Map map() {
        return this.map;
    }

    protected String getCfgPropertyImpl(String string) {
        return (String)this.map.get(string);
    }

    protected Map extract(String string) throws IOException, InvalidConfigurationException {
        String string2;
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while ((string2 = lineNumberReader.readLine()) != null) {
            if ((string2 = string2.trim()).length() == 0 || COMMENT.indexOf(string2.charAt(0)) != -1) continue;
            int n = string2.indexOf(61);
            if (n == -1) {
                throw new InvalidConfigurationException("Error reading configuration from file '" + string + "', missed parameter/value separator in line " + lineNumberReader.getLineNumber());
            }
            String string3 = string2.substring(0, n).trim();
            if (string3.length() == 0) {
                throw new InvalidConfigurationException("Error reading configuration from file '" + string + "', parameter name is missing in line " + lineNumberReader.getLineNumber());
            }
            if (hashMap.get(string3) != null) {
                throw new InvalidConfigurationException("Error reading configuration from file '" + string + "', parameter '" + string3 + "' redefinition detected in line " + lineNumberReader.getLineNumber());
            }
            hashMap.put(string3, string2.substring(n + 1).trim());
        }
        lineNumberReader.close();
        return hashMap;
    }
}

