/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.cachalot.tru;

import com.rathedg.cachalot.tru.ExternalTrafficException;
import com.rathedg.cachalot.tru.HostInfo;
import com.rathedg.cachalot.tru.InternalTrafficException;
import com.rathedg.cachalot.tru.MalformedPacketException;
import com.rathedg.util.net.IP;
import java.util.Map;
import net.sourceforge.jpcap.net.IPPacket;
import net.sourceforge.jpcap.net.TCPPacket;
import net.sourceforge.jpcap.net.UDPPacket;

class TrafficInfo {
    static Map hosts;
    boolean incoming;
    byte protocol;
    IP rhost;
    Short host;
    short port;
    short rport;
    int amount;
    long moment;

    TrafficInfo(IPPacket iPPacket) throws ExternalTrafficException, InternalTrafficException, MalformedPacketException {
        Object object;
        this.protocol = (byte)iPPacket.getProtocol();
        IP iP = new IP(this.getSourceAddress(iPPacket));
        IP iP2 = new IP(this.getDestinationAddress(iPPacket));
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        if (iPPacket instanceof TCPPacket) {
            bl = true;
            object = (TCPPacket)iPPacket;
            n = object.getDestinationPort();
            n2 = object.getSourcePort();
        } else if (iPPacket instanceof UDPPacket) {
            bl = true;
            object = (UDPPacket)iPPacket;
            n = object.getDestinationPort();
            n2 = object.getSourcePort();
        }
        object = (HostInfo)hosts.get(iP);
        HostInfo hostInfo = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (object != null) {
            hostInfo = (HostInfo)hosts.get(iP2);
            if (hostInfo != null) {
                if (!bl) {
                    throw new InternalTrafficException();
                }
                if (!object.priviledgedPorts.contains(n2)) {
                    if (!hostInfo.priviledgedPorts.contains(n)) {
                        throw new InternalTrafficException();
                    }
                    this.incoming = false;
                    n3 = n2;
                    this.rhost = iP2;
                    n4 = n;
                } else {
                    HostInfo hostInfo2 = hostInfo;
                    hostInfo = object;
                    object = hostInfo2;
                    this.incoming = true;
                    n3 = n;
                    this.rhost = iP;
                    n4 = n2;
                }
                bl3 = true;
            } else {
                this.incoming = false;
                n3 = n2;
                this.rhost = iP2;
                n4 = n;
                bl2 = object.priviledgedPorts.contains(n2);
            }
        } else {
            object = (HostInfo)hosts.get(iP2);
            if (object == null) {
                throw new ExternalTrafficException();
            }
            this.incoming = true;
            n3 = n;
            this.rhost = iP;
            n4 = n2;
            bl2 = object.priviledgedPorts.contains(n);
        }
        this.host = object.uin;
        this.moment = System.currentTimeMillis();
        this.amount = iPPacket.getLength();
        this.port = (short)n3;
        this.rport = (short)n4;
        if (bl) {
            if (n3 > 1024 && !bl2) {
                if (object.combineTraffic && (n4 <= 1024 || bl3)) {
                    this.port = (short)-1;
                }
            } else if ((hostInfo == null || hostInfo.combineTraffic) && n4 > 1024 && !bl3) {
                this.rport = (short)-1;
            }
        }
    }

    boolean combine(TrafficInfo trafficInfo) {
        if (this.incoming != trafficInfo.incoming || this.protocol != trafficInfo.protocol || this.port != trafficInfo.port || this.rport != trafficInfo.rport || !this.host.equals(trafficInfo.host) || !this.rhost.equals(trafficInfo.rhost)) {
            return false;
        }
        if ((double)this.amount + (double)trafficInfo.amount > 2.147483647E9) {
            return false;
        }
        this.amount += trafficInfo.amount;
        return true;
    }

    public String toString() {
        return "[protocol=" + this.protocol + ", remote host=" + this.rhost + ", remote port=" + this.rport + ", host=" + this.host + ", port=" + this.port + ", amount=" + this.amount + ", moment=" + this.moment + "]";
    }

    byte[] getSourceAddress(IPPacket iPPacket) throws MalformedPacketException {
        byte[] byArray = new byte[4];
        byte[] byArray2 = iPPacket.getIPHeader();
        if (byArray2.length < 16) {
            throw new MalformedPacketException();
        }
        byArray[0] = byArray2[12];
        byArray[1] = byArray2[13];
        byArray[2] = byArray2[14];
        byArray[3] = byArray2[15];
        return byArray;
    }

    byte[] getDestinationAddress(IPPacket iPPacket) throws MalformedPacketException {
        byte[] byArray = new byte[4];
        byte[] byArray2 = iPPacket.getIPHeader();
        if (byArray2.length < 20) {
            throw new MalformedPacketException();
        }
        byArray[0] = byArray2[16];
        byArray[1] = byArray2[17];
        byArray[2] = byArray2[18];
        byArray[3] = byArray2[19];
        return byArray;
    }
}

