/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.cachalot.tru;

import com.rathedg.cachalot.tru.TRUStarter;
import com.rathedg.util.PropertyExtractor;
import com.rathedg.util.exception.InitializationException;
import com.rathedg.util.exception.InvalidConfigurationException;
import com.rathedg.util.exception.InvalidValueException;
import com.rathedg.util.log.LoggerInterface;
import com.rathedg.util.net.IP;
import com.rathedg.util.snt.Queue;
import net.sourceforge.jpcap.capture.CaptureStatistics;
import net.sourceforge.jpcap.capture.PacketCapture;
import net.sourceforge.jpcap.capture.PacketListener;
import net.sourceforge.jpcap.net.ICMPPacket;
import net.sourceforge.jpcap.net.Packet;
import net.sourceforge.jpcap.net.TCPPacket;
import net.sourceforge.jpcap.net.UDPPacket;

public class PacketHandler
extends Thread
implements PacketListener {
    private PacketCapture pc;
    private Queue queue;
    private TRUStarter starter;
    private LoggerInterface logger;
    private boolean shutdown = false;

    public PacketHandler(PropertyExtractor propertyExtractor, Queue queue, TRUStarter tRUStarter, LoggerInterface loggerInterface) throws InvalidValueException, InvalidConfigurationException, InitializationException {
        this(propertyExtractor.getStringNotNullNotEmpty("device.name", true).trim(), propertyExtractor.getBooleanNotNullNotEmpty("device.promiscuous", false, true), queue, tRUStarter, loggerInterface);
    }

    private PacketHandler(String string, boolean bl, Queue queue, TRUStarter tRUStarter, LoggerInterface loggerInterface) throws InvalidValueException, InitializationException {
        this.queue = queue;
        this.starter = tRUStarter;
        this.logger = loggerInterface;
        try {
            this.pc = new PacketCapture();
            IP iP = IP.parse(string);
            if (iP != null) {
                String[] stringArray = PacketCapture.lookupDevices();
                int n = 0;
                while (n < stringArray.length) {
                    if (this.pc.getNetwork(stringArray[n]) == (this.pc.getNetmask(stringArray[n]) & iP.toInt())) {
                        string = stringArray[n];
                        break;
                    }
                    ++n;
                }
            }
            loggerInterface.log("Opening device '" + string + "'");
            this.pc.open(string, 1500, bl, 5000);
            this.pc.setFilter("", false);
            this.pc.addPacketListener((PacketListener)this);
        }
        catch (Throwable throwable) {
            throw new InitializationException("Error while opening device: " + throwable);
        }
    }

    public void run() {
        try {
            while (true) {
                try {
                    while (true) {
                        PacketHandler packetHandler = this;
                        synchronized (packetHandler) {
                            if (this.shutdown) {
                                this.notify();
                                return;
                            }
                        }
                        this.pc.capture(1);
                        CaptureStatistics captureStatistics = this.pc.getStatistics();
                        int n = captureStatistics.getDroppedCount();
                        if (n == 0) continue;
                        if (n == 1) {
                            this.logger.log(n + " packet has not been captured");
                            continue;
                        }
                        this.logger.log(n + " packets have not been captured");
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            this.logger.log("Error while capturing packets: " + throwable);
            PacketHandler packetHandler = this;
            synchronized (packetHandler) {
                if (this.shutdown) {
                    this.notify();
                    return;
                }
                this.shutdown = true;
                this.starter.shutdown();
            }
            return;
        }
    }

    synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void packetArrived(Packet packet) {
        if (packet instanceof TCPPacket || packet instanceof UDPPacket || packet instanceof ICMPPacket) {
            this.queue.put(packet);
        }
    }
}

