/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.util.snt;

public final class ReusableThread
extends Thread {
    private Runnable runnable;
    private Object waiting;
    private boolean running = false;
    private boolean inrun = false;
    private boolean torun;

    public ReusableThread(Runnable runnable, Object object) {
        this.runnable = runnable;
        this.waiting = object;
    }

    public synchronized void start() {
        if (!this.inrun) {
            this.inrun = true;
            this.torun = true;
            this.running = true;
            super.start();
            return;
        }
        if (this.running) {
            throw new IllegalThreadStateException("thread is already running");
        }
        this.running = true;
        this.notify();
    }

    public void run() {
        ReusableThread reusableThread;
        while (this.torun) {
            try {
                this.runnable.run();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            reusableThread = this;
            synchronized (reusableThread) {
                this.running = false;
                if (this.torun) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.inrun = false;
        reusableThread = this;
        synchronized (reusableThread) {
            Object object = this.waiting;
            synchronized (object) {
                this.waiting.notify();
            }
            this.notify();
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void finish() {
        this.torun = false;
    }

    public synchronized void finishAndWait() throws InterruptedException {
        this.torun = false;
        this.wait();
    }
}

