/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.socketserver;

import com.rathedg.socketserver.ServerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public final class SocketServerClient {
    private int timeout;
    private boolean nodelay;
    private Socket socket;
    private InputStream in;
    private OutputStream out;

    public SocketServerClient(int n, boolean bl) {
        this.timeout = n;
        this.nodelay = bl;
    }

    public void connect(InetAddress inetAddress, int n, int n2) throws IOException, ServerException {
        this.socket = new Socket(inetAddress, n);
        this.socket.setSoTimeout(this.timeout);
        this.socket.setTcpNoDelay(this.nodelay);
        this.out = this.socket.getOutputStream();
        this.in = this.socket.getInputStream();
        this.out.write(n2);
    }

    public void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void finish() throws IOException, ServerException {
        try {
            this.out.write(0);
            byte by = (byte)this.in.read();
            if (by == 1) {
                throw new IOException("i/o error");
            }
            if (by == 2) {
                throw new ServerException();
            }
        }
        catch (IOException iOException) {
            this.socket.close();
            throw iOException;
        }
    }

    public void writeMessage(byte[] byArray) throws IOException, ServerException {
        try {
            this.out.write(byArray.length >> 8);
            this.out.write(byArray.length % 256);
            this.out.write(byArray);
            byte by = (byte)this.in.read();
            if (by == 1) {
                throw new IOException("i/o error");
            }
            if (by == 2) {
                throw new ServerException();
            }
        }
        catch (IOException iOException) {
            this.socket.close();
            throw iOException;
        }
    }

    public byte[] readMessage() throws IOException {
        try {
            int n = (this.in.read() << 8) + this.in.read();
            if (n < 0) {
                throw new IOException("invalid size of message");
            }
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                n2 += this.in.read(byArray, n2, n - n2);
            }
            if (n2 != n) {
                throw new IOException("read less (" + n + ") than had to read (" + byArray.length + ")");
            }
            return byArray;
        }
        catch (IOException iOException) {
            this.socket.close();
            throw iOException;
        }
    }

    public void writeNextMessage(byte[] byArray) throws IOException, ServerException {
        try {
            this.out.write(1);
            this.out.write(byArray.length >> 8);
            this.out.write(byArray.length % 256);
            this.out.write(byArray);
            byte by = (byte)this.in.read();
            if (by == 1) {
                throw new IOException("i/o error");
            }
            if (by == 2) {
                throw new ServerException();
            }
        }
        catch (IOException iOException) {
            this.socket.close();
            throw iOException;
        }
    }
}

