/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.socketserver;

import com.rathedg.socketserver.InteractiveRequestHandler;
import com.rathedg.socketserver.MessageHandler;
import com.rathedg.socketserver.OneWayRequestHandler;
import com.rathedg.socketserver.RequestDescriptor;
import com.rathedg.socketserver.RequestHandler;
import com.rathedg.socketserver.SocketServer;
import com.rathedg.socketserver.TransactionHandler;
import com.rathedg.socketserver.TwoWayRequestHandler;
import com.rathedg.util.io.IOUtils;
import com.rathedg.util.snt.ReusableThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

final class HandlerThreadPool {
    HandlerThreadPool threadpool = this;
    SocketServer server;
    HandlerThread[] thread;
    List overflow = new ArrayList();
    int capacity;

    HandlerThreadPool(SocketServer socketServer, int n) {
        this.server = socketServer;
        this.capacity = n;
        this.thread = new HandlerThread[n];
        int n2 = 0;
        while (n2 < n) {
            this.thread[n2] = new HandlerThread();
            ++n2;
        }
    }

    void startThread(Socket socket) {
        HandlerThreadPool handlerThreadPool = this;
        synchronized (handlerThreadPool) {
            int n = 0;
            while (n < this.capacity) {
                if (!this.thread[n].rthread.isRunning()) {
                    this.thread[n].start(socket, false);
                    return;
                }
                ++n;
            }
        }
        HandlerThread handlerThread = new HandlerThread();
        List list = this.overflow;
        synchronized (list) {
            this.overflow.add(handlerThread);
        }
        HandlerThreadPool handlerThreadPool2 = this;
        synchronized (handlerThreadPool2) {
            handlerThread.start(socket, true);
        }
        this.server.logger.log("created additional thread, currently there're " + this.overflow.size() + " threads running out of pool");
    }

    synchronized void synchronizeShutdown() {
        while (true) {
            if (this.overflow.size() == 0) {
                int n = 0;
                while (n < this.capacity) {
                    if (this.thread[n].rthread.isRunning()) break;
                    ++n;
                }
                if (n == this.capacity) {
                    return;
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    void removeOverflow(HandlerThread handlerThread) {
        List list = this.overflow;
        synchronized (list) {
            this.overflow.remove(handlerThread);
        }
    }

    final class HandlerThread
    implements Runnable {
        ReusableThread rthread;
        Socket socket;
        String stamp;
        InetAddress address;
        InputStream in;
        boolean remove;
        short requestdescriptor;

        HandlerThread() {
            this.rthread = new ReusableThread((Runnable)this, HandlerThreadPool.this.threadpool);
        }

        void start(Socket socket, boolean bl) {
            block8: {
                this.socket = socket;
                this.remove = bl;
                this.address = socket.getInetAddress();
                this.stamp = socket.getInetAddress().toString() + " ";
                try {
                    this.in = socket.getInputStream();
                    this.requestdescriptor = (short)this.in.read();
                    if (this.requestdescriptor == 0) {
                        String string = new String(IOUtils.readPascalBytes(this.in));
                        OutputStream outputStream = socket.getOutputStream();
                        if (string.equals(HandlerThreadPool.this.server.password)) {
                            outputStream.write(0);
                            HandlerThreadPool.this.server.logger.log(this.stamp + "initiated shutdown");
                            HandlerThreadPool.this.server.doShutdown();
                        } else {
                            HandlerThreadPool.this.server.logger.log(this.stamp + "incorrect password for shutdown");
                            outputStream.write(2);
                        }
                        if (bl) {
                            HandlerThreadPool.this.removeOverflow(this);
                        }
                        socket.close();
                        return;
                    }
                    this.stamp = this.stamp + "(" + this.requestdescriptor + ") ";
                    this.rthread.start();
                }
                catch (Throwable throwable) {
                    HandlerThreadPool.this.server.logger.log(this.stamp + "Exception occured (" + throwable.getClass().getName() + ") during processing request: " + throwable.getMessage());
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    socket = null;
                    this.stamp = null;
                    this.in = null;
                    this.address = null;
                    if (!bl) break block8;
                    HandlerThreadPool.this.removeOverflow(this);
                }
            }
        }

        public void run() {
            TransactionHandler transactionHandler;
            block27: {
                OutputStream outputStream = null;
                transactionHandler = null;
                boolean bl = false;
                try {
                    outputStream = this.socket.getOutputStream();
                    short s = 0;
                    while (s < HandlerThreadPool.this.server.requestdescriptorsnum) {
                        RequestDescriptor requestDescriptor = (RequestDescriptor)HandlerThreadPool.this.server.requestdescriptors.get(s);
                        if (requestDescriptor.contains(this.requestdescriptor)) {
                            RequestHandler requestHandler = requestDescriptor.getHandler();
                            requestDescriptor.initSocket(this.socket);
                            if (requestHandler instanceof OneWayRequestHandler) {
                                transactionHandler = ((OneWayRequestHandler)requestHandler).handle(this.requestdescriptor, this.socket.getInetAddress(), IOUtils.readPascalBytes(this.socket.getInputStream()));
                                outputStream.write(0);
                                bl = true;
                            } else if (requestHandler instanceof TwoWayRequestHandler) {
                                byte[] byArray = IOUtils.readPascalBytes(this.socket.getInputStream());
                                MessageHandler messageHandler = ((TwoWayRequestHandler)requestHandler).handle(this.requestdescriptor, this.socket.getInetAddress());
                                transactionHandler = messageHandler;
                                byArray = messageHandler.handle(byArray);
                                outputStream.write(0);
                                bl = true;
                                IOUtils.writePascalBytes(outputStream, byArray);
                            } else {
                                MessageHandler messageHandler = ((InteractiveRequestHandler)requestHandler).handle(this.requestdescriptor, this.socket.getInetAddress());
                                transactionHandler = messageHandler;
                                InputStream inputStream = this.socket.getInputStream();
                                while (inputStream.read() != 0) {
                                    byte[] byArray = messageHandler.handle(IOUtils.readPascalBytes(inputStream));
                                    if (byArray == null) break;
                                    outputStream.write(0);
                                    IOUtils.writePascalBytes(outputStream, byArray);
                                }
                                outputStream.write(0);
                                bl = true;
                            }
                            transactionHandler.commit();
                            break;
                        }
                        s = (short)(s + 1);
                    }
                    this.socket.close();
                }
                catch (IOException iOException) {
                    HandlerThreadPool.this.server.logger.log(this.stamp + "Exception occured (" + iOException.getClass().getName() + ") during processing request: " + iOException.getMessage());
                    if (!bl && outputStream != null) {
                        try {
                            outputStream.write(1);
                        }
                        catch (Throwable throwable) {
                            HandlerThreadPool.this.server.logger.log(this.stamp + "Exception occured (" + throwable.getClass().getName() + ") during sending error status after last exception: " + throwable.getMessage());
                        }
                    }
                    try {
                        this.socket.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (transactionHandler != null) {
                        try {
                            transactionHandler.rollback();
                        }
                        catch (Throwable throwable) {
                            HandlerThreadPool.this.server.logger.log(this.stamp + "Exception occured (" + throwable.getClass().getName() + ") during rollback of " + transactionHandler + " after last exception: " + throwable.getMessage());
                        }
                    }
                }
                catch (Throwable throwable) {
                    HandlerThreadPool.this.server.logger.log(this.stamp + "Exception occured (" + throwable.getClass().getName() + ") during processing request: " + throwable.getMessage());
                    if (!bl && outputStream != null) {
                        try {
                            outputStream.write(2);
                        }
                        catch (Throwable throwable2) {
                            HandlerThreadPool.this.server.logger.log(this.stamp + "Exception occured (" + throwable2.getClass().getName() + ") during sending error status after last exception: " + throwable2.getMessage());
                        }
                    }
                    try {
                        this.socket.close();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    if (transactionHandler == null) break block27;
                    try {
                        transactionHandler.rollback();
                    }
                    catch (Throwable throwable4) {
                        HandlerThreadPool.this.server.logger.log(this.stamp + "Exception occured (" + throwable4.getClass().getName() + ") during rollback of " + transactionHandler + " after last exception: " + throwable4.getMessage());
                    }
                }
            }
            if (transactionHandler != null) {
                transactionHandler.release();
            }
            if (this.remove) {
                HandlerThreadPool.this.removeOverflow(this);
            }
        }
    }
}

