/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.cachalot.eru;

import com.rathedg.cachalot.Constants;
import com.rathedg.cachalot.eru.RequestHandler;
import com.rathedg.socketserver.IntervalRequestDescriptor;
import com.rathedg.socketserver.PropertiesSocketServerConfig;
import com.rathedg.socketserver.SocketServer;
import com.rathedg.util.PropertyExtractor;
import com.rathedg.util.exception.InitializationException;
import com.rathedg.util.exception.InvalidConfigurationException;
import com.rathedg.util.exception.InvalidValueException;
import com.rathedg.util.log.LoggerInterface;
import com.rathedg.util.log.PropertiesLoggerConfig;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;

public final class ERUSStarter
implements Constants {
    private static final String OUTPUT_BANNER = "\nRatheDG Cachalot System 1.2.0. Event Registration Unit.\n";

    public static void main(String[] stringArray) {
        System.out.println(OUTPUT_BANNER);
        if (ERUSStarter.start(stringArray)) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    public static boolean start(String[] stringArray) {
        LoggerInterface loggerInterface = null;
        try {
            if (stringArray.length != 1) {
                throw new InvalidConfigurationException();
            }
            PropertyExtractor propertyExtractor = null;
            try {
                propertyExtractor = new PropertyExtractor(stringArray[0]);
            }
            catch (IOException iOException) {
                System.out.println("Error reading configuration file.");
                return true;
            }
            loggerInterface = PropertiesLoggerConfig.create(propertyExtractor);
            PropertiesSocketServerConfig propertiesSocketServerConfig = new PropertiesSocketServerConfig(propertyExtractor);
            int n = propertyExtractor.getIntegerNotNullNotEmpty("socket.timeout", true);
            int n2 = propertyExtractor.getIntegerNotNullNotEmpty("socket.linger", true);
            boolean bl = propertyExtractor.getBooleanNotNullNotEmpty("socket.nodelay", true, true);
            RequestHandler requestHandler = new RequestHandler();
            requestHandler.init(propertyExtractor.map(), loggerInterface);
            IntervalRequestDescriptor intervalRequestDescriptor = new IntervalRequestDescriptor(1, 4, requestHandler, n, n2, bl);
            ArrayList<IntervalRequestDescriptor> arrayList = new ArrayList<IntervalRequestDescriptor>();
            arrayList.add(intervalRequestDescriptor);
            new SocketServer(propertiesSocketServerConfig.port, propertiesSocketServerConfig.address, propertiesSocketServerConfig.connections, propertiesSocketServerConfig.threads, arrayList, propertiesSocketServerConfig.password, loggerInterface);
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            if (invalidConfigurationException.getMessage() == null) {
                System.out.println("Usage: ERUSStarter <configuration file>");
            } else {
                System.out.println("Error in configuration file: " + invalidConfigurationException.getMessage());
            }
            return true;
        }
        catch (InvalidValueException invalidValueException) {
            if (invalidValueException.getMessage() == null) {
                System.out.println("Usage: ERUSStarter <configuration file>");
            } else {
                System.out.println("Error in configuration file: " + invalidValueException.getMessage());
            }
            return true;
        }
        catch (InitializationException initializationException) {
            loggerInterface.log("Error during initializing: " + initializationException);
        }
        catch (UnknownHostException unknownHostException) {
            loggerInterface.log("Unknown host '" + unknownHostException.getMessage() + "'");
            return true;
        }
        catch (IOException iOException) {
            loggerInterface.log("Error initializing server socket: " + iOException);
            return true;
        }
        return false;
    }
}

