// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : tape.h
//
//  DESCRIPTION :
//         Class Tape (Definition)
//
// ##############################################################


// ###############
#ifndef _TAPE_H
#define _TAPE_H

// ================
#include "symbol.h"
// ================


// =========
class Tape
{
friend class TuringMachine;
  private :
    // ------ Private Data ------
    const vector<symbol_mt>	empty_symbols_alphabet_;
    const vector<symbol_mt>	internal_alphabet_;
    const vector<symbol_mt>	input_alphabet_;
    
    vector<symbol_mt>		tape_;
    bool			input_alphabet_must_be_;
    size_t			position_;
    bool			check_results_;
    size_t			max_symbol_size_;


    static vector<symbol_mt> 	write_nothing_pseudo_symbols_s;

    // ------ Private Methods ------
    void	clear_it (bool set_marker_flag_i);
    vector<symbol_mt>	get_full_alphabet() const;

    void	shift_position (shift_t shift_i);
    symbol_mt	get_position_symbol () const;
    void	set_position_symbol (const symbol_mt& symbol_i);
    size_t	get_position () const;
    symbol_mt	get_marker () const;

    void	set_max_symbol_size_ ();
    
 
    bool	is_input_symbol (const symbol_mt& symbol_i) const;
    bool	is_internal_symbol (const symbol_mt& symbol_i) const;
    bool	is_internal_not_marker_symbol (const symbol_mt& symbol_i) const;
    bool	is_marker_symbol (const symbol_mt& symbol_i) const;
    bool	is_empty_symbol (const symbol_mt& symbol_i) const;
    bool	is_valid_symbol (const symbol_mt& symbol_i) const;
    bool	is_valid_shift (shift_t shift_i) const;
    static bool	is_write_nothing_pseudo_symbol_s (const symbol_mt& symbol_i);

    bool	check_alphabet () const;
    void	show_alphabet (const string& msg_i = string()) const;
    void	show_tape (const string& msg_i = string()) const;

  public :
   Tape () {}
    Tape (
	const vector<symbol_mt>& empty_symbols_alphabet_i, 
	const vector<symbol_mt>& internal_alphabet_i,
	const vector<symbol_mt>& input_alphabet_i = vector<symbol_mt> (),
	const string& msg_i = string()
	);
    ~Tape ();  
   static void	set_shared_data_s (const vector<symbol_mt>& write_nothing_pseudo_symbols_i);
   static void	clear_shared_data_s ();
};

#endif	// _TAPE_H
