// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : symbol.h
//
//  DESCRIPTION :
//         Classes symbol_t, symbol_mt (Declaration)
//
// ##############################################################


// ###############
#ifndef _SYMBOL_H
#define _SYMBOL_H

// ==============
#include "defs.h"
// ==============


// =========
class symbol_t
{
  protected :
    int		dummy_;
    string	symbol_;

  public :
    symbol_t (const string& str_i = string()) : symbol_ (str_i) {}
    virtual ~symbol_t () {}

    string	getstr_symbol () const {return symbol_; }
};

// =========
class symbol_mt : public symbol_t
{
friend bool operator== (const symbol_mt& inst1_i, const symbol_mt& inst2_i);
friend bool operator!= (const symbol_mt& inst1_i, const symbol_mt& inst2_i);
friend bool operator< (const symbol_mt& inst1_i, const symbol_mt& inst2_i);
friend bool operator> (const symbol_mt& inst1_i, const symbol_mt& inst2_i);
friend ostream& operator<< (ostream& o, const symbol_mt& inst_i);

  public :
    symbol_mt (const string& str_i = string()) : symbol_t (str_i) {}
    ~symbol_mt () {}
};

// -----------
      
// -----------
vector<symbol_mt> vect_string_to_symbol_mt (const vector<string>& vect_i);
vector<vector<symbol_mt> > vect_vect_string_to_symbol_mt (const vector<vector<string> >& vect_i);


#endif	// _SYMBOL_H
