// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : macro.h
//
//  DESCRIPTION :
//         Various macro
//
// ##############################################################


// ###############
#ifndef _MACRO_H
#define _MACRO_H

// =================
#include "version.h"
// =================

#define	COUT	cout << "[ " << setw(12) << left << __FILE__ << ", " << setw (3) << right << __LINE__ << " ] "
#define	BUG_MSG(t)	cout << endl; COUT << "BUG IN PROGRAM : " << t << endl; assert(0)
#define	FATAL_MSG(t)	cout << endl; COUT << "FATAL ERROR : " << t << endl
#define	WARNING_MSG(t)	COUT << "WARNING : " << t << endl
#define	INFO_MSG(t)	cout << string (20, '#') << endl; cout << "INFO : " << t << endl; cout << string (20, '#') << endl

#define	IF_NOT_EMPTY(mg, wd, ch) \
		if (!mg.empty()) \
		{ \
		cout << "\t" << string (wd, ch) << " " << mg << " " << string (wd, ch) << endl; \
		}

#define MIN_VALUE(x,y)  ((x) < (y) ? (x) : (y))
#define MAX_VALUE(x,y)  ((x) > (y) ? (x) : (y))

#define ASSERT(x)       if (!(x)) {cerr << endl << endl << "\t=== BUG IN PROGRAM ===" << endl;}; assert (x)



#define DBG_PRINT(h,o,t)	o << h << "[" << setw(12) << left << __FILE__ << ", " << setw(3) << right << __LINE__ << "; " << __FUNCTION__ << "] " << t << " "

#define DOUT		DBG_PRINT ("", cout, "")
#define DERR		DBG_PRINT ("", cerr, "")

#define NL_DOUT		DBG_PRINT ("\n", cout, "")
#define NL_DERR		DBG_PRINT ("\n", cerr, "")

#define D2OUT(t)	DBG_PRINT ("", cout, t)
#define D2ERR(t)	DBG_PRINT ("", cerr, t)

#define NL_D2OUT(t)	DBG_PRINT ("\n", cout, t)
#define NL_D2ERR(t)	DBG_PRINT ("\n", cerr, t)

#define TRACE_ERR	NL_DERR

#endif	// _MACRO_H
