// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : common.cpp
//
//  DESCRIPTION :
//         Common function etc (Implementation)
//
// ##############################################################


// ===============
#include "common.h"
// ===============


// ==================================
// ---------------------------------
// Is a string an unsigned decimal?
// ---------------------------------
unsigned int is_udec (char * const str_i)
{
  char *p = &str_i[0];
  while (*p) if (!isdigit (*p++)) return 0;
  return str_i[0];
}

// ==================================
// ---------------------------------
// Is a string a signed decimal?
// ---------------------------------
unsigned int is_dec (char * const str_i)
{
  return (is_udec (&str_i[(str_i[0] == '-') || (str_i[0] == '+')]));
}

// ==================================
// ---------------------------------
// Is a string an hexadecimal?
// ---------------------------------
unsigned int is_hex (char * const str_i)
{
  int start_pos = ((str_i[0] == '0') && (str_i[1] == 'x')) ? 2 : 0;
  char *p = &str_i[start_pos];
  while (*p) if (!isxdigit (*p++)) return 0;
  return str_i[start_pos];
}

// ----------------------
string get_next_size_ordered_word (
		const string& cur_str_i, 
		const string& alphabet_i
		)
{
  for (string::const_iterator iter = alphabet_i.begin(); 
                              iter != alphabet_i.end(); 
                              iter++
                              )
  {
    if (count (iter + 1, alphabet_i.end(), *iter))
    {
      BUG_MSG ("Alphabet = " 
	      << alphabet_i 
	      << " : " 
	      << "Symbol <" 
	      << *iter 
	      << "> occurs more than once in alphabet"
	      );
      return string (); 
    }
  } 

  for (string::const_iterator iter = cur_str_i.begin(); 
                              iter != cur_str_i.end(); 
                              iter++
                              )
  {
    if (!count (alphabet_i.begin(), alphabet_i.end(), *iter))
    {
      BUG_MSG ("Alphabet = " 
	      << alphabet_i 
	      << " ; Word = "
	      << cur_str_i
	      << " : " 
	      << "Symbol <" 
	      << *iter 
	      << "> doesn't belong to the alphabet"
	      );
      return string (); 
    }
  }

  // ---------------------------
  if (cur_str_i.empty())
  {
    return (string (1, *alphabet_i.begin()));
  }

  if ((*cur_str_i.rbegin()) == (*alphabet_i.rbegin()))
  {
    return (
		get_next_size_ordered_word (
			cur_str_i.substr (0, cur_str_i.size() - 1), 
			alphabet_i
			)
		+
		(*alphabet_i.begin())
	   );
  }

  return (
		cur_str_i.substr (0, cur_str_i.size() - 1) 
		+
		alphabet_i [(alphabet_i.find (*cur_str_i.rbegin())) + 1]
	 );
}

// ----------------
bool get_true_vector (const vector<bool>& v1)
{
  assert (!v1.empty());
  for (size_t i = 0; i < v1.size(); i++)
  {
    if (!v1[i]) return false;
  }
  return true;
}
