<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="xml" omit-xml-declaration="yes" encoding="iso-8859-1"/>
    <xsl:template match="Mail[@Id!='']">

        <TABLE border="0" width="100%" cellpadding="0" cellspacing="0" class="Mtable"> 
                <TR bgcolor="#FFF7E5">
                    <TD align="middle" width="15">
                        <xsl:if test="@Status='R'">
                            <IMG src="./images/mailr.GIF" width="15" height="14"/>
                        </xsl:if>
                        <xsl:if test="@Status='U'">
                            <IMG src="./images/mailu.GIF" width="15" height="14"/>
                        </xsl:if>
                        <xsl:if test="not(@Status) or string(@Status)=''">
                            <IMG src="./images/spacer.gif" width="15" height="14"/>
                        </xsl:if>
                    </TD>                    
                    <TD  width="9">
                        <xsl:if test="@Pri='h'">
                            <IMG src="./images/pri-h.GIF" width="9" height="14"/>
                        </xsl:if>
                        <xsl:if test="@Pri='l'">
                            <IMG src="./images/pri-l.GIF" width="9" height="14"/>
                        </xsl:if>
                        <xsl:if test="not(@Pri)">
                            <IMG src="./images/spacer.gif" width="9" height="14"/>
                        </xsl:if>
                    </TD>
                    <TD width="10">
                        <INPUT type="CHECKBOX" name="DEL">
                            <xsl:attribute name="value"><xsl:value-of select="@Id"/></xsl:attribute>
                        </INPUT>
                    </TD>
                    <TD width="30%" align="left">
                        <xsl:if test="string-length(@From) > 36">
                            <xsl:value-of select="substring(@From, 1, 36)"/>...                                                       
                        </xsl:if>                                
                        <xsl:if test="not(string-length(@From) > 36)">
                            <xsl:value-of select="@From"/> 
                        </xsl:if>                                
                    </TD>
                    <TD width="50%" align="left">
                        <A>
                            <xsl:attribute name="href">ReadMail.asp?id=<xsl:value-of select="@Id"/></xsl:attribute>
                            <xsl:attribute name="target">_blank</xsl:attribute>
                            <xsl:if test="string(@Subject)=''">No Subject</xsl:if>
                            <xsl:value-of select="@Subject"/>
                        </A>
                    </TD>
                    <TD width="70" align="right">
                        <xsl:value-of select="substring(@Date, 6, 11)"/>
                    </TD>
                    <TD width="10">
                        <IMG src="./images/spacer.gif" width="10" height="14"/>
                    </TD>
                    <TD width="40" align="right" nowrap="nowrap">
                        <xsl:value-of select="@Size"/>
                    </TD>
                    <TD width="15">                    
                        <IMG src="./images/spacer.gif" width="15" height="14"/>
                    </TD>
                </TR>
        </TABLE>

    </xsl:template>
</xsl:stylesheet>
