{*******************************************************}
{                     PHP4Delphi                        }
{               PHP - Delphi interface                  }
{                       v.5.0                           }
{ Author:                                               }
{ Serhiy Perevoznyk                                     }
{ serge_perevoznyk@hotmail.com                          }
{ http://users.chello.be/ws36637                        }
{*******************************************************}
{$I PHP.INC}

//  Important:
//  Please check PHP version you are using and change php.inc file
//  See php.inc for more details

{
You can download the latest version of PHP from
http://www.php.net/downloads.php
You have to download and install PHP separately.
It is not included in the package.

For more information on the PHP Group and the PHP project,
please see <http://www.php.net>.
}

unit php4delphi;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  zendAPI, PHPAPI, DelphiFunctions;


type

  EDelphiErrorEx = class(Exception);

  TPHPLogMessage = procedure (Sender : TObject; AText : string) of object;
  TPHPErrorEvent = procedure (Sender : TObject; AText : string; AType : integer) of object;

  TPHPVariable = class(TCollectionItem)
  private
    FName  : string;
    FValue : string;
  protected
    function  GetDisplayName : string; override;
  published
    property Name  : string read FName write FName;
    property Value : string read FValue write FValue;
  end;

  TPHPVariables = class(TCollection)
  private
    FOwner : TComponent;
    procedure SetItem(Index: Integer; const Value: TPHPVariable);
    function  GetItem(Index: Integer): TPHPVariable;
  protected
    function  GetOwner : TPersistent; override;
  public
    function Add: TPHPVariable;
    constructor Create(AOwner: TComponent);
    function GetVariables : string;
    function IndexOf(AName : string) : integer;
    procedure AddRawString(AString : string);
    property Items[Index: Integer]: TPHPVariable read GetItem write SetItem; default;
  end;

  TPHPConstant = class(TCollectionItem)
  private
    FName : string;
    FValue : string;
  protected
    function GetDisplayName : string; override;
  published
    property Name  : string read FName write FName;
    property Value : string read FValue write FValue;
  end;

  TPHPConstants = class(TCollection)
  private
    FOwner : TComponent;
    procedure SetItem(Index: Integer; const Value: TPHPConstant);
    function  GetItem(Index: Integer): TPHPConstant;
  protected
    function  GetOwner : TPersistent; override;
  public
    function Add: TPHPConstant;
    constructor Create(AOwner: TComponent);
    function IndexOf(AName : string) : integer;
    property Items[Index: Integer]: TPHPConstant read GetItem write SetItem; default;
  end;

  IPHPLibrary = interface (IUnknown)
  ['{484AE2CA-755A-437C-9B60-E3735973D0A9}']
    procedure AddModule(AModule : Pointer);
    procedure RemoveModule(AModule : Pointer);
    procedure HandleRequest(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer);
   end;

  TpsvCustomPHP = class(TComponent, IPHPLibrary)
  private
    FAdditionalModules : TList;
    FTerminated : boolean;
    FConstants : TphpConstants;
    compiled_string : PChar;
    TSRMLS_D  : pppointer;
    FVariables : TPHPVariables;
    FBuffer : string;
    delphi_sapi_module : sapi_module_struct;
    php_delphi_module : Tzend_module_entry;
    FOnLogMessage : TPHPLogMessage;
    FOnScriptError : TPHPErrorEvent;
    FHTMLErrors : boolean;
    FHandleErrors : boolean;
    FFileName : string;
    FAbout : string;
    procedure SetVariables(Value : TPHPVariables);
    procedure SetConstants(Value : TPHPConstants);
  protected
    procedure PrepareModule; virtual;
    procedure StartupModule; virtual;
    procedure PrepareIniEntry; virtual;
    procedure PrepareResult(TSRMLS_D : pointer); virtual;
    procedure RegisterInternalConstants(TSRMLS_DC : pointer); virtual;
    procedure AddModule(AModule : Pointer); virtual;
    procedure RemoveModule(AModule : Pointer); virtual;
    procedure HandleRequest(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); virtual;
  public
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    function  Execute : string; overload;
    function  Execute(AFileName : string) : string; overload;
    function  RunCode(ACode : string) : string; overload;
    function  RunCode(ACode : TStringList) : string; overload;
    property About : string read FAbout write FAbout stored False;
    property FileName  : string read FFileName write FFileName;
    property Constants : TPHPConstants read FConstants write SetConstants;
    property Variables : TPHPVariables read FVariables write SetVariables;
    property HTMLErrors : boolean read FHTMLErrors write FHTMLErrors default false;
    property HandleErrors : boolean read FHandleErrors write FHandleErrors default true;
    property OnLogMessage : TPHPLogMessage read FOnLogMessage write FOnLogMessage;
    property OnScriptError : TPHPErrorEvent read FOnScriptError write FOnScriptError;
  end;


  TpsvPHP = class(TpsvCustomPHP)
  published
    property About;
    property FileName;
    property Constants;
    property Variables;
    property HTMLErrors;
    property HandleErrors;
    property OnLogMessage;
    property OnScriptError;
  end;

    
implementation

uses
  PHPFunctions, phpCustomLibrary;

procedure php_info_delphi(zend_module : Pointer; TSRMLS_DC : pointer); cdecl;
begin
  php_info_print_table_start();
  php_info_print_table_row(2, PChar('SAPI module version'), PChar('PHP4Delphi 5.0 Sep 2003'));
  php_info_print_table_row(2, PChar('Variables support'), PChar('Yes'));
  php_info_print_table_row(2, PChar('Constants support'), PChar('Yes'));
  php_info_print_table_row(2, PChar('Home page'), PChar('http://users.chello.be/ws36637'));
  php_info_print_table_end();
end;

function php_delphi_startup(sapi_module : pointer) : integer; cdecl;
begin
  result := php_module_startup(sapi_module, nil, 0);
end;

function php_delphi_deactivate(p : pointer) : integer; cdecl;
begin
  result := 0;
end;


function php_delphi_ub_write(str : pchar; len : uint; p : pointer) : integer; cdecl;
var
 s : string;
 php : TpsvPHP;
 gl : psapi_globals_struct;
begin
  Result := 0;
  gl := GetSAPIGlobals(p);
  if Assigned(gl) then
   begin
     php := TpsvPHP(gl^.server_context);
     if Assigned(php) then
      begin
        SetLength(s, len);
        s := Copy(str,1,len);
        php.FBuffer := php.FBuffer + s;
        result := len;
      end;
   end;
end;


procedure php_delphi_register_variables(val : pzval; p : pointer); cdecl;
var
 php : TpsvPHP;
 gl : psapi_globals_struct;
 ts : pointer;
 cnt : integer;
begin
  ts := ts_resource_ex(0, nil);
  gl := GetSAPIGlobals(ts);
  php := TpsvPHP(gl^.server_context);
  php_register_variable('SERVER_NAME','DELPHI', val, p);
  php_register_variable('SERVER_SOFTWARE', 'Delphi', val, p);
  if Assigned(php) then
   begin
     for cnt := 0 to php.Variables.Count - 1 do
       begin
         php_register_variable(PChar(php.Variables[cnt].Name),
                PChar(php.Variables[cnt].Value), val, p);
       end;
   end;
end;

function php_delphi_log_message(msg : Pchar) : integer; cdecl;
var
 php : TpsvPHP;
 gl : psapi_globals_struct;
 p : pointer;
begin
  p := ts_resource_ex(0, nil);
  gl := GetSAPIGlobals(p);
  php := TpsvPHP(gl^.server_context);
  if Assigned(php) then
   begin
     if Assigned(php.OnLogMessage) then
       php.FOnLogMessage(php, msg)
        else
         ShowMessage(msg);
    end
      else
        ShowMessage(msg);
  result := 0;
end;

procedure php_delphi_send_header(p1, p2, p3 : pointer); cdecl;
begin
  //
end;

function php_delphi_read_cookies(p1 : pointer) : pointer; cdecl;
begin
  result := nil;
end;



procedure delphi_error_cb(_type : integer; const error_filename : PChar;
   const error_lineno : uint; const _format : PChar; args : PChar); cdecl;
var
 buffer  : array[0..1023] of char;
 err_msg : PChar;
 php : TpsvPHP;
 gl : psapi_globals_struct;
 p : pointer;
 error_type_str : string;
begin
  wvsprintf(buffer, _format, args);
  err_msg := buffer;
  p := ts_resource_ex(0, nil);
  gl := GetSAPIGlobals(p);
  php := TpsvPHP(gl^.server_context);
  if assigned(php) then begin
   if Assigned(php.FOnScriptError) then
    php.FOnScriptError(php, Err_Msg, _type);
    case _type of
      E_ERROR,
      E_CORE_ERROR,
      E_COMPILE_ERROR,
      E_USER_ERROR:
          error_type_str := 'Fatal error';
      E_WARNING,
      E_CORE_WARNING,
      E_COMPILE_WARNING,
      E_USER_WARNING :
          error_type_str := 'Warning';
      E_PARSE:
          error_type_str := 'Parse error';
      E_NOTICE,
      E_USER_NOTICE:
          error_type_str := 'Notice';
      else
          error_type_str := 'Unknown error';
   end;

   php_log_err(PChar(Format('PHP4DELPHI %s:  %s in %s on line %d', [error_type_str, buffer, error_filename, error_lineno])), p);
 end;

  raise EDelphiErrorEx.Create('delphi_error_cb');
end;

{ TPHPVariables }

function TPHPVariables.Add: TPHPVariable;
begin
  result := TPHPVariable(inherited Add);
end;

constructor TPHPVariables.Create(AOwner: TComponent);
begin
 inherited create(TPHPVariable);
 FOwner := AOwner;
end;

function TPHPVariables.GetItem(Index: Integer): TPHPVariable;
begin
  Result := TPHPVariable(inherited GetItem(Index));
end;

procedure TPHPVariables.SetItem(Index: Integer; const Value: TPHPVariable);
begin
  inherited SetItem(Index, Value)
end;

function TPHPVariables.GetOwner : TPersistent;
begin
  Result := FOwner;
end;

function TPHPVariables.GetVariables: string;
var i : integer;
begin
  for i := 0 to Count - 1 do
    begin
      Result := Result + Items[i].FName + '=' + Items[i].FValue;
      if i < Count - 1 then
        Result := Result + '&';
    end;
end;

function TPHPVariables.IndexOf(AName: string): integer;
var
 i : integer;
begin
 Result := -1;
 for i := 0 to Count - 1 do
  begin
    if SameText(Items[i].Name, AName) then
     begin
       Result := i;
       break;
     end;
  end;
end;

procedure TPHPVariables.AddRawString(AString : string);
var
 SL : TStringList;
 i  : integer;
 j  : integer;
 V  :  TPHPVariable;
begin
  if AString[Length(AString)] = ';' then
   SetLength(AString, Length(AString)-1);
  SL := TStringList.Create;
  ExtractStrings([';'], [], PChar(AString), SL);
  for i := 0 to SL.Count - 1 do
   begin
     j := IndexOf(SL.Names[i]);
     if  j= -1 then
      begin
        V := Add;
        V.Name := SL.Names[i];
        V.Value := Copy(SL[I], Length(SL.Names[i]) + 2, MaxInt);
      end
       else
        begin
          Items[j].Value := Copy(SL[I], Length(SL.Names[i]) + 2, MaxInt);
        end;
   end;
  SL.Free;
end;

{ TpsvCustomPHP }

constructor TpsvCustomPHP.Create(AOwner: TComponent);
begin
  inherited;
  FAdditionalModules := TList.Create;
  FVariables := TPHPVariables.Create(Self);
  FConstants := TPHPConstants.Create(Self);
  FHandleErrors := true;
  FHTMLErrors := false;
end;

destructor TpsvCustomPHP.Destroy;
begin
  FVariables.Free;
  FConstants.Free;
  FAdditionalModules.Free;
  inherited;
end;


procedure TpsvCustomPHP.StartupModule;
var
 i : integer;
 p : pointer;
begin
  sapi_startup(@delphi_sapi_module);
  php_module_startup(@delphi_sapi_module, @php_delphi_module, 1);

  for i := 0 to FAdditionalModules.Count -1 do
   begin
     p := FAdditionalModules[i];
     TCustomPHPLibrary(p).Refresh;
     p := @TCustomPHPLibrary(p).LibraryEntry;
     php_startup_extensions(@p, 1);
   end;
end;

function TpsvCustomPHP.Execute : string;
var
  gl  : psapi_globals_struct;
  cnt : integer;
  file_handle : zend_file_handle;
begin
  FBuffer := '';
  if not FileExists(FFileName) then
   raise Exception.CreateFmt('File %s does not exists', [FFileName]);

  if not PHPLoaded then
    raise EDelphiErrorEx.Create('php4ts.dll not found');

  tsrm_startup(128, 1, TSRM_ERROR_LEVEL_CORE , nil);
  PrepareModule;
  StartupModule;

  TSRMLS_D := ts_resource_ex(0, nil);

  gl := GetSAPIGlobals(TSRMLS_D);
  gl^.server_context := Self;

  PrepareIniEntry;

  php_request_startup(TSRMLS_D);

  for cnt := 0 to FConstants.Count - 1 do
  begin
    zend_register_string_constant(PChar(FConstants[cnt].Name),
      strlen(PChar(FConstants[cnt].Name)) + 1,
      PChar(FConstants[cnt].Value), CONST_PERSISTENT or CONST_CS, 0, TSRMLS_D);
  end;

  RegisterInternalConstants(TSRMLS_D);
  php_register_variable('PHP_SELF', '_', nil, TSRMLS_D);

  file_handle._type := ZEND_HANDLE_FILENAME;
  file_handle.filename := PChar(FFileName);
  file_handle.opened_path := nil;
  file_handle.free_filename := 0;
  try
    php_execute_script(@file_handle, TSRMLS_D);
  except
    FBuffer := '';
  end;

  PrepareResult(TSRMLS_D);

  try
    php_request_shutdown(nil);
  except
  end;

  php_module_shutdown(TSRMLS_D);
  tsrm_shutdown(nil);

  Result := FBuffer;
end;

function TpsvCustomPHP.RunCode(ACode : string) : string;
var
  gl  : psapi_globals_struct;
  cnt : integer;
begin
  FBuffer := '';
  FTerminated := false;
  if not PHPLoaded then
    raise EDelphiErrorEx.Create('php4ts.dll not found');

  if ACode = '' then
   Exit;

  tsrm_startup(128, 1, TSRM_ERROR_LEVEL_CORE , nil);
  PrepareModule;
  StartupModule;


  TSRMLS_D := ts_resource_ex(0, nil);

  gl := GetSAPIGlobals(TSRMLS_D);
  gl^.server_context := Self;

  PrepareIniEntry;

  php_request_startup(TSRMLS_D);

  for cnt := 0 to FConstants.Count - 1 do
  begin
    zend_register_string_constant(PChar(FConstants[cnt].Name),
      strlen(PChar(FConstants[cnt].Name)) + 1,
      PChar(FConstants[cnt].Value), CONST_PERSISTENT or CONST_CS, 0, TSRMLS_D);
  end;

  RegisterInternalConstants(TSRMLS_D);
  php_register_variable('PHP_SELF', '_', nil, TSRMLS_D);

  compiled_string := zend_make_compiled_string_description('embedded', TSRMLS_D );
  try
    zend_eval_string(PChar(ACode), nil, compiled_string, TSRMLS_D);
  except
   FBuffer := '';
   FTerminated := true;
  end;
  efree(compiled_string);

  PrepareResult(TSRMLS_D);

  try
    if not FTerminated then
      php_request_shutdown(nil);
  except
  end;

  php_module_shutdown(TSRMLS_D);
  tsrm_shutdown(nil);

  Result := FBuffer;
end;

function minit (_type : integer; module_number : integer; TSRMLS_DC : pointer) : integer; cdecl;
begin
  RegisterAuthorClass(TSRMLS_DC);
  RESULT := SUCCESS;
end;

procedure TpsvCustomPHP.PrepareModule;
begin
  delphi_sapi_module.name := 'php4delphi';  (* name *)
  delphi_sapi_module.pretty_name := 'PHP for Delphi';  (* pretty name *)
  delphi_sapi_module.startup := @php_delphi_startup;    (* startup *)
  delphi_sapi_module.shutdown := @php_module_shutdown_wrapper;   (* shutdown *)
  delphi_sapi_module.activate:= nil;  (* activate *)
  delphi_sapi_module.deactivate := @php_delphi_deactivate;  (* deactivate *)
  delphi_sapi_module.ub_write := @php_delphi_ub_write;      (* unbuffered write *)
  delphi_sapi_module.flush := nil;
  delphi_sapi_module.stat:= nil;
  delphi_sapi_module.getenv:= nil;
  delphi_sapi_module.sapi_error := @zend_error;  (* error handler *)
  delphi_sapi_module.header_handler := nil;
  delphi_sapi_module.send_headers := nil;
  delphi_sapi_module.send_header :=    @php_delphi_send_header;
  delphi_sapi_module.read_post := nil;
  delphi_sapi_module.read_cookies := @php_delphi_read_cookies;
  delphi_sapi_module.register_server_variables := @php_delphi_register_variables;   (* register server variables *)
  delphi_sapi_module.log_message := @php_delphi_log_message;  (* Log message *)
  delphi_sapi_module.php_ini_path_override := nil;
  delphi_sapi_module.block_interruptions := nil;
  delphi_sapi_module.unblock_interruptions := nil;
  delphi_sapi_module.default_post_reader := nil;
  delphi_sapi_module.treat_data := 0;
  delphi_sapi_module.executable_location := nil;
  delphi_sapi_module.php_ini_ignore := 0;

  InitDelphiFunctions;
  php_delphi_module.size := sizeOf(Tzend_module_entry);
  php_delphi_module.zend_api := ZEND_MODULE_API_NO;
  php_delphi_module.zend_debug := 0;
  php_delphi_module.zts := USING_ZTS;
  php_delphi_module.name := 'php4delphi_support';
  php_delphi_module.functions := @DelphiTable[0];
  php_delphi_module.module_startup_func := @minit;
  php_delphi_module.module_shutdown_func := nil;
  php_delphi_module.info_func := @php_info_delphi;
  php_delphi_module.version := '5.0';
  php_delphi_module.global_startup_func := nil;
  php_delphi_module.request_shutdown_func := nil;
  php_delphi_module.global_id := 0;
  php_delphi_module.module_started := 0;
  php_delphi_module._type := 0;
  php_delphi_module.handle := nil;
  php_delphi_module.module_number := 0;
end;

function TpsvCustomPHP.RunCode(ACode: TStringList): string;
begin
  if Assigned(ACode) then
   Result := RunCode(ACode.Text);
end;

procedure TpsvCustomPHP.SetConstants(Value: TPHPConstants);
begin
  FConstants.Assign(Value);
end;

procedure TpsvCustomPHP.SetVariables(Value: TPHPVariables);
begin
  FVariables.Assign(Value);
end;


procedure TpsvCustomPHP.PrepareIniEntry;
var
  p   : integer;
begin
  if not PHPLoaded then
   Exit;

  if FHandleErrors then
   begin
     p := integer(GetProcAddress(PHPLib, 'zend_error_cb'));
     asm
       mov edx, dword ptr [p]
       mov dword ptr [edx], offset delphi_error_cb
     end;
   end;

  zend_alter_ini_entry('register_argc_argv', 19, '0', 1, ZEND_INI_SYSTEM, ZEND_INI_STAGE_ACTIVATE);
  if FHTMLErrors then
   zend_alter_ini_entry('html_errors',        12, '1', 1, ZEND_INI_SYSTEM, ZEND_INI_STAGE_ACTIVATE)
     else
       zend_alter_ini_entry('html_errors',        12, '0', 1, ZEND_INI_SYSTEM, ZEND_INI_STAGE_ACTIVATE);
  zend_alter_ini_entry('implicit_flush',     15, '1', 1, ZEND_INI_SYSTEM, ZEND_INI_STAGE_ACTIVATE);
  zend_alter_ini_entry('max_execution_time', 19, '0', 1, ZEND_INI_SYSTEM, ZEND_INI_STAGE_ACTIVATE);
end;


const
  Colors: array[0..41] of TIdentMapEntry = (
    (Value: clBlack; Name: 'clBlack'),
    (Value: clMaroon; Name: 'clMaroon'),
    (Value: clGreen; Name: 'clGreen'),
    (Value: clOlive; Name: 'clOlive'),
    (Value: clNavy; Name: 'clNavy'),
    (Value: clPurple; Name: 'clPurple'),
    (Value: clTeal; Name: 'clTeal'),
    (Value: clGray; Name: 'clGray'),
    (Value: clSilver; Name: 'clSilver'),
    (Value: clRed; Name: 'clRed'),
    (Value: clLime; Name: 'clLime'),
    (Value: clYellow; Name: 'clYellow'),
    (Value: clBlue; Name: 'clBlue'),
    (Value: clFuchsia; Name: 'clFuchsia'),
    (Value: clAqua; Name: 'clAqua'),
    (Value: clWhite; Name: 'clWhite'),
    (Value: clScrollBar; Name: 'clScrollBar'),
    (Value: clBackground; Name: 'clBackground'),
    (Value: clActiveCaption; Name: 'clActiveCaption'),
    (Value: clInactiveCaption; Name: 'clInactiveCaption'),
    (Value: clMenu; Name: 'clMenu'),
    (Value: clWindow; Name: 'clWindow'),
    (Value: clWindowFrame; Name: 'clWindowFrame'),
    (Value: clMenuText; Name: 'clMenuText'),
    (Value: clWindowText; Name: 'clWindowText'),
    (Value: clCaptionText; Name: 'clCaptionText'),
    (Value: clActiveBorder; Name: 'clActiveBorder'),
    (Value: clInactiveBorder; Name: 'clInactiveBorder'),
    (Value: clAppWorkSpace; Name: 'clAppWorkSpace'),
    (Value: clHighlight; Name: 'clHighlight'),
    (Value: clHighlightText; Name: 'clHighlightText'),
    (Value: clBtnFace; Name: 'clBtnFace'),
    (Value: clBtnShadow; Name: 'clBtnShadow'),
    (Value: clGrayText; Name: 'clGrayText'),
    (Value: clBtnText; Name: 'clBtnText'),
    (Value: clInactiveCaptionText; Name: 'clInactiveCaptionText'),
    (Value: clBtnHighlight; Name: 'clBtnHighlight'),
    (Value: cl3DDkShadow; Name: 'cl3DDkShadow'),
    (Value: cl3DLight; Name: 'cl3DLight'),
    (Value: clInfoText; Name: 'clInfoText'),
    (Value: clInfoBk; Name: 'clInfoBk'),
    (Value: clNone; Name: 'clNone'));

procedure TpsvCustomPHP.RegisterInternalConstants(TSRMLS_DC : pointer);
var
 i : integer;
begin
  for I := Low(Colors) to High(Colors) do
   zend_register_long_constant(PChar(Colors[i].Name), strlen(PChar(Colors[i].Name)) + 1, Colors[i].Value,
    CONST_PERSISTENT or CONST_CS, 0, TSRMLS_DC);
end;

procedure TpsvCustomPHP.AddModule(AModule: Pointer);
begin
  FAdditionalModules.Add(AModule);
end;

procedure TpsvCustomPHP.RemoveModule(AModule: Pointer);
begin
  try
    FAdditionalModules.Remove(AModule);
  except
  end;
end;


procedure TpsvCustomPHP.HandleRequest(ht: integer; return_value, this_ptr: pzval;
  return_value_used: integer; TSRMLS_DC: pointer);
var
  cnt : integer;
  Params : array of Pzval;
  AFunction : TPHPFunction;
  i, j  : integer;
  FActiveFunctionName : string;
begin
  if ( not (zend_get_parameters_ex(ht, @Params) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;

  FActiveFunctionName := get_active_function_name(TSRMLS_DC);

    for i := 0 to FAdditionalModules.Count - 1 do
      begin
        for cnt := 0 to TCustomPHPLibrary(FAdditionalModules[i]).Functions.Count - 1 do
         begin
           if SameText(TCustomPHPLibrary(FAdditionalModules[i]).Functions[cnt].FunctionName, FActiveFunctionName) then
              begin
                AFunction := TCustomPHPLibrary(FAdditionalModules[i]).Functions[cnt];
                if Assigned(AFunction.OnExecute) then
                  begin
                     if AFunction.Parameters.Count <> ht then
                       begin
                         zend_wrong_param_count(TSRMLS_DC);
                         Exit;
                       end;
                     for j := 0 to ht - 1 do
                      begin
                        if not IsParamTypeCorrect(AFunction.Parameters[j].ParamType, Params[j]) then
                         begin
                           zend_error(E_WARNING, PChar(Format('Wrong parameter type for %s()', [get_active_function_name(TSRMLS_DC)])));
                           Exit;
                         end;
                         AFunction.Parameters[j].Value := zval2variant(Params[j]^);
                      end;
                    AFunction.OnExecute(Self, AFunction.Parameters, AFunction.ReturnValue, this_ptr, TSRMLS_DC);
                    variant2zval(AFunction.ReturnValue, return_value);
                end;
             Exit;
          end; //found function
      end; //functions.count

    end; //modules.count
end;

function TpsvCustomPHP.Execute(AFileName: string): string;
begin
  FFileName := AFileName;
  Result := Execute;
end;

procedure TpsvCustomPHP.PrepareResult(TSRMLS_D : pointer);
var
  ht  : PHashTable;
  data: ^ppzval;
  cnt : integer;
begin
  ht := GetSymbolsTable(TSRMLS_D);
  if Assigned(ht) then
   begin
     for cnt := 0 to FVariables.Count - 1  do
      begin
        new(data);
        try
          if zend_hash_find(ht, PChar(FVariables[cnt].Name),
          strlen(PChar(FVariables[cnt].Name)) + 1, data) = SUCCESS then
          case data^^^._type of
            IS_STRING : FVariables[cnt].Value := data^^^.value.str.val;
            IS_LONG,
            IS_RESOURCE,
            IS_BOOL   : FVariables[cnt].Value := IntToStr(data^^^.value.lval);
            IS_DOUBLE : FVariables[cnt].Value := FloatToStr(data^^^.value.dval);
          end;
        finally
          freemem(data);
        end;
      end;
   end;
end;

{ TPHPConstants }

function TPHPConstants.Add: TPHPConstant;
begin
  result := TPHPConstant(inherited Add);
end;

constructor TPHPConstants.Create(AOwner: TComponent);
begin
 inherited create(TPHPConstant);
 FOwner := AOwner;
end;

function TPHPConstants.GetItem(Index: Integer): TPHPConstant;
begin
  Result := TPHPConstant(inherited GetItem(Index));
end;

function TPHPConstants.GetOwner: TPersistent;
begin
  Result := FOwner;
end;

function TPHPConstants.IndexOf(AName: string): integer;
var
 i : integer;
begin
 Result := -1;
 for i := 0 to Count - 1 do
  begin
    if SameText(Items[i].Name, AName) then
     begin
       Result := i;
       break;
     end;
  end;
end;

procedure TPHPConstants.SetItem(Index: Integer; const Value: TPHPConstant);
begin
  inherited SetItem(Index, Value)
end;

{ TPHPVariable }

function TPHPVariable.GetDisplayName: string;
begin
  if FName = '' then
   result := inherited GetDisplayName
    else
      Result := FName;
end;

{ TPHPConstant }

function TPHPConstant.GetDisplayName: string;
begin
  if FName = '' then
   result := inherited GetDisplayName
    else
      Result := FName;
end;


end.
