/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.Selector;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.util.DOMUtil;
import org.w3c.dom.Element;

class XSDAbstractIDConstraintTraverser
extends XSDAbstractTraverser {
    public XSDAbstractIDConstraintTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    void traverseIdentityConstraint(IdentityConstraint ic, Element icElem, XSDocumentInfo schemaDoc, Object[] icElemAttrs) {
        String sText;
        Element selChild;
        Element sElem = DOMUtil.getFirstChildElement(icElem);
        if (sElem == null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{"identity constraint", "(annotation?, selector, field+)"});
            return;
        }
        if (DOMUtil.getLocalName(sElem).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(sElem, icElemAttrs, false, schemaDoc);
            sElem = DOMUtil.getNextSiblingElement(sElem);
        }
        if (sElem == null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{"identity constraint", "(annotation?, selector, field+)"});
            return;
        }
        Object[] attrValues = this.fAttrChecker.checkAttributes(sElem, false, schemaDoc);
        if (!DOMUtil.getLocalName(sElem).equals(SchemaSymbols.ELT_SELECTOR)) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{"identity constraint", "(annotation?, selector, field+)"});
        }
        if ((selChild = DOMUtil.getFirstChildElement(sElem)) != null) {
            if (DOMUtil.getLocalName(selChild).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(selChild, attrValues, false, schemaDoc);
                selChild = DOMUtil.getNextSiblingElement(selChild);
            } else {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{"identity constraint", "(annotation?, selector, field+)"});
            }
            if (selChild != null) {
                this.reportSchemaError("src-identity-constraint.1", new Object[]{icElemAttrs[XSAttributeChecker.ATTIDX_NAME]});
            }
        }
        if ((sText = (String)attrValues[XSAttributeChecker.ATTIDX_XPATH]) == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_SELECTOR, SchemaSymbols.ATT_XPATH});
            return;
        }
        sText = sText.trim();
        Selector.XPath sXpath = null;
        try {
            sXpath = new Selector.XPath(sText, this.fSymbolTable, schemaDoc.fNamespaceSupport);
            Selector selector = new Selector(sXpath, ic);
            ic.setSelector(selector);
        }
        catch (XPathException e) {
            this.reportSchemaError("c-selector-xpath", new Object[]{sText, e.getLocalizedMessage()});
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return;
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        Element fElem = DOMUtil.getNextSiblingElement(sElem);
        if (fElem == null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{"identity constraint", "(annotation?, selector, field+)"});
        }
        while (fElem != null) {
            String fText;
            Element fieldChild;
            attrValues = this.fAttrChecker.checkAttributes(fElem, false, schemaDoc);
            if (!DOMUtil.getLocalName(fElem).equals(SchemaSymbols.ELT_FIELD)) {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{"identity constraint", "(annotation?, selector, field+)"});
            }
            if ((fieldChild = DOMUtil.getFirstChildElement(fElem)) != null && DOMUtil.getLocalName(fieldChild).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(fieldChild, attrValues, false, schemaDoc);
                fieldChild = DOMUtil.getNextSiblingElement(fieldChild);
            }
            if (fieldChild != null) {
                this.reportSchemaError("src-identity-constraint.1", new Object[]{icElemAttrs[XSAttributeChecker.ATTIDX_NAME]});
            }
            if ((fText = (String)attrValues[XSAttributeChecker.ATTIDX_XPATH]) == null) {
                this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_FIELD, SchemaSymbols.ATT_XPATH});
                return;
            }
            fText = fText.trim();
            try {
                Field.XPath fXpath = new Field.XPath(fText, this.fSymbolTable, schemaDoc.fNamespaceSupport);
                Field field = new Field(fXpath, ic);
                ic.addField(field);
            }
            catch (XPathException e) {
                this.reportSchemaError("c-fields-xpaths", new Object[]{fText, e.getLocalizedMessage()});
                this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
                return;
            }
            fElem = DOMUtil.getNextSiblingElement(fElem);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        }
    }
}

