// W97DuPlx.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "W97DuPlx.h"

BOOL APIENTRY DllMain( HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
    return TRUE;
}

// Constructor For Class
CDuplexing::CDuplexing()
{
	Init();
	return;
}

int CDuplexing::DuplexMode(LPTSTR m_PrinterName, int m_DuplexMode)
{
	static HANDLE m_PrinterHandle = NULL;
	
	// The m_PrinterName variable should be sourced from:
	// HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Print\Printer\[PrinterName]\Name
	m_RetValue = OpenPrinter(m_PrinterName,&m_PrinterHandle,&m_PrinterDefaults);
	if (m_RetValue)
	{
		// Success
		// The Next Call To GetPrinter will fail because the buffer is 0. Due to the Structure we
		// need being a PRINTER_INFO_2, which is variable size we can't just sizeof the Structure
		// so we need to make the call, get it to fail and by default it will return the size it requires
		// for the buffer.
		GetPrinter(m_PrinterHandle,2,(BYTE*)&m_PrinterStructure,m_BufferSize,&m_PrinterSize);
		// At this pointer m_PrinterSize contains the required buffer size;
		m_BufferSize = m_PrinterSize;
		// Make the call again with the correct values
		m_RetValue = GetPrinter(m_PrinterHandle,2,(BYTE*)&m_PrinterStructure,m_BufferSize,&m_PrinterSize);
		if (m_RetValue)
		{
			// Success
			// The m_PrinterStructure contains all the information we require about the printer we can now
			// update the m_PrinterStructure.pDevMode->dmDuplex member to the value passed in m_DuplexMode
			// if an invalid value is passed default the dmDuplex value to DMDUP_SIMPLEX (No Duplex)
			switch (m_DuplexMode)
			{
			case 1:
				{
					// No Duplex
					m_PrinterStructure.pDevMode->dmDuplex = DMDUP_SIMPLEX;
					break;
				}
			case 2:
				{
					// Horizontal (Long Page) Duplex
					m_PrinterStructure.pDevMode->dmDuplex = DMDUP_HORIZONTAL;
					break;
				}
			case 3:
				{
					// Vertical (Facing Page) Duplex
					m_PrinterStructure.pDevMode->dmDuplex = DMDUP_VERTICAL;
					break;
				}
			default:
				{
					// Turn off Duplex when value is not 1,2 or 3
					m_PrinterStructure.pDevMode->dmDuplex = DMDUP_SIMPLEX;
					break;
				}
			}
			// We can now call SetPrinter and update the Printers Duplex Mode						
			m_RetValue = SetPrinter(m_PrinterHandle,2,(BYTE*)&m_PrinterStructure,0);
			if (!m_RetValue)
			{
				// Failed - Close handle and return Error Code
				ClosePrinter(m_PrinterHandle);
				return GetLastError();
			}
		}
		else
		{
			// Failed GetPrinter
			ClosePrinter(m_PrinterHandle);
			return GetLastError();
		}
	}
	else
	{
		// Failed Open Printer		
		return GetLastError();
	}
	
	ClosePrinter(m_PrinterHandle);
	return 0; // Success
}

void CDuplexing::Init()
{
	// This is the most efficient manner in which to make asignments
	// Due to the way the Contructor works !!! - See Effective C++, Chapter 2E, Item 12	
	m_PrinterSize = 0;
	m_BufferSize = 0;

	// Define the Global Setup For the m_PrinterDefaults Structure.
	m_PrinterDefaults.pDevMode = NULL;
	m_PrinterDefaults.pDatatype = NULL;
	m_PrinterDefaults.DesiredAccess = PRINTER_ALL_ACCESS;
}

W97DUPLX_API int _stdcall SetDuplexMode(LPTSTR m_PrinterName,int m_DuplexMode)
{
	CDuplexing *CMyClass;
	CMyClass = new CDuplexing;	    

	return (CMyClass->DuplexMode(m_PrinterName,m_DuplexMode));		
}
