/********************************************************************
* Structures and definitions to use with XPort Driver				*
* Only 2 functions are exported:									*
*	UCHAR ReadPort (ULONG PortAddress)								*
*	void WritePort (ULONG PortAddress , UCHAR PortValue )			*
********************************************************************/				
#include <winioctl.h>

	// Port Data Structure
	typedef struct PortData
	{
		ULONG PortAddress;
		UCHAR PortValue;
	} PORTDATA, *PPORTDATA;


	// Device control codes - values between 2048 and 4095 arbitrarily chosen
	// by ME
	#define XPORT_DEVICE 0xCF53
	#define IOCTL_XPORT_WRITE	CTL_CODE(XPORT_DEVICE, 2049, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define IOCTL_XPORT_READ	CTL_CODE(XPORT_DEVICE, 2050, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define IOCTL_XPORT_VERSION	CTL_CODE(XPORT_DEVICE, 2051, METHOD_BUFFERED, FILE_ANY_ACCESS)


	// Function protos
	void PortComm( DWORD IOCTL, PPORTDATA InBuffer, UCHAR* OutBuffer,ULONG* ReturnedLength ) ;
	void WritePort( ULONG Address, UCHAR Value) ;
	UCHAR ReadPort( ULONG Address) ;

HANDLE		DriverHandle = INVALID_HANDLE_VALUE;   // Handle to device, obtained from CreateFile

//===========================================================================

//////////////////////////////////////////////////
// XPort driver communication module
//////////////////////////////////////////////////

void PortComm( DWORD IOCTL, PPORTDATA InBuffer, UCHAR* OutBuffer,ULONG* ReturnedLength ) 
{
	

   if (DriverHandle == INVALID_HANDLE_VALUE)        // Was the device opened?
	{
     DriverHandle = CreateFile(
				"\\\\.\\XPort",
				0, 
				0,
				NULL, 
				OPEN_EXISTING,
		 		FILE_ATTRIBUTE_NORMAL,
				NULL 
				);
		if (DriverHandle == INVALID_HANDLE_VALUE)        // Was the device opened NOW?
		{
				AfxMessageBox ("DEVICE NOT FOUND", MB_OK | MB_ICONERROR);
				CloseHandle( DriverHandle );
				return;
		}
             
    }
	



	if (!DeviceIoControl(DriverHandle,
                         IOCTL,
                         InBuffer,				// Ptr to InBuffer
                         sizeof(PORTDATA),      // Length of InBuffer
                         OutBuffer,				// Ptr to OutBuffer
                         sizeof(UCHAR),			// Length of OutBuffer
                         (ULONG*)ReturnedLength,		// BytesReturned
                         0) )					// Ptr to Overlapped structure
			{	
				AfxMessageBox ("IOCTL ERROR", MB_OK | MB_ICONERROR);
				CloseHandle( DriverHandle );
				return;
            }


	// Keep Handle open for faster IOCTL communication
	// Close it at the end of this application
	// This means that only one single application can use this handle to the
	// Driver Device Object
//	CloseHandle( DriverHandle );
	return;

}

//===========================================================================

void WritePort( ULONG Address, UCHAR Value) 
{
	PORTDATA	PData;
	ULONG		ReturnedLength;			// Number of bytes returned
	UCHAR		ReadData;

		PData.PortValue = Value;
		PData.PortAddress = Address;
		PortComm ((DWORD)IOCTL_XPORT_WRITE, &PData, &ReadData, &ReturnedLength);
}

//===========================================================================

UCHAR ReadPort( ULONG Address) 
{
	PORTDATA	PData;
	ULONG		ReturnedLength;			// Number of bytes returned
	UCHAR		ReadData;

		PData.PortAddress = Address;
		PortComm ((DWORD)IOCTL_XPORT_READ, &PData, &ReadData, &ReturnedLength);
		if (!ReturnedLength)
		{
				AfxMessageBox ("No Data Returned", MB_OK | MB_ICONERROR);
			return 0;
		}
		return ReadData ;

}

//===========================================================================
