#!/usr/bin/perl
# Quick Website News
# Licensed Under the GNU General Public License (see COPYING File)
#
# You are welcome to modify and improve this program as long as any
# improvements are added to the public code base. I would be more than
# pleased to recieve improvements, comment and suggestions by email at qwn@tildemh.com.
# The latest version of these scripts will always be available from my website
# http://www.tildemh.com
#
#                     Copyright (c) 2001 by Mark Howard
#
#       This program is free software; you can redistribute it and/or
#       modify it under the terms of the GNU General Public License as
#       published by the Free Software Foundation; either version 2 of
#       the License, or (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program in the file 'COPYING'; if not, write to
#       the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#       Boston, MA 02111-1307, USA, or contact the author:
#
# QWN
#
# edit.cgi - for editing a specific news item from the time stamp (= Key Field.)

use qwnui;
use config;
use htmlgen;
use encode;
require 'cgi-lib1.pl';
&ReadParse(*input);


print "Content-Type: text\/html\n\n";
print <<END;
<html>
<head>
<title>QWN - Edit News item</title>
<link href="style.css" typ=text/css rel=stylesheet>
</head>
<body>
END

qwnui::qwnheader;

#print "<h1>Edit News Item</h1>";


# get $timestamp from the query.
$input =~ s/&timestamp=//;
# print "<p>$input";
chomp($input);
$timestamp=$input;

open(NEWS,"config/$session::newsdb");
@news=<NEWS>;
close(NEWS);

$found==0;
foreach $entry(@news){
        $test= ($entry =~ /$timestamp/);
#        print "T:$test <br>";
        if ($test<=0){ next; }
        else{   # print "$entry";
                $found=1;
                $line=$entry;
                break;
        }
}
if ($found==0){ print "<p>Error: news item not found with timestamp $timestamp. Cannot edit news.";}
else{   # Found the item. Now do some work with it.
        # print "<p>Line: $line";
        $line=&encode::unencode($line);
        @data=split(/#/,$line);
        #print "<p>Time: @data[0]";
        #print "<p>Author: @data[1]";
        #print "<p>Title: @data[2]";
        #print "<p>Content: @data[3]";

        print "<form action=\"view.cgi\" method=\"post\">";
        print "<table width=100% border=0>";
        print "<tr><td rowspan=7 width=10%>&nbsp;<td colspan=2 width=80%>";
        print "<br><h2 align=center>Edit News Item</h2> <br>";
        print "<td rowspan=7 width=10%>&nbsp;";
        print "<tr><td><p align=right>Project:<td>$session::projname";
        $date=&htmlgen::formattime("dd/mm/yyyy hh:nn","@data[0]");
        print "<tr><td><p align=right>Date: <td>$date<input type=hidden name=\"time\" value=\"@data[0]\">";
        print "<tr><td><p align=right>Author: <td><input type=text name=\"author\" value=\"@data[1]\" size=30>";
        print "<tr><td><p align=right>Title: <td><input type=text name=\"title\" value=\"@data[2]\" size=80>";
        print "<tr><td><p align=right>Content:<td><textarea rows=5 cols=80 name=\"content\">@data[3]</textarea>";
        print "<tr><td colspan=2> <p align=center><input type=\"submit\" value=\"Save Changes\">";
        print "</table>";
        print "</form>";

}

print <<END;
</body>
</html>
END

&config::savesess;
