/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.Applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import uk.co.visualisationsystems.QuickFire.Applet.QuickFireAppletRuntime;
import uk.co.visualisationsystems.QuickFire.Applet.QuickFireCanvas;
import uk.co.visualisationsystems.QuickFire.Applet.QuickFireIO;
import uk.co.visualisationsystems.QuickFire.Applet.QuickFireThread;
import uk.co.visualisationsystems.QuickFire.Applet.RemoteIO;
import uk.co.visualisationsystems.QuickFire.Applet.VirtualDiskIO;
import uk.co.visualisationsystems.QuickFire.ImageProducer.QuickFireImageProducer;
import uk.co.visualisationsystems.QuickFire.ImageProducer.QuickFireImageProducerException;
import uk.co.visualisationsystems.QuickFire.Runtime.JvmBase;
import uk.co.visualisationsystems.QuickFire.VirtualDisk.VirtualDisk;

public class QuickFireApplet
extends Applet {
    private int MajorVersion = 2;
    private int MinorVersion = 0;
    private int BugFixVersion = 0;
    private VirtualDisk virtualDisk = null;
    private String virtualDiskFileName = null;
    private String quickFireVirtualDiskPoster = null;
    protected QuickFireIO quickFireIO = null;
    protected Thread thread = null;
    protected QuickFireAppletRuntime runtime;
    private int appletWidth;
    private int appletHeight;
    private Image textImage;
    private Graphics textGc;
    private QuickFireImageProducer quickFireImageProducer;
    private int maxSprites;
    protected QuickFireCanvas quickFireCanvas;

    public boolean isUsingVirtualDisk() {
        return this.virtualDisk != null;
    }

    public String Version() {
        return "" + this.MajorVersion + "." + this.MinorVersion + "." + this.BugFixVersion;
    }

    protected QuickFireIO CreateQuickFireIO() {
        Object object;
        String string;
        QuickFireIO quickFireIO = null;
        if (quickFireIO == null) {
            try {
                string = this.getParameter("QuickFireVirtualDisk");
                this.quickFireVirtualDiskPoster = this.getParameter("QuickFireVirtualDiskPoster");
                if (string != null) {
                    this.virtualDiskFileName = this.GetFilename(string);
                    object = this.LoadObject(string);
                    if (object instanceof VirtualDisk) {
                        this.virtualDisk = (VirtualDisk)object;
                        quickFireIO = new VirtualDiskIO(this.virtualDisk);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (quickFireIO == null) {
            try {
                string = this.getParameter("sessionVariable");
                object = this.getParameter("sessionValue");
                if (string != null && object != null) {
                    URL uRL = this.getCodeBase();
                    String string2 = uRL.getProtocol();
                    String string3 = uRL.getHost();
                    int n = uRL.getPort();
                    quickFireIO = new RemoteIO(this, string2, string3, n, string, (String)object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return quickFireIO;
    }

    public void init() {
        this.quickFireIO = this.CreateQuickFireIO();
        if (this.quickFireIO == null) {
            this.quickFireIO = new VirtualDiskIO(new VirtualDisk());
        }
        this.CreateComponents();
    }

    protected void CreateComponents() {
        Dimension dimension = this.size();
        this.appletWidth = dimension.width;
        this.appletHeight = dimension.height;
        int n = 64;
        this.CreateCanvas(this.appletWidth, this.appletHeight, n);
        this.setLayout(new BorderLayout());
        this.add((Component)this.quickFireCanvas, "Center");
        this.textImage = this.createImage(this.appletWidth, 50);
        this.textGc = this.textImage.getGraphics();
        this.validate();
    }

    public void addNotify() {
        super.addNotify();
    }

    public void start() {
        this.StartProgram(null);
    }

    public boolean SaveVirtualDisk() {
        boolean bl = false;
        if (this.virtualDisk != null && this.quickFireVirtualDiskPoster != null && this.virtualDiskFileName != null) {
            bl = this.virtualDisk.PostVirtualDisk(this.quickFireVirtualDiskPoster, this.virtualDiskFileName);
        }
        return bl;
    }

    public void stop() {
        this.SaveVirtualDisk();
    }

    public void destroy() {
        if (this.quickFireImageProducer != null) {
            this.quickFireImageProducer.Halt();
            this.quickFireImageProducer = null;
        }
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    public QuickFireCanvas CreateCanvas(int n, int n2, int n3) {
        this.quickFireImageProducer = new QuickFireImageProducer(n, n2, n3);
        this.maxSprites = n3;
        this.quickFireCanvas = new QuickFireCanvas(n, n2, this.quickFireImageProducer);
        return this.quickFireCanvas;
    }

    public final boolean isRunning() {
        return this.thread != null;
    }

    public void PreStartInit(QuickFireAppletRuntime quickFireAppletRuntime) {
        if (this.quickFireImageProducer != null) {
            try {
                int n = this.quickFireImageProducer.DisplayWidth();
                int n2 = this.quickFireImageProducer.DisplayHeight();
                int n3 = 0;
                while (n3 <= this.maxSprites) {
                    this.quickFireImageProducer.SpriteDestroy(n3);
                    ++n3;
                }
                this.quickFireImageProducer.SpriteCreate(0, 1, n, n2);
                this.quickFireImageProducer.SpriteSetColour(0, Integer.MIN_VALUE);
                this.quickFireImageProducer.SpriteFillArea(0, 0, 0, n - 1, n2 - 1);
                this.quickFireImageProducer.SpriteMove(0, 0, 0);
                this.quickFireImageProducer.ProductionRate(40);
                this.quickFireImageProducer.ProductionEnabled(true);
            }
            catch (QuickFireImageProducerException quickFireImageProducerException) {
                // empty catch block
            }
        }
        if (this.quickFireCanvas != null) {
            this.quickFireCanvas.PreStartInit();
        }
        this.runtime = quickFireAppletRuntime == null ? new QuickFireAppletRuntime() : quickFireAppletRuntime;
        this.runtime.applet = this;
        this.runtime.quickFireCanvas = this.quickFireCanvas;
        this.runtime.quickFireImageProducer = this.quickFireImageProducer;
        this.runtime.quickFireIO = this.quickFireIO;
        this.runtime.textImage = this.textImage;
        this.runtime.textGc = this.textGc;
    }

    public void StartProgram(JvmBase jvmBase) {
        this.PreStartInit(null);
        if (jvmBase == null) {
            try {
                String string = this.getParameter("QuickFireClass");
                if (string != null) {
                    try {
                        Class<?> clazz = Class.forName(string);
                        jvmBase = (JvmBase)clazz.newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.out.println("ClassNotFoundException: " + classNotFoundException.getMessage());
                    }
                    catch (InstantiationException instantiationException) {
                        System.out.println("InstantiationException: " + instantiationException.getMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.out.println("IllegalAccessException: " + illegalAccessException.getMessage());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (jvmBase != null) {
            this.thread = new QuickFireThread("QuickFireThread", jvmBase, this.runtime, this);
            this.thread.start();
        }
    }

    public void StopProgram() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    public void ProgramStarting() {
    }

    public void ProgramFinished() {
        if (this.thread != null) {
            this.thread = null;
        }
        if (this.quickFireImageProducer != null) {
            this.quickFireImageProducer.ProductionRate(40);
            this.quickFireImageProducer.ProductionEnabled(false);
            this.quickFireImageProducer.Refresh(false);
        } else {
            System.out.println("QuickFireApplet.ProgramFinished() - quickFireImageProducer was null");
        }
        if (this.runtime != null) {
            this.runtime.AudioStopAll();
        } else {
            System.out.println("QuickFireApplet.ProgramFinished() - runtime was null");
        }
    }

    String GetFilename(String string) {
        String string2 = null;
        try {
            URL uRL = new URL(string);
            string2 = uRL.getFile();
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("MalformedURLException: " + malformedURLException.getMessage());
        }
        return string2;
    }

    Object LoadObject(String string) {
        Object object = null;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(false);
            InputStream inputStream = uRLConnection.getInputStream();
            if (inputStream != null) {
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                if (objectInputStream != null) {
                    object = objectInputStream.readObject();
                }
                inputStream.close();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException: " + classNotFoundException.getMessage());
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("MalformedURLException: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
        }
        return object;
    }
}

