/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.LicenseManager;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import uk.co.visualisationsystems.QuickFire.ByteCode.ByteArrayClassLoader;
import uk.co.visualisationsystems.QuickFire.LicenseManager.AbstractLicense;

public class LicenseManager {
    private static String propertiesFilename;
    private static Properties properties;
    private static AbstractLicense license;

    static void loadProperties() {
        try {
            FileInputStream fileInputStream = new FileInputStream(propertiesFilename);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("FileNotFoundException: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
        }
    }

    static void saveProperties() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(propertiesFilename);
            properties.save(fileOutputStream, "QuickFire Properties");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("FileNotFoundException: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
        }
    }

    public static void loadLicense(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            int n = fileInputStream.available();
            if (n > 0) {
                byte[] byArray = new byte[n];
                fileInputStream.read(byArray);
                ByteArrayClassLoader byteArrayClassLoader = new ByteArrayClassLoader();
                byteArrayClassLoader.addByteArrayClass("QuickFireLicense", byArray);
                try {
                    Class<?> clazz = byteArrayClassLoader.loadClass("QuickFireLicense");
                    license = (AbstractLicense)clazz.newInstance();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    System.out.println("NoClassDefFoundError: " + noClassDefFoundError.getMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("ClassNotFoundException: " + classNotFoundException.getMessage());
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("InstantiationException: " + instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("IllegalAccessException: " + illegalAccessException.getMessage());
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("FileNotFoundException: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
        }
    }

    private static char IndexToChar(int n) {
        char c = n < 10 ? (char)(48 + n) : (n < 36 ? (char)(65 + n - 10) : (char)'\uffff');
        return c;
    }

    private static int CharToIndex(char c) {
        int n = c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'Z' ? c - 65 + 10 : -1);
        return n;
    }

    public static String Encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            int n3 = c >> 4 & 0xF;
            int n4 = (n + n3) % 36;
            stringBuffer.append(LicenseManager.IndexToChar(n4));
            n = n4;
            n3 = c & 0xF;
            n4 = (n + n3) % 36;
            stringBuffer.append(LicenseManager.IndexToChar(n4));
            n = n4;
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String Decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3;
            char c = string.charAt(n2);
            int n4 = n3 = LicenseManager.CharToIndex(c);
            if ((n3 -= n) < 0) {
                n3 += 36;
            }
            int n5 = n3 << 4;
            n = n4;
            c = string.charAt(n2 + 1);
            n4 = n3 = LicenseManager.CharToIndex(c);
            if ((n3 -= n) < 0) {
                n3 += 36;
            }
            n = n4;
            stringBuffer.append((char)(n5 |= n3));
            n2 += 2;
        }
        return stringBuffer.toString();
    }

    public static void setLicenseFile(String string) {
        if (string != null) {
            LicenseManager.loadLicense(string);
            if (license != null) {
                properties.setProperty("licenseFile", string);
                LicenseManager.saveProperties();
            }
        }
    }

    public static boolean licenseInstalled() {
        return license != null;
    }

    public static boolean isLicensed() {
        long l;
        boolean bl = false;
        if (license != null && ((l = license.getExpiryTime()) == Long.MAX_VALUE || l > System.currentTimeMillis())) {
            bl = true;
        }
        return bl;
    }

    public static long getCustomerID() {
        return license.getCustomerID();
    }

    public static long getIssueTime() {
        return license.getIssueTime();
    }

    public static long getExpiryTime() {
        return license.getExpiryTime();
    }

    public static long getMajorVersion() {
        return license.getMajorVersion();
    }

    public static long getMinorVersion() {
        return license.getMinorVersion();
    }

    public static String getName() {
        return LicenseManager.Decode(license.getName());
    }

    public static String getEMail() {
        return LicenseManager.Decode(license.getEMail());
    }

    static {
        properties = new Properties();
        try {
            String string = System.getProperty("user.home");
            String string2 = System.getProperty("file.separator");
            propertiesFilename = string + string2 + "QuickFire.properties";
            LicenseManager.loadProperties();
            String string3 = properties.getProperty("licenseFile");
            if (string3 != null) {
                LicenseManager.loadLicense(string3);
            }
        }
        catch (SecurityException securityException) {
            license = null;
        }
    }
}

