/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.Editor;

import uk.co.visualisationsystems.QuickFire.Applet.QuickFireApplet;
import uk.co.visualisationsystems.QuickFire.Applet.QuickFireAppletRuntime;
import uk.co.visualisationsystems.QuickFire.ByteCode.ByteArrayClassLoader;
import uk.co.visualisationsystems.QuickFire.Compiler.Backend;
import uk.co.visualisationsystems.QuickFire.Compiler.InterpreterBackend;
import uk.co.visualisationsystems.QuickFire.Compiler.QuickFireRuntimeError;
import uk.co.visualisationsystems.QuickFire.Editor.EditorPanel;
import uk.co.visualisationsystems.QuickFire.Editor.InterpreterThread;
import uk.co.visualisationsystems.QuickFire.Runtime.JvmBase;

public class InterpreterApplet
extends QuickFireApplet {
    EditorPanel editorPanel;

    InterpreterApplet() {
        this.editorPanel = null;
    }

    InterpreterApplet(EditorPanel editorPanel) {
        this.editorPanel = editorPanel;
    }

    public void StartProgram(String string, Backend backend, QuickFireAppletRuntime quickFireAppletRuntime) {
        this.PreStartInit(quickFireAppletRuntime);
        if (backend != null) {
            byte[] byArray = backend.getClassAsByteArray();
            if (byArray == null) {
                if (backend instanceof InterpreterBackend) {
                    this.thread = new InterpreterThread("QuickFireThread", backend, quickFireAppletRuntime, this);
                    this.thread.setPriority(3);
                    this.thread.start();
                } else {
                    String string2 = "InterpreterApplet.StartProgram() Invalid backend, failed to start program";
                    quickFireAppletRuntime.print(string2);
                }
            } else {
                ByteArrayClassLoader byteArrayClassLoader = new ByteArrayClassLoader();
                byteArrayClassLoader.addByteArrayClass(string, byArray);
                try {
                    Class<?> clazz = byteArrayClassLoader.loadClass(string);
                    JvmBase jvmBase = (JvmBase)clazz.newInstance();
                    this.StartProgram(jvmBase);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String string3 = "InterpreterApplet.StartProgram() ClassNotFoundException: " + classNotFoundException.getMessage();
                    quickFireAppletRuntime.print(string3);
                }
                catch (InstantiationException instantiationException) {
                    String string4 = "InterpreterApplet.StartProgram() InstantiationException: " + instantiationException.getMessage();
                    quickFireAppletRuntime.print(string4);
                }
                catch (IllegalAccessException illegalAccessException) {
                    String string5 = "InterpreterApplet.StartProgram() IllegalAccessException: " + illegalAccessException.getMessage();
                    quickFireAppletRuntime.print(string5);
                }
            }
        }
    }

    public void ProgramFinished() {
        super.ProgramFinished();
        if (this.editorPanel != null) {
            this.editorPanel.ProgramFinished();
        }
    }

    public void RuntimeError(QuickFireRuntimeError quickFireRuntimeError) {
    }
}

