/*
 * Decompiled with CFR 0.152.
 */
package Sav.Z;

import Sav.Processor.DataList;
import Sav.Processor.Long1;
import Sav.Processor.Memory;
import Sav.TParser.Fielder;
import Sav.Z.Error;
import Sav.Z.Failure;
import Sav.Z.Lexis;
import Sav.Z.Session;
import Sav.Z.Statement;
import Sav.Z.ZException;
import java.io.IOException;

public class Script
implements Lexis {
    Session ss;
    DataList stmList;
    String text;
    boolean hasError;
    boolean hasFailure;
    boolean isAnalyzed;
    boolean dbModify;
    boolean modify;
    int modifyCount;

    public Script(String string) {
        this.text = string;
        this.stmList = new DataList();
    }

    synchronized void analyse(Session session) {
        int n2;
        int n3;
        this.ss = session;
        session.scr_modify = session.db.isModifiable();
        if (!session.hideScriptStatus()) {
            StringBuffer stringBuffer = new StringBuffer("SCRIPT: ");
            n3 = this.text.indexOf(10);
            if (n3 < 0) {
                n3 = this.text.length() > 69 ? 69 : this.text.length();
            }
            stringBuffer.append(this.text.substring(0, n3));
            if (n3 < this.text.length()) {
                stringBuffer.append("...");
            }
            session.setProcess(stringBuffer.toString());
            session.setProcess("Analyzing script...");
        }
        this.stmList = new DataList();
        this.hasError = false;
        int n4 = this.text.length();
        n3 = 0;
        int n5 = n2 = session.getScriptLine();
        if (!session.hideScriptStatus()) {
            session.setScriptLine(++n5);
        }
        this.modifyCount = 0;
        this.modify = false;
        boolean bl2 = true;
        try {
            int n6 = Fielder.passSpace(this.text, n3, n4);
            while (true) {
                if (n3 < n6) {
                    if (this.text.charAt(n3) == '\n') {
                        ++n5;
                    }
                    ++n3;
                    continue;
                }
                if (!session.hideScriptStatus()) {
                    session.setScriptLine(n5);
                }
                if (n3 != n4) {
                    Statement statement = new Statement(n5, this.text, n3);
                    statement.scr = this;
                    this.stmList.add(statement);
                    statement.analyse(session);
                    this.hasError |= statement.hasErrors();
                    if (statement.modify && this.modifyCount == 0) {
                        this.modify = true;
                    }
                    n6 = statement.end();
                    n6 = Fielder.passSpace(this.text, n6, n4);
                    continue;
                }
                break;
            }
        }
        catch (ZException zException) {
            this.hasError = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.hasError = true;
            new Error(session, exception, n5, n3);
        }
        if (!session.hideScriptStatus()) {
            session.clearScriptLine();
            session.setScriptLine(n2);
            session.clearProcess();
        }
        this.isAnalyzed = true;
    }

    boolean isAnalyzed(Session session) {
        return this.isAnalyzed && this.ss == session && (!this.modify || this.dbModify == session.db.isModifiable());
    }

    synchronized void execute(Session session) {
        int n2;
        this.hasFailure = false;
        Statement statement = null;
        Statement statement2 = null;
        if (!this.isAnalyzed(session)) {
            this.analyse(session);
        }
        if (!this.hasStatements()) {
            return;
        }
        if (this.hasErrors()) {
            return;
        }
        int n3 = n2 = session.getScriptLine();
        if (!session.hideScriptStatus()) {
            session.setScriptLine(++n3);
        }
        Object var6_6 = null;
        try {
            if (!session.hideScriptStatus()) {
                session.setProcess("Executing script...");
            }
            Long1 long1 = Memory.init();
            statement = statement2 = (Statement)this.stmList.getFirst();
            while (statement != null && !session.comm.isOff()) {
                n3 = statement.getLineNumber();
                if (!session.hideScriptStatus()) {
                    session.setScriptLine(n3);
                }
                statement.execute(session);
                this.hasFailure |= statement.hasFailures();
                Memory.control(long1, session.db.base);
                statement = (Statement)this.stmList.getNext();
            }
        }
        catch (ZException zException) {
            this.hasFailure = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.hasFailure = true;
            new Failure(session, exception, n3, statement.expressBegin());
        }
        try {
            session.dbh.closeExecuted();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.hasFailure = true;
            new Failure(session, iOException, n2, statement2.expressBegin());
        }
        if (!session.hideScriptStatus()) {
            session.clearScriptLine();
            session.setScriptLine(n2);
            session.clearProcess();
        }
    }

    public String getText() {
        return this.text;
    }

    public Statement[] statements() {
        if (!this.isAnalyzed) {
            return null;
        }
        int n2 = this.stmList.size();
        Statement[] statementArray = new Statement[n2];
        Statement statement = (Statement)this.stmList.getFirst();
        for (int i2 = 0; i2 < n2; ++i2) {
            statementArray[i2] = statement;
            statement = (Statement)this.stmList.getNext();
        }
        return statementArray;
    }

    public boolean hasStatements() {
        return !this.stmList.isEmpty();
    }

    public int countStatements() {
        return this.stmList.size();
    }

    public boolean hasWarnings() {
        return this.hasErrors() || this.hasFailures();
    }

    public boolean hasErrors() {
        return this.hasError;
    }

    public boolean hasFailures() {
        return this.hasFailure;
    }

    String correct() {
        if (!this.isAnalyzed) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Statement[] statementArray = this.statements();
        int n2 = statementArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Statement statement = statementArray[i2];
            String string = statement.rightExpression();
            stringBuffer.append(string);
            if (string.length() == 0) {
                stringBuffer.append("; <?>");
            } else if (statement.hasErrors()) {
                stringBuffer.append("; <!>");
            } else {
                stringBuffer.append(";");
            }
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }
}

