
###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################
namespace eval subscribe {
    set localFileName "theFiltr.tcl"
    set localTempName "theFiltr.new"
    set urlFrom ""
    set retryInterval 900000 ;# 15 minutes
    set refreshDays 7
}

proc subscribe::SetURL { url } {
    variable urlFrom
    set urlFrom $url
}

proc subscribe::GetURL { } {
    variable urlFrom
    set urlFrom
}

proc subscribe::GetRefreshDays { } {
    variable refreshDays
    set $refreshDays
}

proc subscribe::SetRefreshDays { nDays } {
    dbg::puts subscribe "nDays: $nDays"
    variable refreshDays
    variable eventId
    variable localFileName

    set refreshDays $nDays
    catch { after cancel $eventId }
    set secondsInDay [expr { 60 * 60 * 24}]
    if [ catch {
	set fileTime [file mtime $localFileName]
    } errMessage] {
	#this is odd. . .maybe there is no theFilter.tcl
	dbg::puts subscribe $errMessage
	DownloadFilterSoon
    } else {
	set delayInSeconds [expr { $refreshDays * $secondsInDay + $fileTime - \
		[clock seconds]}]

	# there's a bug in the tcl expr command, much will sometimes turn
	# large positive numbers into negative number if they fall into
	# some given range, which our numbers may.  To avoid this, and
	# stay below this dangerous range, for a duration > 1 day, just
	# call SetRefreshDays again in a day.

	if { $delayInSeconds <= 0 } {
	    DownloadFilterSoon
	} elseif { $delayInSeconds > $secondsInDay } {
	    set eventId [after $secondsInDay \
		    [list subscribe::SetRefreshDays $nDays]]
	} else {
	    dbg::puts subscribe "Downloading new filter in $delayInSeconds seconds."
	    set eventId [after [expr { $delayInSeconds * 1000 }] \
		    subscribe::DownloadFilterSoon]
	}
    }
}

proc subscribe::DownloadFilterSoon { } {
    variable eventId
    variable urlFrom
    dbg::puts subscribe "Downloading new filter now. . ."
    catch { after cancel $eventId }
    set eventId [after idle subscribe::DownloadFilter]
}

proc subscribe::MakeRequestHeader { } {
    variable urlFrom
    set lz [linezero::ParseRequestLine "GET $urlFrom HTTP/1.0"]
    set hdr [header::Make]
    header::SetLineZero hdr $lz
    header::AppendOption hdr Accept */*
    header::AppendOption hdr Host [linezero::GetHost lz]
    set hdr
}

proc subscribe::DownloadFilter { } {
    variable urlFrom
    variable localTempName
    variable eventId
    catch { after cancel $eventId }

    if [catch {
	dbg::puts subscribe "Downloading latest filter from $urlFrom"
	set tempHandle [open $localTempName w]
	chat::Request [MakeRequestHeader] $tempHandle \
		subscribe::DoneDownloadFilter {} -noheader
    } err] {
	dbg::puts subscribe "Error while trying to download filter: $err"
    }
}

proc subscribe::VerifyNewFilter { } {
    variable localTempName
    if [ catch { 
	set newHandle [open $localTempName r]
	set line1 [gets $newHandle]
	if { ![regexp \[0-9\]+ $line1 minSize] || \
		[file size $localTempName] != $minSize || \
		![regexp "theFilter\\.tcl" $line1] } {
	    close $newHandle
	    error "theFilter.tcl: invalid format"
	}
	close $newHandle
    } errMessage ] {
	dbg::puts subscribe $errMessage
	set result 0
    } else {
	set result 1
    }
}

proc subscribe::DoneDownloadFilter { tempHandle wasSockClosed } {
    variable eventId
    variable localFileName
    variable localTempName
    variable retryInterval
    catch { close $tempHandle }

    if [VerifyNewFilter] {
	file copy -force -- $localTempName $localFileName
	filter::LoadFilterTable $localFileName
    } else {
	#try again in 15 minutes
	catch { after cancel $eventId }
	set eventId [after $retryInterval subscribe::DownloadFilterSoon]
    }
}
    
    
    
    

###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################
