
###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################
###########################################################################
# setupns.tcl
# this file configures netscape to use our proxy server
###########################################################################

namespace eval setupns {
    set backupExists 0
    set bookmarkFile "bookmark.htm"
    set prefsFile "prefs.js"
    set bookmarkRoot key_users
    set bookmarkPath \
	    ".Default/Software/Netscape/Netscape Navigator/Bookmark List"
    set regRoot key_users
    set regPath \
	    ".Default/Software/Netscape/Netscape Navigator/Proxy Information"
    set backupRoot key_users
    set backupPath ".Default/Software/WebSmacker/Netscape/BackupRegistry"
    set backupValues [list "Proxy Type" "No_Proxy" "HTTP_Proxy" \
	    "Http_ProxyPort"]
    set backupExtension ".old"
    set bookmark {    <DT><A HREF="http://configurewebsmacker/" ADD_DATE="908762800" LAST_VISIT="908753240" LAST_MODIFIED="908753240">Web Smacker: Loading configuration. . .</A>
</DL><p>
}

}

proc setupns::UninstallRegistry { } {
    global registryDllLoaded
    if { ![info exists registryDllLoaded] } {
	load registry.dll
	set registryDllLoaded 1
    }
    variable regPath
    variable backupPath
    variable regRoot
    variable backupRoot
    variable backupValues

    if ![catch { set k [reg_openkey $backupRoot $backupPath] } ] {
	# the key exists so let's uninstall
	if [catch { 
	    set kSource [reg_openkey $backupRoot $backupPath -create 1 \
		    -access read]
	    set k [reg_openkey $regRoot $regPath -access write]
	    foreach valuename $backupValues {
		set val [reg_getvalue $kSource $valuename]
		reg_setvalue $k $valuename [lindex $val 0] [lindex $val 1]
	    }
	    reg_closekey $k
	    reg_closekey $kSource
	} err ] {
	    catch { reg_closekey $k }
	    catch { reg_closekey $kSource }
	    dbg::puts setup "Could not uninstall registry: $err"
	}
    } else {
	catch { reg_closekey $k }
    }
}
    

proc setupns::BackupRegistry { } {
    global registryDllLoaded
    if { ![info exists registryDllLoaded] } {
	load registry.dll
	set registryDllLoaded 1
    }
    variable regPath
    variable backupPath
    variable regRoot
    variable backupRoot
    variable backupValues

    if [catch { set k [reg_openkey $backupRoot $backupPath] } ] {
	# the key doesn't exist yet so we need to backup
	if [catch { 
	    set k [reg_openkey $backupRoot $backupPath -create 1 \
		    -access write]
	    set kSource [reg_openkey $regRoot $regPath -access read]
	    foreach valuename $backupValues {
		set val [reg_getvalue $kSource $valuename]
		reg_setvalue $k $valuename [lindex $val 0] [lindex $val 1]
	    }
	    reg_closekey $k
	    reg_closekey $kSource
	} err ] {
	    catch { reg_closekey $k }
	    catch { reg_closekey $kSource }
	    error "Could not backup registry: $err"
	}
    } else {
	catch { reg_closekey $k }
    }
}

proc setupns::Uninstall { } {
    UninstallMultiUser
    UninstallRegistry
}

proc setupns::UninstallMultiUser { } {
    variable prefsFile
    variable backupExtension
    if [ catch {
	set listUser [GetCurrentUser]
	set userPath [lindex $listUser 1]
	file copy -force [file join $userPath $prefsFile$backupExtension] \
		[file join $userPath $prefsFile]
    } err ] {
	dbg::puts setup "Couldn't uninstall Netscape: $err"
    }
}

###########################################################################
# returns true if successfully installed into nestscape
# 
proc setupns::SetupNetscape { } {
    array set defs [eval [setupgui::GetDefaults]]
    set proxyPort $defs(port)
    set proxyHost "localhost"

    set result [SetupNetscapeMultiUser $proxyHost $proxyPort]
    expr { [SetupNetscapeDefaultUser $proxyHost $proxyPort] || $result }
}

proc setupns::SetupNetscapeDefaultUser { proxyHost proxyPort } {
    variable bookmarkRoot 
    variable bookmarkPath
    set result 1
    if [catch {
	BackupRegistry
	set oldProxy [EditRegistry $proxyHost $proxyPort]
	setupgui::UpdateDefaultsWithOldProxy $oldProxy
	set k [reg_openkey $bookmarkRoot $bookmarkPath -access read]
	set filePath [lindex [reg_getvalue $k "File Location"] 1]
	reg_closekey $k
	AddBookmark $filePath
    } err ] {
	catch { reg_closekey $k }
	dbg::puts setup "Could not setup Netscape default user: $err"
	set result 0
    }
    set result
}
    
proc setupns::EditRegistry { proxyHost proxyPort } {
    variable regPath
    variable regRoot
    set oldProxyHost {}
    set oldProxyPort {}
    
    if [catch { 
	set k [reg_openkey $regRoot $regPath -access write]
	reg_setvalue $k "Proxy Type" dword 1
	reg_setvalue $k "No_Proxy" sz {}
	catch { set oldProxyHost [lindex [reg_getvalue $k "HTTP_Proxy"] 1] }
	reg_setvalue $k "HTTP_Proxy" sz $proxyHost
	catch { set oldProxyPort [lindex [reg_getvalue $k "Http_ProxyPort"] 1]}
	reg_setvalue $k "Http_ProxyPort" dword $proxyPort
	reg_closekey $k
    } err ] {
	catch { reg_closekey $k }
	error "Couldn't modify Netscape registry: $err"
    }
    list $oldProxyHost $oldProxyPort
}

proc setupns::SetupNetscapeMultiUser { proxyHost proxyPort} {
    variable prefsFile
    set result 1
    if [catch {
	if [ catch { set usr [GetCurrentUser] } err ] {
	    #error while trying to read user info from registry
	    error "Could not get current netscape user: $err"
	} elseif [catch { 
	    #modify the users preferences
	    set oldProxy \
		    [EditFile [file join [lindex $usr 1] $prefsFile] \
		    $proxyHost $proxyPort]
	    dbg::puts setup "oldProxy: $oldProxy"
	} err ] {
	    #if there was an error while modifying the user's preferences
	    error "Could not edit prefs file: $err"
	} else {
	    setupgui::UpdateDefaultsWithOldProxy $oldProxy
	}
	variable bookmarkFile
	set userPath [lindex [GetCurrentUser] 1]
	AddBookmark [file join $userPath $bookmarkFile]
    } err] {
	catch { close $f }
	dbg::puts setup "Netscape multiuser setup failed: $err"
	set result 0
    }
    set result
}

proc setupns::GetCurrentUser { } {
    global registryDllLoaded
    if { ![info exists registryDllLoaded] } {
	load registry.dll
	set registryDllLoaded 1
    }
    if [ catch {
	set pathUsers "Software/Netscape/Netscape Navigator/Users"
	set k [reg_openkey key_local_machine $pathUsers]
	set user [lindex [reg_getvalue $k CurrentUser] 1]
	reg_closekey $k
	lappend listResult $user
	set k [reg_openkey key_local_machine $pathUsers/$user]
	lappend listResult [lindex [reg_getvalue $k DirRoot] 1]
	reg_closekey $k
    } err ] {
	catch { reg_closekey $k }
	error $err
    }
    set listResult
}

proc setupns::EditFile { preferencesFileName proxyHost proxyPort} {
    variable backupExists
    variable backupExtension
    set backupFileName $preferencesFileName$backupExtension
    if [ catch {
	set backupExists [file exists $backupFileName]
	if { ! $backupExists } {
	    file copy -force $preferencesFileName $backupFileName
	}
	set filePrefs [open $preferencesFileName r]
	set fileNewPrefs [open $preferencesFileName.new w]
	set replacedProxyLines 0
	set blankLineCount 0
	set oldProxyHost {}
	set oldProxyPort {}
	while { ![eof $filePrefs] && ![catch {gets $filePrefs line}] } {
	    #replace the proxy lines if they are already there
	    if [ regexp \
		    {^user_pref\("network.proxy.http", "([^"]*)"\);} $line \
		    match host] {
		# "
		set oldProxyHost $host
		set line \
			"user_pref(\"network.proxy.http\", \"$proxyHost\");"
		incr replacedProxyLines
	    } elseif [regexp \
		    {^user_pref\("network.proxy.http_port", ([0-9]*)\);} \
		    $line x port ] {
		set oldProxyPort $port
		set line "user_pref(\"network.proxy.http_port\", $proxyPort);"
		incr replacedProxyLines
	    } elseif { [regsub {^user_pref\("network.proxy.type", [0-9]*\);} \
		    $line {user_pref("network.proxy.type", 1);} line] } {
		if !$replacedProxyLines {
		    WriteProxyLines $fileNewPrefs $proxyHost $proxyPort
		    set replacedProxyLines 2
		}
		incr replacedProxyLines
	    }	    
	    if { [string trim $line] == "" } {
		incr blankLineCount
	    } else {
		# now that we have copied or modified the line the way we
		# want it, copy it to the new preferences file
		while { $blankLineCount > 0 } {
		    puts $fileNewPrefs {}
		    incr blankLineCount -1
		}
		puts $fileNewPrefs $line
	    }
	}
	# we are done copying and replacing.
	# if we didn't replace, then we'll have to append
	if !$replacedProxyLines {
	    WriteProxyLines $fileNewPrefs $proxyHost $proxyPort
	    set replacedProxyLines 2
	}
	if { $replacedProxyLines == 2 } {
	    puts $fileNewPrefs "user_pref(\"network.proxy.type\", 1);"
	    set oldProxyHost ""
	    set oldProxyPort ""
	}
	# now copy the ending blank lines
	while { $blankLineCount > 0 } {
	    puts $fileNewPrefs {}
	    incr blankLineCount -1
	}
	close $filePrefs
	close $fileNewPrefs
	file copy -force $preferencesFileName.new $preferencesFileName
	file delete -force $preferencesFileName.new
    } err] { 
	#some kind of file error
	catch { close $filePrefs }
	catch { close $fileNewPrefs }
	error $err
    }
    list $oldProxyHost $oldProxyPort
}

proc setupns::WriteProxyLines { fileNewPrefs proxyHost proxyPort } {
    puts $fileNewPrefs "user_pref(\"network.proxy.http\", \"$proxyHost\");"
    puts $fileNewPrefs \
	    "user_pref(\"network.proxy.http_port\", $proxyPort);"
}

proc setupns::AddBookmark { bmfile } {
    variable bookmark
    if [catch {
	set f [open $bmfile r]
	fconfigure $f -translation binary
	set bmcontents [read $f]
	close $f
	set w "\[ \r\n\t]*"
	regsub "</DL>$w<p>$w\$" $bmcontents $bookmark bmcontents
	regsub -all "\r" $bmcontents {} bmcontents
	set f [open $bmfile w]
	fconfigure $f -translation crlf
	puts -nonewline $f $bmcontents
	close $f
    } err ] {
	catch { close $f }
	error "Could not add bookmark to Netscape:\n$err"
    }
}
	 

###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################
