
###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################

namespace eval mapchar {

}

proc linterleave { l1 l2 } {
    set result [list ]
    set nIndex 0
    set nLength [llength $l1]
    while { $nIndex < $nLength } {
	lappend result [lindex $l1 $nIndex] [lindex $l2 $nIndex]
	incr nIndex
    }
    set result
}    

###########################################################################
# proc mapchar::GenerateMap
# generates a random character between 0x81 and 0xf1 for each corresponding
# character in varListChars
# returns:
# 
#    the first list maps from the oldchars to the new replacements.
# 

proc mapchar::GenerateMap { varListChars } {
    upvar $varListChars listChars
    set nLength [llength $listChars]
    set listNewChars [list ]
    while { [llength $listNewChars] < $nLength } {
	set newChar [format %c [expr { int( rand() * 0x70) + 0x81 }]]
	if { [lsearch -exact $listNewChars $newChar] == -1 } {
	    #it's not a duplicate
	    lappend listNewChars $newChar
	}
    }
    linterleave $listChars $listNewChars]
}




###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################
