VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Object = "{9F432148-A4D9-4087-A1A3-BA04C5289E91}#2.0#0"; "Zoom.ocx"
Begin VB.Form Form1 
   Caption         =   "Zoom ActiveX control sample project by Inspired Creations"
   ClientHeight    =   7380
   ClientLeft      =   90
   ClientTop       =   315
   ClientWidth     =   8670
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   7380
   ScaleWidth      =   8670
   StartUpPosition =   2  'CenterScreen
   Begin ICZoom.Zoom Zoom1 
      Height          =   1500
      Left            =   0
      TabIndex        =   35
      Top             =   0
      Width           =   1500
      _ExtentX        =   2646
      _ExtentY        =   2646
   End
   Begin MSComDlg.CommonDialog Dlg 
      Left            =   4785
      Top             =   5700
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
   End
   Begin VB.Timer tmrMouse 
      Interval        =   180
      Left            =   4155
      Top             =   5745
   End
   Begin VB.PictureBox picRight 
      Align           =   4  'Align Right
      Height          =   6960
      Left            =   6765
      ScaleHeight     =   6900
      ScaleWidth      =   1845
      TabIndex        =   1
      Top             =   0
      Width           =   1905
      Begin VB.ComboBox cboShowBars 
         Height          =   315
         Left            =   90
         Style           =   2  'Dropdown List
         TabIndex        =   34
         Top             =   6465
         Width           =   1650
      End
      Begin VB.Frame Frame2 
         Caption         =   "Div Step"
         Height          =   645
         Left            =   15
         TabIndex        =   31
         Top             =   4785
         Width           =   1800
         Begin VB.TextBox txtDivs 
            Alignment       =   1  'Right Justify
            Height          =   300
            Left            =   660
            Locked          =   -1  'True
            MaxLength       =   5
            TabIndex        =   33
            Text            =   "1"
            Top             =   240
            Width           =   480
         End
         Begin VB.VScrollBar UD 
            Height          =   300
            Left            =   1185
            Max             =   1
            Min             =   100
            TabIndex        =   32
            TabStop         =   0   'False
            Top             =   240
            Value           =   1
            Width           =   270
         End
      End
      Begin VB.ComboBox cboBorderStyle 
         Height          =   315
         Left            =   90
         Style           =   2  'Dropdown List
         TabIndex        =   30
         Top             =   5805
         Width           =   1650
      End
      Begin VB.Frame Frame4 
         Caption         =   "Coords"
         Height          =   960
         Left            =   15
         TabIndex        =   24
         Top             =   1695
         Width           =   1800
         Begin VB.TextBox txtY 
            Alignment       =   1  'Right Justify
            Height          =   300
            Left            =   990
            MaxLength       =   5
            TabIndex        =   26
            Text            =   "0"
            Top             =   540
            Width           =   675
         End
         Begin VB.TextBox txtX 
            Alignment       =   1  'Right Justify
            Height          =   300
            Left            =   990
            MaxLength       =   5
            TabIndex        =   25
            Text            =   "0"
            Top             =   210
            Width           =   675
         End
         Begin VB.Label Label3 
            AutoSize        =   -1  'True
            Caption         =   "CurrentX"
            Height          =   195
            Left            =   300
            TabIndex        =   28
            Top             =   270
            Width           =   615
         End
         Begin VB.Label Label5 
            AutoSize        =   -1  'True
            Caption         =   "CurrentY"
            Height          =   195
            Left            =   300
            TabIndex        =   27
            Top             =   600
            Width           =   615
         End
      End
      Begin VB.Frame Frame3 
         Caption         =   "Colors"
         Height          =   1980
         Left            =   15
         TabIndex        =   13
         Top             =   2730
         Width           =   1800
         Begin VB.CommandButton cmdColor 
            Caption         =   "Left Markers"
            BeginProperty Font 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Index           =   0
            Left            =   105
            TabIndex        =   18
            Top             =   285
            Width           =   1275
         End
         Begin VB.CommandButton cmdColor 
            Caption         =   "Grid A"
            BeginProperty Font 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Index           =   2
            Left            =   105
            TabIndex        =   17
            Top             =   945
            Width           =   1275
         End
         Begin VB.CommandButton cmdColor 
            Caption         =   "Grid B"
            BeginProperty Font 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Index           =   3
            Left            =   105
            TabIndex        =   16
            Top             =   1275
            Width           =   1275
         End
         Begin VB.CommandButton cmdColor 
            Caption         =   "Top Markers"
            BeginProperty Font 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Index           =   1
            Left            =   105
            TabIndex        =   15
            Top             =   615
            Width           =   1275
         End
         Begin VB.CommandButton cmdColor 
            Caption         =   "Divisions"
            BeginProperty Font 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Index           =   4
            Left            =   105
            TabIndex        =   14
            Top             =   1605
            Width           =   1275
         End
         Begin VB.Label lblColor 
            BorderStyle     =   1  'Fixed Single
            BeginProperty Font 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Index           =   0
            Left            =   1425
            TabIndex        =   23
            Top             =   285
            Width           =   315
         End
         Begin VB.Label lblColor 
            BorderStyle     =   1  'Fixed Single
            BeginProperty Font 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Index           =   2
            Left            =   1425
            TabIndex        =   22
            Top             =   945
            Width           =   315
         End
         Begin VB.Label lblColor 
            BorderStyle     =   1  'Fixed Single
            BeginProperty Font 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Index           =   3
            Left            =   1425
            TabIndex        =   21
            Top             =   1275
            Width           =   315
         End
         Begin VB.Label lblColor 
            BorderStyle     =   1  'Fixed Single
            BeginProperty Font 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Index           =   1
            Left            =   1425
            TabIndex        =   20
            Top             =   615
            Width           =   315
         End
         Begin VB.Label lblColor 
            BorderStyle     =   1  'Fixed Single
            BeginProperty Font 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Index           =   4
            Left            =   1425
            TabIndex        =   19
            Top             =   1605
            Width           =   315
         End
      End
      Begin VB.Frame Frame1 
         Caption         =   "Zoom Factor"
         Height          =   945
         Left            =   15
         TabIndex        =   9
         Top             =   60
         Width           =   1800
         Begin VB.HScrollBar scrFactor 
            Height          =   240
            LargeChange     =   5
            Left            =   75
            Max             =   100
            Min             =   1
            TabIndex        =   11
            Top             =   285
            Value           =   1
            Width           =   1665
         End
         Begin VB.TextBox txtZoom 
            Alignment       =   1  'Right Justify
            Height          =   300
            Left            =   690
            TabIndex        =   10
            Text            =   "1"
            Top             =   570
            Width           =   435
         End
         Begin VB.Label lblPrc 
            AutoSize        =   -1  'True
            Caption         =   "x"
            Height          =   195
            Left            =   555
            TabIndex        =   12
            Top             =   615
            Width           =   75
         End
      End
      Begin VB.CheckBox chkFollowMouse 
         Caption         =   "FollowMouse"
         Height          =   300
         Left            =   375
         TabIndex        =   3
         Top             =   1350
         Value           =   1  'Checked
         Width           =   1470
      End
      Begin VB.CheckBox chkGrid 
         Caption         =   "HasGrid"
         Height          =   300
         Left            =   375
         TabIndex        =   2
         Top             =   1095
         Width           =   1050
      End
      Begin VB.Label Label4 
         AutoSize        =   -1  'True
         Caption         =   "BorderStyle"
         Height          =   195
         Left            =   135
         TabIndex        =   29
         Top             =   5550
         Width           =   810
      End
      Begin VB.Label Label6 
         AutoSize        =   -1  'True
         Caption         =   "ShowBars"
         Height          =   195
         Left            =   135
         TabIndex        =   4
         Top             =   6195
         Width           =   720
      End
   End
   Begin VB.PictureBox picBottom 
      Align           =   2  'Align Bottom
      Height          =   420
      Left            =   0
      ScaleHeight     =   360
      ScaleWidth      =   8610
      TabIndex        =   0
      Top             =   6960
      Width           =   8670
      Begin VB.TextBox txtDistY 
         Alignment       =   1  'Right Justify
         Height          =   300
         Left            =   2730
         Locked          =   -1  'True
         MaxLength       =   5
         TabIndex        =   8
         Text            =   "0"
         Top             =   37
         Width           =   480
      End
      Begin VB.TextBox txtDistX 
         Alignment       =   1  'Right Justify
         Height          =   300
         Left            =   975
         Locked          =   -1  'True
         MaxLength       =   5
         TabIndex        =   6
         Text            =   "0"
         Top             =   37
         Width           =   480
      End
      Begin VB.Label lblDist 
         AutoSize        =   -1  'True
         Caption         =   "Distance Y:"
         Height          =   195
         Index           =   1
         Left            =   1815
         TabIndex        =   7
         Top             =   90
         Width           =   825
      End
      Begin VB.Label lblDistX 
         AutoSize        =   -1  'True
         Caption         =   "Distance X:"
         Height          =   195
         Index           =   0
         Left            =   60
         TabIndex        =   5
         Top             =   90
         Width           =   825
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

Private Sub Form_Load()
    
    ' Set Form's KeyPreview to True, to catch keyboard action
    Form1.KeyPreview = True

    ' Fill the BorderStyle cboBox
    cboBorderStyle.AddItem "zmbNone"
    cboBorderStyle.AddItem "zmbFixedSingle"
    cboBorderStyle.ListIndex = Zoom1.BorderStyle

    ' Fill the ShowBars cboBox
    cboShowBars.AddItem "zmsNone"
    cboShowBars.AddItem "zmsLeft"
    cboShowBars.AddItem "zmsTop"
    cboShowBars.AddItem "zmsBoth"
    cboShowBars.ListIndex = Zoom1.ShowBars
    
    ' Set the controls
    Call SetControls

End Sub

Private Sub Form_Resize()

  On Error Resume Next

    If WindowState = vbMinimized Then Exit Sub
    
    ' Set controls position and size
    Zoom1.Width = (ScaleWidth - picRight.Width - 90)
    Zoom1.Height = (ScaleHeight - picBottom.Height - 90)

End Sub

' Moves the markers by pressing Ctrl/Shift and arrow keys
Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)

    ' If the Ctrl key is pressed
    If Shift = vbCtrlMask Then
        ' Check the pressed key
        Select Case KeyCode
            ' Left arrow
            Case vbKeyLeft
                ' Move marker into position
                Call Zoom1.MarkerMove(zmmTopA, zmpDecrease)
            ' Right arrow
            Case vbKeyRight
                ' Move marker into position
                Call Zoom1.MarkerMove(zmmTopA, zmpIncrease)
            ' Up arrow
            Case vbKeyUp
                ' Move marker into position
                Call Zoom1.MarkerMove(zmmLeftA, zmpDecrease)
            ' Down arrow
            Case vbKeyDown
                ' Move marker into position
                Call Zoom1.MarkerMove(zmmLeftA, zmpIncrease)
        End Select
    End If

    ' If the Shift key is pressed
    If Shift = vbShiftMask Then
        ' Check the pressed key
        Select Case KeyCode
            ' Left arrow
            Case vbKeyLeft
                ' Move marker into position
                Call Zoom1.MarkerMove(zmmTopB, zmpDecrease)
            ' Right arrow
            Case vbKeyRight
                ' Move marker into position
                Call Zoom1.MarkerMove(zmmTopB, zmpIncrease)
            ' Up arrow
            Case vbKeyUp
                ' Move marker into position
                Call Zoom1.MarkerMove(zmmLeftB, zmpDecrease)
            ' Down arrow
            Case vbKeyDown
                ' Move marker into position
                Call Zoom1.MarkerMove(zmmLeftB, zmpIncrease)
        End Select
    End If

End Sub

' Zooms In/Out by pressing +/-
Private Sub Form_KeyPress(KeyAscii As Integer)

    ' Check the pressed key
    Select Case KeyAscii
        ' +
        Case 43
            If scrFactor < 100 Then
                ' Increase the zoom factor
                scrFactor = (scrFactor + 1)
            End If
        ' -
        Case 45
            If scrFactor > 1 Then
                ' Decrease the zoom factor
                scrFactor = (scrFactor - 1)
            End If
    End Select

End Sub

' Freezes/UnFreezes the view by pressing Escape/BackSpace
Private Sub Form_KeyUp(KeyCode As Integer, Shift As Integer)

    ' Check the pressed key
    Select Case KeyCode
        ' Escape
        Case vbKeyEscape
            ' Freeze the zoom view
            Call Zoom1.Freeze
        ' BackSpace
        Case vbKeyBack
            ' UnFreeze the zoom view
            Call Zoom1.UnFreeze
    End Select

End Sub




' #################### CONTROLS ####################

Private Sub cmdColor_Click(Index As Integer)

  On Error GoTo Out

    Dlg.Flags = &H3
    Dlg.Color = lblColor(Index).BackColor
    Dlg.ShowColor
    
    Select Case Index
        Case 0
            Zoom1.ClrMarkersL = Dlg.Color
        Case 1
            Zoom1.ClrMarkersT = Dlg.Color
        Case 2
            Zoom1.ClrGridA = Dlg.Color
        Case 3
            Zoom1.ClrGridB = Dlg.Color
        Case 4
            Zoom1.ClrDivs = Dlg.Color
    End Select
    
    lblColor(Index).BackColor = Dlg.Color
    
' Cancel was pressed
Out:

End Sub

' Sets the BorderStyle of the control
Private Sub cboBorderStyle_Click()
    
    Zoom1.BorderStyle = cboBorderStyle.ListIndex

End Sub

' Sets the ShowBars property of the control
Private Sub cboShowBars_Click()
    
    Zoom1.ShowBars = cboShowBars.ListIndex

End Sub

Private Sub scrFactor_Scroll()

    Call scrFactor_Change
    
End Sub

' Sets the Zoom factor of the control
Private Sub scrFactor_Change()

  Dim iFactor As Long

    ' Get the zoom factor
    iFactor = scrFactor.Value

    ' Update the label
    txtZoom.Text = iFactor
    
    ' Set the zoom factor
    Zoom1.Factor = iFactor

End Sub

' Sets the CurrentX property when the Enter key is pressed.
' If the X coord is out of the screen, no error will occure
' but the zoom area will not change
Private Sub txtX_KeyDown(KeyCode As Integer, Shift As Integer)

    If KeyCode = vbKeyReturn Then
        ' Set the CurrentX coord
        Zoom1.CurrentX = Val(txtX)
    End If

End Sub

' Sets the CurrentX property when the Enter key is pressed.
' Accepts only Numbers and Backspace
Private Sub txtX_KeyPress(KeyAscii As Integer)

    ' If not a number key
    If KeyAscii > 31 And (KeyAscii < vbKey0 Or KeyAscii > vbKey9) Then
        ' Cancel char type
        KeyAscii = 0
        Beep
        ' ENTER
        ElseIf KeyAscii = vbKeyReturn Then
        ' Set the CurrentX coord
        Call txtX_LostFocus
        ' Cancel char type
        KeyAscii = 0
    End If
    
End Sub

' If the X coord is out of the screen, no error will occure
' but the zoom area will not change
Private Sub txtX_LostFocus()
    
    ' Set the CurrentY coord
    Zoom1.CurrentX = Val(txtX)
    
    ' Refresh the textbox
    txtX = Zoom1.CurrentX

End Sub

' Sets the CurrentY property when the Enter key is pressed.
' Accepts only Numbers and Backspace
Private Sub txtY_KeyPress(KeyAscii As Integer)

    ' If not a number key
    If KeyAscii > 31 And (KeyAscii < vbKey0 Or KeyAscii > vbKey9) Then
        ' Cancel char type
        KeyAscii = 0
        Beep
        ' ENTER
        ElseIf KeyAscii = vbKeyReturn Then
        ' Set the CurrentY coord
        Call txtY_LostFocus
        ' Cancel char type
        KeyAscii = 0
    End If
    
End Sub

' If the Y coord is out of the screen, no error will occure
' but the zoom area will not change
Private Sub txtY_LostFocus()
    
    ' Set the CurrentY coord
    Zoom1.CurrentY = Val(txtY)
    
    ' Refresh the textbox
    txtY = Zoom1.CurrentY

End Sub

' Accepts only Numbers and Backspace
Private Sub txtZoom_KeyPress(KeyAscii As Integer)

    ' If not a number key
    If KeyAscii > 31 And (KeyAscii < vbKey0 Or KeyAscii > vbKey9) Then
        ' Cancel char type
        KeyAscii = 0
        Beep
        ' ENTER
        ElseIf KeyAscii = vbKeyReturn Then
        ' Force a zoom update
        Call txtZoom_LostFocus
        ' Cancel char type
        KeyAscii = 0
    End If
    
End Sub

' Sets the Zoom factor of the control, by setting scrFactor
Private Sub txtZoom_LostFocus()

  Dim iFactor As Long

    ' Get the zoom factor
    iFactor = Val(txtZoom)
    
    ' Error handling
    ' -------------------------------
    If iFactor > scrFactor.Max Then
        iFactor = scrFactor.Max
        ElseIf iFactor < scrFactor.Min Then
        iFactor = scrFactor.Min
    End If
    ' -------------------------------
    
    ' Set the scrollbar
    scrFactor.Value = iFactor
    
    ' Refresh the textbox
    txtZoom = iFactor

End Sub

' Sets the FollowMouse property
Private Sub chkFollowMouse_Click()

    Zoom1.FollowMouse = chkFollowMouse
    
    ' If we wish manual zoom
    If chkFollowMouse Then ' And (Not bFrozen)
        ' Start reading the CurrentX and CurrentY coords
        tmrMouse.Enabled = True
        ' If we wish auto zoom
        Else
        ' Stop reading the CurrentX and CurrentY coords
        tmrMouse.Enabled = False
    End If
        
End Sub

' Turns On/Off the grid
Private Sub chkGrid_Click()

    Zoom1.HasGrid = chkGrid
    
End Sub

' Sets the frequency of divisions
Private Sub UD_Change()

    ' Set property
    Zoom1.Step = UD.Value

    ' Show value
    txtDivs = CStr(Zoom1.Step)

End Sub

' Gets the CurrentX and CurrentY properties of the control
Private Sub tmrMouse_Timer()

    txtX = Zoom1.CurrentX
    txtY = Zoom1.CurrentY

End Sub






































' #################### FUNCTIONS ####################

' Sets the form's controls to show the control's properties
Private Sub SetControls()

    lblColor(0).BackColor = Zoom1.ClrMarkersL
    lblColor(1).BackColor = Zoom1.ClrMarkersT
    lblColor(2).BackColor = Zoom1.ClrGridA
    lblColor(3).BackColor = Zoom1.ClrGridB
    lblColor(4).BackColor = Zoom1.ClrDivs
    
    chkGrid = Abs(Int(Zoom1.HasGrid))
    chkFollowMouse.Value = Abs(Int(Zoom1.FollowMouse))
    
    scrFactor = Zoom1.Factor
    UD.Value = Zoom1.Step
    
    cboShowBars.ListIndex = Zoom1.ShowBars
    
End Sub






































' #################### EVENTS ####################

' A marker of the Top bar has been moved
Private Sub Zoom1_MarkerChangeX(ByVal Distance As Long)

    ' Show the distance
    txtDistX = Distance

End Sub

' A marker of the Left bar has been moved
Private Sub Zoom1_MarkerChangeY(ByVal Distance As Long)

    ' Show the distance
    txtDistY = Distance

End Sub


