//******************************************************
// SPRINT - Print & Preview engine for Delphi
// WWW.SMART.CO.YU
//******************************************************

unit report2;

interface

procedure Report_2(show:Boolean);

implementation

uses Main,Sprint,Graphics,SysUtils,Classes,DBTables,Printers;

procedure Report_2(show:Boolean);
var
   q :TQuery;
   Sp:TSprint;
begin
   q:=TQuery.Create(nil);
   q.Active:=False;
   q.DatabaseName:='DBDEMOS';
   q.SQL.Add('select * from customer a order by a.company');
   q.Active:=True;

   //1..initialize sprint
   Sp:=form1.SPrint1;
   Sp.BeginDoc;
   Sp.KEY:='When you purchase SPRINT you will insert received KEY here';
   //2..changing some default values (defaults: linespace=1.1)   
   Sp.Style[tsHead].LineSpace:=1.5;
   Sp.Style[tsText].LineSpace:=1.5;
   //3..heading on the first page can be drawn using various methods
   Sp.Style[tsDef1].Font.Name:='Arial';
   Sp.Style[tsDef1].Font.Size:=-32;
   Sp.Style[tsDef1].Font.Style:=[fsBold,fsItalic];
   Sp.Style[tsDef1].Font.Color:=clNavy;
   Sp.AddField(' ',' ',taCenter);
   Sp.AddField(' ',' ',taCenter);
   Sp.AddField(' ',' ',taCenter);
   Sp.Recalculate(-150); {15 mm from both paper edges}
   Sp.SetStyle(tsDef1);
   Sp.PrintField(2,'Customer Listing');
   Sp.SetStyle(tsText);
   Sp.CurrY:=Sp.CurrY+200;
   //4..preparing to print query
   Sp.ClearFields;
   Sp.AddField('XXXXXXXXXXXXXXXXXXXXXXX','Company',taLeftJustify);
   Sp.AddField('XXXXXXXXXXXXXXXXXXXX','Contact',taLeftJustify);
   Sp.AddField('XXXXXXXXXXX','Phone',taLeftJustify);
   Sp.AddField('XXXXXXXXXXX','Fax',taLeftJustify);
   Sp.AddField('Cust.No','Cust.no',taCenter);
   Sp.Recalculate(-150); {15 mm from both paper edges}
   //5..as easy as following code
   q.First;
   while q.Eof=False do begin
      Sp.Add([
         q.FieldByName('Company').AsString,
         q.FieldByName('Contact').AsString,
         q.FieldByName('Phone').AsString,
         q.FieldByName('Fax').AsString,
         q.FieldByName('CustNo').AsString
         ]);
      q.Next;
   end;
   //6..print or preview?
   if show then Sp.ShowPreview else Sp.PrintAll;
   Sp.EndDoc;
   q.Active:=False;
   q.Free;
end;

end.
