// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : unws.c
// Description  : WordStar to Plain Text Filter
//
//                A filter which strips the 8 bit ascii formatting used
//                in files created in the old WordStar WordProcesser.
//
//                Output is in the form of plain text with formatting
//                removed. Tested with WordStar 3 and 4.
//
// Written by   : Bill Buckels
// Date Written : 1989
// Revision     : 2.0 March 2000
// ------------------------------------------------------------------------
#include <stdio.h>

void main(int argc, char **argv)
{
    int c, d = 0;
    FILE *fp = NULL;

    if (argc > 1)
      fp = fopen(argv[1], "rb");

    for (;;)
    {
      if (NULL == fp)
        c = getchar();
      else
        c = fgetc(fp);

      if (c==EOF)break;

      // if CTRL-Z found, EOF
      if (c == 0x1a)
        break;
      // 7 bit ascii
      c = c&0x7f;
      // avoid wordstar's cludgy blocking
      if (c == ' ' && d == ' ')
        continue;
      // skip lower order characters except for line feeds and tabs
      if (c > 31 || c == '\n' || c == '\t')
        putchar(c);
      d = c;
    }
    if (fp != NULL) {
      fclose(fp);
      exit(0);
    }
}

