// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : onespace.c
// Description  : Convert doublespace to singlespace (remove blank
//                lines.) This program is a filter that deletes blank
//                lines from a file.
//
//                Examples:
//                  onespace abc.txt
//                    read input from abc.txt,
//                  onespace abc.txt >abcnew.txt
//                  onespace <abc.txt >abcnew.txt
//                  onespace abc.txt | find "ABC"
//                  find "abc" abc.txt | onespace | sort
//
// Written by   : Bill Buckels
// Based On     : snglspc.asm
//                used with permission
// Date Written : March 2000
// Revision     : 1.1 First Release
// ------------------------------------------------------------------------
#include <stdio.h>

void main(int argc, char **argv)
{
    int c, d = 0, e = 0;
    FILE *fp = NULL;

    if (argc > 1)
      fp = fopen(argv[1], "r");

    for (;;) {
      if (NULL == fp)
        c = getchar();
      else
        c = fgetc(fp);

      if (c==EOF)break;
      if (c == '\n' && d == '\n' && e == '\n' || c == '\r')
        continue;

      putchar(c);
      e = d;
      d = c;
    }

    if (NULL != fp) {
      fclose(fp);
      exit(0);
    }
}
