// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : numbey.c
// Description  : Line Numbering Filter
//
//                A filter which will number all the lines in a file.
//                Options are user-defined increment rate, and formatting
//                style for line numbers (using long integer).
//
//                Originally developed to re-number GWBASIC programs
//                in order to run in the old interpreter.
//
// Written by   : Bill Buckels
// Date Written : 1989
// Revision     : 2.0 March 2000
// ------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>

char infile[_MAX_PATH] = "\0";
FILE *fp = NULL;

void main(int argc, char **argv)
{
    int c,
        idx,
        flag = 1,
        increment = 1; // allow command line override on incrementing
    long cnt = 0L;
    char fmt[128] = "%-8ld";  // allow command line override on formatting

    if (argc > 1) {
      for (idx = 1; idx < argc; idx++) {
        if (argv[idx][0] == '%') {
          strcpy(fmt, argv[idx]);
        }
        else {
          if (argv[idx][0] >= '1' && argv[idx][0] <= '9') {
            increment = atoi(argv[idx]);
          }
          else {
            if (infile[0] == 0)
              strcpy(infile, argv[idx]);
          }
        }
      }
    }
    if (infile[0] != 0) {
      fp = fopen(infile, "r");
    }


    for (;;)
    {
        if (NULL == fp)
          c = getchar();
        else
          c = fgetc(fp);

        if (c==EOF)break;

        if (flag) {
          cnt+=increment;
          printf(fmt, cnt);
          flag = 0;
        }
        if(c == '\n')
          flag = 1;
        putchar(c);
    }
    if (NULL != fp) {
      fclose(fp);
      exit(0);
    }

}
