// ------------------------------------------------------------------------
// System       : MS-DOS
// Program      : modeset.c
// Description  : set video mode
// Written by   : Bill Buckels
// Errata       : This program cannot be compiled using MSC 12
//                because the inline assembly leaves the system unstable.
//                So compiled under MSC 6 as a .COM.
// ------------------------------------------------------------------------

int main(int argc, char **argv)
{
  unsigned char temp, vmode = 0;

  if (argc > 1)
    vmode = (unsigned char) atoi(argv[1]) & 0xff;

  if (vmode != 0) {
    // get mode
    _asm{
      mov ah,0fh
      int 10h
      mov temp,al
    }

    if (temp != vmode) {
      // set mode
      _asm{
          mov al,vmode
          mov ah,0
          int 10h
      }
      // get mode
      _asm{
          mov ah,0fh
          int 10h
          mov temp,al
      }
    }
  }
  return (int)temp;
}
