
'FILE: srllib.bas - srllib global constants
 
Global Const AT_FAILURE = -1
Global Const AT_FAILUREP = Null

Global Const EDV_BADDESC = -1
Global Const EDV_NOERROR = 0

'Open Flags for devices
 
Global Const OF_DEFAULT = &H0           ' Open device without automatic notification
Global Const O_NOTIFY = &H1             ' Open device with automatic notification

'General Defines
 
Global Const EV_ANYEVT = &HFFFF         ' Matches Any Event Type
Global Const EV_ANYDEV = -1             ' Matches Any Device
Global Const SR_DFLT_DATASIZE = 48      ' Max size for SRl's statically allocated
                                        ' event data area
'EVENT MANAGEMENT
 
Global Const SR_INTERPOLLID = &H1       ' Parameter id for inter-poll delay
Global Const SR_MODEID = &H2            ' Set SRL running in signalling or DOS mode
Global Const SR_DATASZID = &H3          ' Parameter id for getting/setting SRL's
                                        ' preallocated event data memory size
Global Const SR_QSIZEID = &H4           ' Maximum size of SRL's internal event queue
Global Const SR_MODELTYPE = &H5         ' Set SRL model type (for NT only)

Global Const SR_POLLMODE = 0            ' Run SRL in polling mode
Global Const SR_SIGMODE = 1             ' Run SRL in signalling/interrupt mode
Global Const SRL_DEVICE = 0             ' The SRL device
Global Const SR_TMOUTEVT = 0            ' Timeout event - occurs on the SRL DEVICE

Global Const SR_STASYNC = 0             ' single threaded async model
Global Const SR_MTASYNC = 1             ' multithreaded asynchronous model
Global Const SR_MTSYNC = 2              ' multithreaded synchronous model

Global Const SR_NOTIFY_ON = 0           ' Turn on message notification
Global Const SR_NOTIFY_OFF = 1          ' Turn off message notification

' SRL errors

Global Const ESR_NOERR = 0              ' No SRL errors
Global Const ESR_SCAN = 1               ' SRL scanning function returned an error
Global Const ESR_PARMID = 2             ' Unknown parameter id
Global Const ESR_TMOUT = 3              ' Returned by ATDV_LASTERR( SRL_DEVICE ) when
                                        ' an SRL function timed out
Global Const ESR_SYS = 4                ' System error - consult errno
Global Const ESR_DATASZ = 5             ' Invalid size for default event data
                                        ' memory
Global Const ESR_QSIZE = 6              ' Illegal event queue size
Global Const ESR_NOHDLR = 7             ' No such handler
Global Const ESR_MODE = 8               ' Illegal mode for this operation
Global Const ESR_NOTIMP = 9             ' function not implemented

Global Const SR_TMOUT = -1              ' Returned by event scanning functions (e.g.
                                        ' sr_waitevt()) when they time out
                                        
' Defines for DLL modes (to be passed to the xx_libinit functions)

Global Const DLGC_ST = 0                ' Single threaded operation
Global Const DLGC_MT = 1                ' Multithreaded operation

Global Const EQ = "="

