Attribute VB_Name = "Module3"
'       FILE: d40low.txt
'
'Misc. values
 
Global Const NULLSPTR = &HFFFF        ' null silence pointer

'
'reset complete values
 
Global Const DLR_SUCC = &H0           ' board was successfully reset
Global Const DLR_MEMFAIL = &H1        ' board failed memory test
Global Const DLR_REGFAIL = &H2        ' board failed register test
Global Const DLR_FLAGFAIL = &H3       ' board failed flags test
Global Const DLR_CHKSUM = &H4         ' board failed checksum test
Global Const DLR_PRODID = &H5         ' invalid product ID code
Global Const DLR_CHNUM = &H6          ' invalid number of channels

'
'Equates for Dialog/4x to PC command codes.
'The following messages are enabled by the set_IEN command.
 
Global Const DL_B0FULL = &H1          ' buffer 0 full
Global Const DL_B1FULL = &H2          ' buffer 1 full
Global Const DL_B0EMPTY = &H3         ' buffer 0 empty
Global Const DL_B1EMPTY = &H4         ' buffer 1 empty

'
'Equates for Dialog/4x to PC command codes.
'The following message is enabled by the 'old' param. of the PC_INITBUF cmd.
 
Global Const DL_DIGITRDY = &H0        ' digit collected

'
'Equates for Dialog/4x to PC command codes.
'The following messages are always enabled.
 
Global Const DL_RECORD = &H8          ' record complete
Global Const DL_RECCMPLT = DL_RECORD ' duplicate name for driver
Global Const DL_PLAYBACK = &H7        ' playback complete
Global Const DL_PLAYCMPLT = DL_PLAYBACK ' duplicate name for driver
Global Const DL_DIAL = &H5            ' dial complete
Global Const DL_BEEP = &HA            ' beep complete

Global Const DL_COMTEST = &HB         ' communication test
Global Const DL_ACK = &HC             ' communication test acknowledgement

Global Const DL_CST = &H6             ' call status transition

Global Const DL_ERROR = &H9           ' PC to DIALOG/4X command error

Global Const DL_MTST = &HD            ' memory test complete

'
'New equates for Dialog/4x to PC command codes supported by firmware ver.60.
'The following messages are always enabled.
 
Global Const DL_RPTBUF = &H15         ' digit buffer count
Global Const DL_GETDIGITS = &H10      ' get digits complete
Global Const DL_UPDPARM = &H16        ' update of parameters complete
Global Const DL_GETPARM = &H13        ' current parameters
Global Const DL_WINK = &H17           ' wink complete
Global Const DL_TIMER = &H11          ' timer reached zero
Global Const DL_WATCHDOG1 = &H12      ' 1st watchdog timeout
Global Const DL_WATCHDOG2 = &H14      ' 2nd watchdog timeout

Global Const MAXDLCMD = &H17          ' maximum number of DIALOG/4X commands

'
'Special equates for new Dialog/4x to PC command codes to replace certain
'CST event flavors.
 
Global Const DL_OFFHOOKC = &H30       ' offhook complete
Global Const DL_ONHOOKC = &H31        ' onhook complete
Global Const DL_CALL = &H32           ' call analysis complete

'
'Special equates for simulated Dialog/4x to PC command codes to support
'driver handling of play and record.
 
Global Const DL_BUFEMPTY = &H40       ' virtual buffer empty
Global Const DL_BUFFULL = &H41        ' virtual buffer full

'
'Equates for PC to Dialog/4x command codes.
'The following commands do not cause the board to send a DL reply msg.
 
Global Const PC_SETIEN = &H7          ' set the interrupt enable mask
Global Const PC_SETRINGS = &H5        ' set number of rings for cst event
Global Const PC_PULSE = &HB           ' enable pulse digit collection

'
'Equates for PC to Dialog/4x command codes.
'The following commands cause the board to send a DL reply msg.
 
Global Const PC_RECORD = &H1          ' place channel in record mode
Global Const PC_PLAYBACK = &H2        ' place channel in playback mode
Global Const PC_DIAL = &H6            ' dial ASCIIZ string in buf0
Global Const PC_BEEP = &H8            ' start beeping

Global Const PC_COMTEST = &H9         ' communication test
Global Const PC_ACK = &HA             ' communication test response

Global Const PC_OFFHOOK = &H4         ' place channel offhook
Global Const PC_ONHOOK = &H3          ' place channel onhook

Global Const PC_STOP = &H0            ' stop operation in progress

'
'New equates for PC to Dialog/4x command codes supported by firmware ver.60.
'The following commands do not cause the board to send a DL reply msg.
 
Global Const PC_SETTERMS = &H14       ' set terminating conditions
Global Const PC_CLRHIST = &H19        ' clear termination history
Global Const PC_INITBUF = &H10        ' initialize digit buffer
Global Const PC_CLRBUF = &H11         ' clear digit buffer

'
'New equates for PC to Dialog/4x command codes supported by firmware ver.60.
'The following commands cause the board to send a DL reply msg.
 
Global Const PC_RPTBUF = &H12         ' report digit buffer count
Global Const PC_GETDIGITS = &H13      ' get digits
Global Const PC_UPDPARM = &H17        ' update parameters
Global Const PC_GETPARM = &H18        ' get current parameters
Global Const PC_WINK = &H1A           ' initiate a wink command
Global Const PC_TIMER = &H15          ' start timer
Global Const PC_WATCHDOG = &H16       ' start watchdog

Global Const MAXPCCMD = &H1A          ' maximum number of PC commands

'
'Equates for PC to Dialog/4x at boot up time.
 
Global Const REQ_RESET = &HFF         ' clear, reset and go

Global Const REQ_MTST = &HFE          ' do the memory test and stop

'
'Call status transition data equates.
'The following CST's are enabled by the set_IEN command.
 
Global Const CST_OFFHOOK = &H1        ' offhook transition complete
Global Const CST_HOOK_DONE = CST_OFFHOOK ' duplicate name for driver
Global Const CST_ONHOOK = &H6         ' onhook transition complete
Global Const CST_ONH_DONE = CST_ONHOOK ' duplicate name for driver
Global Const CST_RINGS = &H2          ' rings received
Global Const CST_WINKRCVD = &HE       ' wink received
Global Const CST_RNGOFF = &HF         ' ring off messages

Global Const CST_LCOFF = &H3          ' loop current off
Global Const CST_LCON = &HD           ' loop current on
Global Const CST_LCREV = &H20         ' loop current reversal
Global Const CST_SILENCEOFF = &H4     ' silence off
Global Const CST_SILENCEON = &H5      ' silence on

'
'Call status transition data equates.
'The following CST's are always enabled.
 
Global Const CST_BUSY = &H7            ' line busy  (call analysis)
Global Const CST_NOANS = &H8           ' no answer (call analysis)
Global Const CST_NORB = &H9            ' no ringback (call analysis)
Global Const CST_CNCT = &HA            ' call connected (call analysis)
Global Const CST_CEPT = &HB            ' operator intercept (call analysis)
Global Const CST_STOPD = &HC           ' call analysis stopped (call analysis)
Global Const CST_NO_DIALTONE = &H11
Global Const CST_FAXTONE = &H12

'
'Interrupt enable(IEN) bits, if bit is 1(on) then int is enabled, 0 is
'disabled for set_ien message.
'The following bits enable DL reply messages.
 
Global Const IEN_BUFEMPTY = &H1       ' enable buffer empty messages
Global Const IEN_BUFFULL = &H2        ' enable buffer full messages

'
'Interrupt enable(IEN) bits, if bit is 1(on) then int is enabled, 0 is
'disabled for set_ien message.
'The following bits enable flavors of the DL_CST message.
 
Global Const IEN_OFFHOOK = &H20       ' enable offhook complete messages
Global Const IEN_ONHOOK = &H100       ' enable onhook complete messages
Global Const IEN_RINGS = &H10         ' enable rings received messages
Global Const IEN_WINKRCVD = &H800     ' enable wink received messages
Global Const IEN_RNGOFF = &H1000      ' enable ring off messages

Global Const IEN_LCOFF = &H8          ' enable loop current drop messages
Global Const IEN_LCON = &H400         ' enable loop current on messages
Global Const IEN_LCREV = &H1000       ' enable loop current reversal messages
Global Const IEN_SILENCEOFF = &H80    ' enable silence off messages
Global Const IEN_SILENCEON = &H40     ' enable silence on messages

'
'Interrupt enable(IEN) bits, if bit is 1(on) then int is enabled, 0 is
'disabled for set_ien message.
'The following bit has no effect on DL reply messages.
 
Global Const IEN_DTMF = &H4           ' enable DTMF digit collection

'
'pdd reception type - data value for PC_PULSE message
 
Global Const PDD_OFF = &H0            ' turn pulse digit detect off
Global Const PDD_ON = &H1             ' turn pulse digit detect on

'
'Set digit type in the DL_DIGITRDY (digit ready) message.
 
Global Const DG_DTMF = &H0             ' DTMF Digit
Global Const DG_LPD = &H1              ' Loop Pulse Digit
Global Const DG_DPD = &H2              ' Dial Pulse Digit
Global Const DG_APD = &H2              ' Audio Pulse Digit
Global Const DG_MF = &H3               ' MF Digit

Global Const DM_DTMF = 1                ' (1 << DG_DTMF)
Global Const DM_LPD = 2                 ' (1 << DG_LPD)
Global Const DM_APD = 4                 ' (1 << DG_APD)
Global Const DM_MF = 8                  ' (1 << DG_MF)
Global Const DM_DPD = &H10              ' Enable DPD detection
Global Const DM_DPDZ = &H20             ' Enable Zero-Trained DPD Detection

'
'Record complete reason codes
 
Global Const RCR_STOP = &H2           ' record stopped
Global Const RCR_DTMF = &H3           ' record terminated by DTMF

'
'Play complete reason codes
 
Global Const PCR_MAXBYTE = &H1        ' playback reached maximum bytes
Global Const PCR_STOP = &H2           ' playbacked stopped
Global Const PCR_DTMF = &H3           ' playback terminated by DTMF

'
'Beep complete reason codes
 
Global Const BCR_MAXCNT = &H1         ' beep reached maximum repetions
Global Const BCR_STOP = &H2           ' beep stopped
Global Const BCR_DTMF = &H3           ' beep terminated by DTMF

'
'Record type codes - this field is bitmapped
 
Global Const RT_SIMARK = &H1          ' mark silence start/stop events
Global Const RT_TTINIT = &H2          ' initiate record with DTMF
Global Const RT_TTTERM = &H4          ' terminate record with DTMF
Global Const RT_TDTONE = &H8          ' play tone before record initiation
Global Const RT_INITSET = &H110       ' touch tone initiation set

'
'Playback type codes - this field is bitmapped
 
Global Const PT_TTINIT = &H2          ' initiate playback with DTMF
Global Const PT_TTTERM = &H4          ' terminate playback with DTMF
Global Const PT_TDTONE = &H8          ' play tone before playback initiation
Global Const PT_INITSET = &H110       ' touch tone initiation set

'
'Beep type codes - this field is bitmapped
 
Global Const BT_TTINIT = &H2          ' initiate beep with DTMF
Global Const BT_TTTERM = &H4          ' terminate beep with DTMF

'
'DTMF initiator bit masks used in dl_dtinit#
 
Global Const DM_D = &H1               ' DTMF d
Global Const DM_1 = &H2               ' DTMF 1
Global Const DM_2 = &H4               ' DTMF 2
Global Const DM_3 = &H8               ' DTMF 3
Global Const DM_4 = &H10              ' DTMF 4
Global Const DM_5 = &H20              ' DTMF 5
Global Const DM_6 = &H40              ' DTMF 6
Global Const DM_7 = &H80              ' DTMF 7
Global Const DM_8 = &H100             ' DTMF 8
Global Const DM_9 = &H200             ' DTMF 9
Global Const DM_0 = &H400             ' DTMF 0
Global Const DM_STAR = &H800          ' DTMF'
Global Const DM_POUND = &H11000       ' DTMF #
Global Const DM_A = &H22000           ' DTMF a
Global Const DM_B = &H44000           ' DTMF b
Global Const DM_C = &H88000           ' DTMF c

'
'DTMF flags (see dl_dflags) - the edge on which to send DTMF ready message
 
Global Const DF_MKBK1 = &H1           ' for channel 1
Global Const DF_MKBK2 = &H2           ' for channel 2
Global Const DF_MKBK3 = &H4           ' for channel 3
Global Const DF_MKBK4 = &H8           ' for channel 4

'
'Flag for operator intercept part of call progress
 
Global Const OPTEN = &H1              ' enable operator intercept w/connect
Global Const OPTDIS = &H2             ' disable operator intercept
Global Const OPTCON = &H3             ' enable operator intercept w/o connect

Global Const H_REDGE = &H1            ' rising edge detection of "hello"
Global Const H_FEDGE = &H2            ' falling edge detection of "hello"

Global Const ANSRDIS = &HFFFF         ' disable answer deglitching

Global Const DLPRODA = 0              ' an A series D/4x
Global Const DLPRODB = 11             ' a B series D/4x

'
'Success or failure indicators of update parameters function
 
Global Const UPD_OK = 0               ' parameters updated successfully
Global Const UPD_FAIL = 11            ' parameters not updated successfully

'
'ROM type definition bit masked
 
Global Const ROM_CCITT = 11           ' CCITT dial table used for DTMF dialing

