/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

class Notepad
extends JPanel {
    private static ResourceBundle resources;
    public seGraph graph;
    public StatusBar Bar;
    public JScrollPane scroller;
    JCheckBox compact = new JCheckBox("Compact", false);
    JCheckBox auto_adjust = new JCheckBox("Relax", true);
    private JComponent editor;
    private Hashtable commands;
    private Hashtable menuItems;
    private JMenuBar menubar;
    private JToolBar toolbar;
    private JComponent status;
    private JFrame elementTreeFrame;
    protected ElementTreePanel elementTreePanel;
    protected FileDialog fileDialog;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String tipSuffix = "Tooltip";
    public static final String openAction = "open";
    public static final String newAction = "new";
    public static final String saveAction = "save";
    public static final String saveAsAction = "save_as";
    public static final String exitAction = "exit";
    public static final String compactAction = "compact";
    public static final String adjustAction = "adjust";
    public static final String relaxAction = "relax";
    public static final String clearAction = "clear";
    public static final String showElementTreeAction = "showElementTree";
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();
    private Action[] defaultActions = new Action[]{new NewAction(), new SaveAction(), new SaveAsAction(), new OpenAction(), new ExitAction(), new AdjustAction(), new CompactAction(), new RelaxAction(), new ClearAction(), new ShowElementTreeAction(), this.undoAction, this.redoAction};

    static {
        try {
            resources = ResourceBundle.getBundle("resources.Notepad", Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("resources/Notepad.properties not found");
            System.exit(1);
        }
    }

    Notepad() {
        super(false);
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.err.println("Error loading L&F: " + exc);
        }
        this.setLayout(new BorderLayout());
        this.commands = new Hashtable();
        Action[] actions = this.getActions();
        int i = 0;
        while (i < actions.length) {
            Action a = actions[i];
            this.commands.put(a.getValue("Name"), a);
            ++i;
        }
        this.scroller = new JScrollPane();
        this.Bar = this.createStatusbar();
        this.graph = new seGraph(this);
        this.graph.MessageBox("Cell metabolic network viewer 1.0.\n\n This program can only be used for scientific or other non-commercial purposes.\n Unpacking of main executeble archive, Notepad.jar, is prohibited.\nProgrammed by Dr Audrius Meskauskas,\nVilnius Gediminas Technical University.\nAll rights reserved.");
        this.scroller.setViewportView(this.graph);
        this.menuItems = new Hashtable();
        this.menubar = this.createMenubar();
        this.add("North", this.menubar);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.createToolbar());
        panel.add("Center", this.scroller);
        panel.setBackground(Color.white);
        this.add("Center", panel);
        this.add("South", this.Bar);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem b) {
        return new ActionChangedListener(b);
    }

    protected JTextComponent createEditor() {
        return new JTextArea();
    }

    protected JMenu createMenu(String key) {
        String[] itemKeys = this.tokenize(this.getResourceString(key));
        JMenu menu = new JMenu(this.getResourceString(String.valueOf(key) + labelSuffix));
        int i = 0;
        while (i < itemKeys.length) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
            } else {
                JMenuItem mi = this.createMenuItem(itemKeys[i]);
                menu.add(mi);
            }
            ++i;
        }
        return menu;
    }

    protected JMenuItem createMenuItem(String cmd) {
        String astr;
        JMenuItem mi = new JMenuItem(this.getResourceString(String.valueOf(cmd) + labelSuffix));
        URL url = this.getResource(String.valueOf(cmd) + imageSuffix);
        if (url != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(new ImageIcon(url));
        }
        if ((astr = this.getResourceString(String.valueOf(cmd) + actionSuffix)) == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        Action a = this.getAction(astr);
        if (a != null) {
            mi.addActionListener(a);
            a.addPropertyChangeListener(this.createActionChangeListener(mi));
            mi.setEnabled(a.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        this.menuItems.put(cmd, mi);
        return mi;
    }

    protected JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        String[] menuKeys = this.tokenize(this.getResourceString("menubar"));
        int i = 0;
        while (i < menuKeys.length) {
            JMenu m = this.createMenu(menuKeys[i]);
            if (m != null) {
                mb.add(m);
            }
            ++i;
        }
        return mb;
    }

    protected StatusBar createStatusbar() {
        this.Bar = new StatusBar();
        this.status = this.Bar;
        return this.Bar;
    }

    protected Component createTool(String key) {
        return this.createToolbarButton(key);
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        String[] toolKeys = this.tokenize(this.getResourceString("toolbar"));
        int i = 0;
        while (i < toolKeys.length) {
            if (toolKeys[i].equals("-")) {
                this.toolbar.add(Box.createHorizontalStrut(5));
            } else {
                this.toolbar.add(this.createTool(toolKeys[i]));
            }
            ++i;
        }
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(new JLabel("On expand:  "));
        this.toolbar.add(this.compact);
        this.toolbar.add(this.auto_adjust);
        return this.toolbar;
    }

    protected JButton createToolbarButton(String key) {
        Action a;
        URL url = this.getResource(String.valueOf(key) + imageSuffix);
        JButton b = new JButton(new ImageIcon(url)){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        String astr = this.getResourceString(String.valueOf(key) + actionSuffix);
        if (astr == null) {
            astr = key;
        }
        if ((a = this.getAction(astr)) != null) {
            b.setActionCommand(astr);
            b.addActionListener(a);
        } else {
            b.setEnabled(false);
        }
        String tip = this.getResourceString(String.valueOf(key) + tipSuffix);
        if (tip != null) {
            b.setToolTipText(tip);
        }
        return b;
    }

    protected Action getAction(String cmd) {
        if (this.commands != null) {
            return (Action)this.commands.get(cmd);
        }
        return null;
    }

    public Action[] getActions() {
        return this.defaultActions;
    }

    protected JTextComponent getEditor() {
        return null;
    }

    protected Frame getFrame() {
        Container p = this.getParent();
        while (p != null) {
            if (p instanceof Frame) {
                return (Frame)p;
            }
            p = p.getParent();
        }
        return null;
    }

    protected JMenuItem getMenuItem(String cmd) {
        return (JMenuItem)this.menuItems.get(cmd);
    }

    protected JMenuBar getMenubar() {
        return this.menubar;
    }

    protected URL getResource(String key) {
        String name = this.getResourceString(key);
        if (name != null) {
            URL url = this.getClass().getResource(name);
            return url;
        }
        return null;
    }

    protected String getResourceString(String nm) {
        String str;
        try {
            str = resources.getString(nm);
        }
        catch (MissingResourceException missingResourceException) {
            str = null;
        }
        return str;
    }

    protected Container getToolbar() {
        return this.toolbar;
    }

    public static void main(String[] args) {
        Notepad n = null;
        try {
            String vers = System.getProperty("java.version");
            if (vers.compareTo("1.1.2") < 0) {
                System.out.println("!!!WARNING: Swing must be run with a 1.1.2 or higher version VM!!!");
            }
            JFrame frame = new JFrame();
            frame.setTitle(resources.getString("Title"));
            ((Component)frame).setBackground(Color.lightGray);
            frame.getContentPane().setLayout(new BorderLayout());
            n = new Notepad();
            frame.getContentPane().add("Center", n);
            frame.addWindowListener(new AppCloser());
            frame.pack();
            ((Component)frame).setSize(500, 600);
            frame.show();
            ((Component)frame).setSize(501, 601);
        }
        catch (Throwable t) {
            System.out.println("uncaught exception: " + t);
            t.printStackTrace();
        }
        n.graph.Next();
    }

    protected String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        int i = 0;
        while (i < cmd.length) {
            cmd[i] = (String)v.elementAt(i);
            ++i;
        }
        return cmd;
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem mi) {
            this.menuItem = mi;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.menuItem.setEnabled(enabledState);
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            Notepad.this.undo.addEdit(e.getEdit());
            Notepad.this.undoAction.update();
            Notepad.this.redoAction.update();
        }
    }

    class StatusBar
    extends JPanel {
        JTextField text;
        JProgressBar progress;

        public StatusBar() {
            this.setLayout(new GridLayout(1, 2));
            this.text = new JTextField("Status bar");
            this.progress = new JProgressBar(0, 100);
            this.text.setEditable(false);
            this.add(this.text);
            this.add(this.progress);
        }

        public void Progress(int n) {
            this.progress.setValue(n);
        }

        public void setText(String s) {
            this.text.setText(s);
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Notepad.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println("Unable to undo: " + ex);
                ex.printStackTrace();
            }
            this.update();
            Notepad.this.redoAction.update();
        }

        protected void update() {
            if (Notepad.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", Notepad.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Notepad.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                System.out.println("Unable to redo: " + ex);
                ex.printStackTrace();
            }
            this.update();
            Notepad.this.undoAction.update();
        }

        protected void update() {
            if (Notepad.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", Notepad.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(Notepad.openAction);
        }

        OpenAction(String def) {
            super(def);
        }

        public void actionPerformed(ActionEvent e) {
            File f = this.getFile(0);
            if (f != null) {
                Notepad.this.graph.Load(f);
            }
        }

        File getFile(int mode) {
            Frame frame = Notepad.this.getFrame();
            if (Notepad.this.fileDialog == null) {
                Notepad.this.fileDialog = new FileDialog(frame);
            }
            Notepad.this.fileDialog.setMode(mode);
            Notepad.this.fileDialog.setFilenameFilter(new FileFilter(".met"));
            Notepad.this.fileDialog.show();
            String file = Notepad.this.fileDialog.getFile();
            if (file == null) {
                return null;
            }
            String directory = Notepad.this.fileDialog.getDirectory();
            File f = new File(directory, file);
            return f;
        }
    }

    class FileFilter
    implements FilenameFilter {
        String ext = null;

        public FileFilter(String _e) {
            this.ext = _e;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.ext);
        }
    }

    class SaveAction
    extends OpenAction {
        SaveAction() {
            super(Notepad.saveAction);
        }

        public void actionPerformed(ActionEvent e) {
            File f = Notepad.this.graph.CurrentFile;
            if (f == null) {
                f = this.getFile(1);
            }
            if (f != null) {
                Notepad.this.graph.Save(f);
            }
        }
    }

    class SaveAsAction
    extends OpenAction {
        SaveAsAction() {
            super(Notepad.saveAsAction);
        }

        public void actionPerformed(ActionEvent e) {
            File f = this.getFile(1);
            if (f != null) {
                Notepad.this.graph.Save(f);
            }
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super(Notepad.newAction);
        }

        NewAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            Notepad.this.graph.Next();
        }
    }

    class AdjustAction
    extends AbstractAction {
        AdjustAction() {
            super(Notepad.adjustAction);
        }

        AdjustAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            Notepad.this.graph.Adjust();
            Notepad.this.graph.repaint();
            Notepad.this.graph.revalidate();
        }
    }

    class CompactAction
    extends AbstractAction {
        CompactAction() {
            super(Notepad.compactAction);
        }

        CompactAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            Notepad.this.graph.Compact();
            Notepad.this.graph.repaint();
            Notepad.this.graph.revalidate();
        }
    }

    class RelaxAction
    extends AbstractAction {
        RelaxAction() {
            super(Notepad.relaxAction);
        }

        RelaxAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            Notepad.this.graph.initRelax();
            Notepad.this.graph.repaint();
            Notepad.this.graph.revalidate();
        }
    }

    class ClearAction
    extends AbstractAction {
        ClearAction() {
            super(Notepad.clearAction);
        }

        ClearAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            Notepad.this.graph.rmGraph();
            Notepad.this.graph.repaint();
            Notepad.this.graph.revalidate();
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(Notepad.exitAction);
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    class ShowElementTreeAction
    extends AbstractAction {
        ShowElementTreeAction() {
            super(Notepad.showElementTreeAction);
        }

        ShowElementTreeAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            Frame frame = Notepad.this.getFrame();
            JDialog dial = new JDialog(frame, "Enter EC number to start with:");
            dial.show();
        }
    }

    class FileLoader
    extends Thread {
        Document doc;
        File f;

        FileLoader(File f, Document doc) {
            this.setPriority(4);
            this.f = f;
            this.doc = doc;
        }

        static /* synthetic */ Notepad access$0(FileLoader $0) {
            return $0.Notepad.this;
        }

        public void run() {
            try {
                int nch;
                Notepad.this.status.removeAll();
                JProgressBar progress = new JProgressBar();
                progress.setMinimum(0);
                progress.setMaximum((int)this.f.length());
                Notepad.this.status.add(progress);
                Notepad.this.status.revalidate();
                FileReader in = new FileReader(this.f);
                char[] buff = new char[4096];
                while ((nch = ((Reader)in).read(buff, 0, buff.length)) != -1) {
                    this.doc.insertString(this.doc.getLength(), new String(buff, 0, nch), null);
                    progress.setValue(progress.getValue() + nch);
                }
                this.doc.addUndoableEditListener(Notepad.this.undoHandler);
                Notepad.this.status.removeAll();
                Notepad.this.status.revalidate();
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
            catch (BadLocationException e) {
                System.err.println(e.getMessage());
            }
            if (Notepad.this.elementTreePanel != null) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ FileLoader this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        FileLoader.access$0((FileLoader)this.this$1).elementTreePanel.setEditor(FileLoader.access$0(this.this$1).getEditor());
                    }
                });
            }
        }
    }
}

