//----------------------------------------------------------
#ifndef FrmSetupH
#define FrmSetupH
//----------------------------------------------------------
#include <d3drmwin.h>
#include <vcl\SysUtils.hpp>
#include <vcl\Windows.hpp>
#include <vcl\Messages.hpp>
#include <vcl\Classes.hpp>
#include <vcl\Graphics.hpp>
#include <vcl\Controls.hpp>
#include <vcl\StdCtrls.hpp>
#include <vcl\ExtCtrls.hpp>
#include <vcl\Forms.hpp>
#include <vcl\ComCtrls.hpp>
#include <vcl\Buttons.hpp>
#include "D3dVCs.h"
//----------------------------------------------------------
class TSetupForm : public TForm
{
__published:
  TPageControl *PageControl;
  TTabSheet *tsRMDevice;
  TTabSheet *tsRMViewports;
  TTabSheet *tsRenderState;
  TLabel *laBufferCount;
  TLabel *laBufs;
  TLabel *laColorModel;
  TCheckBox *cbDither;
  TRadioButton *rbMono;
  TRadioButton *rbRGB;
  TLabel *laWidth1;
  TLabel *laWidth;
  TLabel *laHeight1;
  TLabel *laHeight;
  TLabel *laVports1;
  TLabel *laVports;
  TLabel *laWireframeOptions;
  TCheckBox *cbCull;
  TCheckBox *cbHide;
  TLabel *laTrianglesDrawn;
  TLabel *laTrigs;
  TLabel *laShadeMode;
  TLabel *laLightMode;
  TLabel *laFillMode;
  TComboBox *ShadeCombo;
  TComboBox *LightCombo;
  TComboBox *FillCombo;
  TLabel *laQuality;
  TComboBox *QualityCombo;
  TLabel *laTexture;
  TComboBox *TextureCombo;
  TLabel *laShades;
  TLabel *laShd;
  TUpDown *udShades;
  TLabel *laVWidth1;
  TLabel *laVWidth;
  TLabel *laVHeight1;
  TLabel *laVHeight;
  TLabel *laXOffset1;
  TLabel *laXOffset;
  TLabel *laYOffset1;
  TLabel *laYOffset;
  TLabel *laBack;
  TLabel *laFront;
  TLabel *laPlane;
  TLabel *laField;
  TEdit *edBack;
  TEdit *edFront;
  TEdit *edField;
  TCheckBox *cbScale;
  TLabel *laProjection;
  TRadioButton *rbPerspective;
  TRadioButton *rbOrthographic;
  TLabel *laViewport;
  TListBox *lbVports;
  TEdit *edLeft;
  TEdit *edRight;
  TEdit *edBottom;
  TEdit *edTop;
  TLabel *laLeft;
  TLabel *laRight;
  TLabel *laBottom;
  TLabel *laTop;
  TBitBtn *btnOk;
  TBitBtn *btnSave;
  TBitBtn *btnCancel;
  TTabSheet *tsDrivers;
  TListBox *lbDrivers;
  TMemo *DriversMemo;
  TBevel *Bevel1;
  TComboBox *RSTypeCombo;
  TComboBox *RSValCombo;
  TListBox *lbRS;
  TButton *btnAdd;
  TButton *btnDelete;
  TButton *btnExec;
  TBevel *Bevel2;
  void __fastcall cbDitherClick(TObject *Sender);
  void __fastcall udShadesClick(TObject *Sender, TUDBtnType Button);
  void __fastcall ShadeComboClick(TObject *Sender);
  void __fastcall LightComboClick(TObject *Sender);
  void __fastcall FillComboClick(TObject *Sender);
  void __fastcall QualityComboClick(TObject *Sender);
  void __fastcall TextureComboClick(TObject *Sender);
  void __fastcall FormActivate(TObject *Sender);
  void __fastcall AnyVportClick(TObject *Sender);
  void __fastcall lbVportsClick(TObject *Sender);
  void __fastcall VPortKeyPress(TObject *Sender, char &Key);
  void __fastcall AnyPlaneKeyPress(TObject *Sender, char &Key);
  void __fastcall btnOkClick(TObject *Sender);
  void __fastcall btnSaveClick(TObject *Sender);
  void __fastcall btnCancelClick(TObject *Sender);
  void __fastcall lbDriversClick(TObject *Sender);
  void __fastcall lbDriversDblClick(TObject *Sender);
  void __fastcall FormHide(TObject *Sender);
  void __fastcall RSTypeComboClick(TObject *Sender);
  void __fastcall btnAddClick(TObject *Sender);
  void __fastcall btnDeleteClick(TObject *Sender);
  void __fastcall btnExecClick(TObject *Sender);
  void __fastcall lbDriversKeyDown(TObject *Sender,
  WORD &Key, TShiftState Shift);
private:
  bool IsDeriving;
  BOOL SavedDither;
  DWORD SavedShades;
  TList *SavedVports;

  LPDIRECT3DRM IRM;
  LPDIRECT3DDEVICE  IDev;
  LPDIRECT3DRMDEVICE IRMDev;
  LPDIRECT3DRMVIEWPORT IVport;
  D3DDEVICEDESC DevDescription;
  D3DRMTEXTUREQUALITY TexQuality;
  D3DRMRENDERQUALITY SavedQuality;
  void __fastcall Refresh();
  void __fastcall GetTheRMDevice();
  void __fastcall GetAllSettings();
  void __fastcall GetVports();
  void __fastcall GetVportSettings();
  void __fastcall GetDeviceCaps();
  void __fastcall GetDriversInfo();
  void __fastcall TempSave();
  void __fastcall ClearSavedVports();
  void __fastcall RestoreSettings();
  void __fastcall Modified();
  void __fastcall Start();
  void __fastcall Clear();
public:
  TD3dView* D3dView;
  virtual __fastcall TSetupForm(TComponent *Owner);
  virtual __fastcall ~TSetupForm();
  void __fastcall SaveToIni();
  void __fastcall LoadFromIni();
};
//----------------------------------------------------------
extern TSetupForm *SetupForm;
//----------------------------------------------------------
#endif
