// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FIBQuery.pas' rev: 5.00

#ifndef FIBQueryHPP
#define FIBQueryHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <pFIBArray.hpp>	// Pascal unit
#include <pFIBProps.hpp>	// Pascal unit
#include <IB_ErrorCodes.hpp>	// Pascal unit
#include <StdFuncs.hpp>	// Pascal unit
#include <FIBDatabase.hpp>	// Pascal unit
#include <fib.hpp>	// Pascal unit
#include <Db.hpp>	// Pascal unit
#include <IB_Externals.hpp>	// Pascal unit
#include <IB_Intf.hpp>	// Pascal unit
#include <ibase.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Fibquery
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TTypeSetToParam { tspNull, tspIsNullable, tspScale, tspValue, tspSqlVar };
#pragma option pop

class DELPHICLASS TFIBXSQLVAR;
class DELPHICLASS TFIBQuery;
#pragma option push -b-
enum TBatchOperation { boInput, boOutput, boOutputToQuery };
#pragma option pop

#pragma option push -b-
enum TBatchAction { baContinue, baStop, baSkip };
#pragma option pop

typedef void __fastcall (__closure *TOnBatching)(TBatchOperation BatchOperation, int RecNumber, TBatchAction 
	&BatchAction);

class DELPHICLASS TFIBXSQLDA;
class PASCALIMPLEMENTATION TFIBXSQLVAR : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	bool __fastcall GetAsBoolean(void);
	void __fastcall SetAsBoolean(const bool Value);
	
protected:
	int FIndex;
	bool FModified;
	AnsiString FName;
	TFIBQuery* FQuery;
	Variant FVariantFalse;
	Variant FVariantTrue;
	Ibase::TXSQLVAR *FXSQLVAR;
	TFIBXSQLDA* FParent;
	bool FIsMacro;
	bool FQuoted;
	Variant FOldValue;
	AnsiString FDefMacroValue;
	int FSrvSQlType;
	Pfibarray::TpFIBArray* vFIBArray;
	double __fastcall AdjustScale(System::Comp Value, int Scale);
	System::Currency __fastcall AdjustScaleToCurrency(System::Comp Value, int Scale);
	__int64 __fastcall AdjustScaleToInt64(__int64 Value, int Scale);
	__int64 __fastcall GetAsInt64(void);
	System::Currency __fastcall GetAsCurrency(void);
	System::Comp __fastcall GetAsComp(void);
	System::TDateTime __fastcall GetAsDateTime(void);
	Sysutils::TTimeStamp __fastcall GetAsTimeStamp(void);
	double __fastcall GetAsDouble(void);
	double __fastcall GetAsFloat(void);
	float __fastcall GetAsSingle(void);
	int __fastcall GetAsLong(void);
	void * __fastcall GetAsPointer(void);
	Ibase::TGDS_QUAD __fastcall GetAsQuad(void);
	short __fastcall GetAsShort(void);
	AnsiString __fastcall GetAsString(void);
	Variant __fastcall GetAsVariant(void);
	Extended __fastcall GetAsExtended(void);
	Ibase::PXSQLVAR __fastcall GetAsXSQLVAR(void);
	bool __fastcall GetIsNull(void);
	bool __fastcall GetIsNullable(void);
	int __fastcall GetSize(void);
	int __fastcall GetSQLType(void);
	int __fastcall GetServerSQLType(void);
	void __fastcall CheckArrayType(void);
	int __fastcall GetDimensionCount(void);
	Ibase::TISC_ARRAY_BOUND __fastcall GetDimension(int Index);
	int __fastcall GetSliceSize(void);
	Db::TFieldType __fastcall GetElementType(void);
	int __fastcall GetArraySize(void);
	void __fastcall SetValue(int aSQLType, int aSize, TTypeSetToParam ValueType, const void *aValue);
	void __fastcall SetAsCurrency(System::Currency aValue);
	void __fastcall SetAsComp(System::Comp aValue);
	void __fastcall SetAsInt64(__int64 aValue);
	void __fastcall SetAsDateTime(System::TDateTime aValue);
	void __fastcall SetAsTime(System::TDateTime aValue);
	void __fastcall SetAsDate(System::TDateTime aValue);
	void __fastcall SetAsTimeStamp(const Sysutils::TTimeStamp &aValue);
	void __fastcall SetAsDouble(double aValue);
	void __fastcall SetAsFloat(double aValue);
	void __fastcall SetAsSingle(float aValue);
	void __fastcall SetAsExtended(Extended aValue);
	void __fastcall SetAsLong(int aValue);
	void __fastcall SetAsQuad(const Ibase::TGDS_QUAD &aValue);
	void __fastcall SetAsShort(short aValue);
	void __fastcall SetAsString(const AnsiString aValue);
	void __fastcall SetAsVariant(const Variant &Value);
	void __fastcall SetAsXSQLVAR(Ibase::PXSQLVAR aValue);
	void __fastcall SetIsNull(bool aValue);
	void __fastcall SetIsNullable(bool aValue);
	int __fastcall GetScale(void);
	void __fastcall SetScale(int Value);
	Db::TBcd __fastcall GetAsBcd(void);
	void __fastcall SetAsBcd(const Db::TBcd &Value);
	
public:
	__fastcall TFIBXSQLVAR(TFIBXSQLDA* AParent);
	__fastcall virtual ~TFIBXSQLVAR(void);
	void __fastcall Assign(TFIBXSQLVAR* Source);
	bool __fastcall IsNumericType(int SQLType);
	bool __fastcall IsDateTimeType(int SQLType);
	void __fastcall LoadFromFile(const AnsiString FileName);
	void __fastcall LoadFromStream(Classes::TStream* Stream);
	void __fastcall SaveToFile(const AnsiString FileName);
	void __fastcall SaveToStream(Classes::TStream* Stream);
	void __fastcall Clear(void);
	Variant __fastcall GetArrayElement(const int * Indexes, const int Indexes_Size);
	Variant __fastcall GetArrayValues(void);
	void __fastcall SetArrayValue(const Variant &Value);
	bool __fastcall IsDefMacroValue(void);
	void __fastcall SetDefMacroValue(void);
	__property System::Currency AsCurrency = {read=GetAsCurrency, write=SetAsCurrency};
	__property System::Comp AsComp = {read=GetAsComp, write=SetAsComp};
	__property Extended AsExtended = {read=GetAsExtended, write=SetAsExtended};
	__property __int64 AsInt64 = {read=GetAsInt64, write=SetAsInt64};
	__property Db::TBcd AsBcd = {read=GetAsBcd, write=SetAsBcd};
	__property System::TDateTime AsDateTime = {read=GetAsDateTime, write=SetAsDateTime};
	__property System::TDateTime AsDate = {read=GetAsDateTime, write=SetAsDate};
	__property System::TDateTime AsTime = {read=GetAsDateTime, write=SetAsTime};
	__property Sysutils::TTimeStamp AsTimeStamp = {read=GetAsTimeStamp, write=SetAsTimeStamp};
	__property double AsDouble = {read=GetAsDouble, write=SetAsDouble};
	__property double AsFloat = {read=GetAsFloat, write=SetAsFloat};
	__property float AsSingle = {read=GetAsSingle, write=SetAsSingle};
	__property int AsInteger = {read=GetAsLong, write=SetAsLong, nodefault};
	__property int AsLong = {read=GetAsLong, write=SetAsLong, nodefault};
	__property void * AsPointer = {read=GetAsPointer};
	__property Ibase::TGDS_QUAD AsQuad = {read=GetAsQuad, write=SetAsQuad};
	__property short AsShort = {read=GetAsShort, write=SetAsShort, nodefault};
	__property AnsiString AsString = {read=GetAsString, write=SetAsString};
	__property Variant AsVariant = {read=GetAsVariant, write=SetAsVariant};
	__property Ibase::PXSQLVAR AsXSQLVAR = {read=GetAsXSQLVAR, write=SetAsXSQLVAR};
	__property bool AsBoolean = {read=GetAsBoolean, write=SetAsBoolean, nodefault};
	__property Ibase::PXSQLVAR Data = {read=FXSQLVAR, write=FXSQLVAR};
	__property bool IsNull = {read=GetIsNull, write=SetIsNull, nodefault};
	__property bool IsNullable = {read=GetIsNullable, write=SetIsNullable, nodefault};
	__property int Scale = {read=GetScale, write=SetScale, nodefault};
	__property int Index = {read=FIndex, nodefault};
	__property bool Modified = {read=FModified, write=FModified, nodefault};
	__property AnsiString Name = {read=FName};
	__property int Size = {read=GetSize, nodefault};
	__property int SQLType = {read=GetSQLType, nodefault};
	__property int ServerSQLType = {read=GetServerSQLType, nodefault};
	__property Variant Value = {read=GetAsVariant, write=SetAsVariant};
	__property Variant OldValue = {read=FOldValue};
	__property Variant VariantFalse = {read=FVariantFalse, write=FVariantFalse};
	__property Variant VariantTrue = {read=FVariantTrue, write=FVariantTrue};
	__property bool IsMacro = {read=FIsMacro, write=FIsMacro, nodefault};
	__property bool Quoted = {read=FQuoted, write=FQuoted, nodefault};
	__property AnsiString DefMacroValue = {read=FDefMacroValue, write=FDefMacroValue};
	__property Pfibarray::TpFIBArray* FIBArray = {read=vFIBArray};
	__property int DimensionCount = {read=GetDimensionCount, nodefault};
	__property Ibase::TISC_ARRAY_BOUND Dimension[int Index] = {read=GetDimension};
	__property Db::TFieldType ElementType = {read=GetElementType, nodefault};
	__property int ArraySize = {read=GetArraySize, nodefault};
};


typedef TFIBXSQLVAR* TFIBXSQLVARArray[1];

typedef TFIBXSQLVAR* *PFIBXSQLVARArray;

class PASCALIMPLEMENTATION TFIBXSQLDA : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TStringList* FEquelNames;
	Classes::TStringList* FCachedNames;
	int FCount;
	
protected:
	Classes::TStringList* FNames;
	TFIBQuery* FQuery;
	int FSize;
	Ibase::TXSQLDA *FXSQLDA;
	TFIBXSQLVAR* *FXSQLVARs;
	bool FIsParams;
	bool __fastcall GetModified(void);
	AnsiString __fastcall GetNames(void);
	int __fastcall GetRecordSize(void);
	Ibase::PXSQLDA __fastcall GetXSQLDA(void);
	TFIBXSQLVAR* __fastcall GetXSQLVAR(int Idx);
	TFIBXSQLVAR* __fastcall GetXSQLVARByName(const AnsiString Idx);
	void __fastcall Initialize(void);
	void __fastcall SetCount(int Value);
	void __fastcall AddName(const AnsiString FieldName, int Idx);
	void __fastcall SetUnModifiedToVars(void);
	void __fastcall Clear(void);
	
public:
	__fastcall TFIBXSQLDA(bool aIsParams);
	__fastcall virtual ~TFIBXSQLDA(void);
	TFIBXSQLVAR* __fastcall FindParam(const AnsiString aParamName);
	TFIBXSQLVAR* __fastcall ParamByName(const AnsiString aParamName);
	__property Ibase::PXSQLDA AsXSQLDA = {read=GetXSQLDA};
	__property TFIBXSQLVAR* ByName[AnsiString Idx] = {read=GetXSQLVARByName};
	__property int Count = {read=FCount, write=SetCount, nodefault};
	__property bool Modified = {read=GetModified, nodefault};
	__property AnsiString Names = {read=GetNames};
	__property int RecordSize = {read=GetRecordSize, nodefault};
	__property TFIBXSQLVAR* Vars[int Idx] = {read=GetXSQLVAR/*, default*/};
};


#pragma option push -b-
enum TFIBSQLTypes { SQLUnknown, SQLSelect, SQLInsert, SQLUpdate, SQLDelete, SQLDDL, SQLGetSegment, SQLPutSegment, 
	SQLExecProcedure, SQLStartTransaction, SQLCommit, SQLRollback, SQLSelectForUpdate, SQLSetGenerator 
	};
#pragma option pop

typedef void __fastcall (__closure *TOnSQLFetch)(int RecordNumber, bool &StopFetching);

#pragma option push -b-
enum TBatchErrorAction { beFail, beAbort, beRetry, beIgnore };
#pragma option pop

typedef void __fastcall (__closure *TOnBatchError)(Fib::EFIBError* E, TBatchErrorAction &BatchErrorAction
	);

class DELPHICLASS TFIBBatchInputStream;
class DELPHICLASS TFIBBatchOutputStream;
class PASCALIMPLEMENTATION TFIBQuery : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TOnBatching FOnBatching;
	
protected:
	Fibdatabase::TFIBBase* FBase;
	bool FBOF;
	bool FEof;
	bool FGoToFirstRecordOnExecute;
	bool FOpen;
	bool FPrepared;
	int FRecordCount;
	void * *FHandle;
	Classes::TNotifyEvent FOnSQLChanging;
	Classes::TStrings* FSQL;
	bool FParamCheck;
	Classes::TStrings* FProcessedSQL;
	TFIBXSQLDA* FSQLParams;
	TFIBXSQLDA* FSQLRecord;
	TFIBSQLTypes FSQLType;
	TFIBXSQLDA* FUserSQLParams;
	bool FProcExecuted;
	TOnSQLFetch FOnSQLFetch;
	char FMacroChar;
	AnsiString vNormalizedText;
	bool vUserParamsCreated;
	int FCountLockSQL;
	AnsiString FModifyTable;
	Pfibprops::TpFIBQueryOptions FOptions;
	bool vDiffParams;
	Classes::TStringList* FOnlySrvParams;
	unsigned FCallTime;
	bool FMacroChanged;
	bool FAutoCloseOnTransactionEnd;
	bool FWhereExist;
	AnsiString __fastcall GetModifyTable(void);
	void __fastcall DatabaseDisconnecting(System::TObject* Sender);
	Fibdatabase::TFIBDatabase* __fastcall GetDatabase(void);
	Ibase::PISC_DB_HANDLE __fastcall GetDBHandle(void);
	bool __fastcall GetEOF(void);
	TFIBXSQLVAR* __fastcall GetFieldByName(AnsiString FieldName);
	TFIBXSQLVAR* __fastcall GetFields(const int Idx);
	int __fastcall GetFieldIndex(AnsiString FieldName);
	AnsiString __fastcall GetPlan(void);
	int __fastcall GetRecordCount(void);
	int __fastcall GetRowsAffected(void);
	TFIBXSQLDA* __fastcall GetSQLParams(void);
	Fibdatabase::TFIBTransaction* __fastcall GetTransaction(void);
	Ibase::PISC_TR_HANDLE __fastcall GetTRHandle(void);
	void __fastcall PreprocessSQL(const AnsiString SQLText, bool IsUserSQL);
	void __fastcall SetDatabase(Fibdatabase::TFIBDatabase* Value);
	void __fastcall SetSQL(Classes::TStrings* Value);
	void __fastcall SetMacroChar(char Value);
	void __fastcall SetTransaction(Fibdatabase::TFIBTransaction* Value);
	void __fastcall SQLChanging(System::TObject* Sender);
	void __fastcall SQLChange(System::TObject* Sender);
	void __fastcall TransactionEnding(System::TObject* Sender);
	void __fastcall SynchronizeParams(void);
	void __fastcall SaveOldParamValues(bool UserParams);
	void __fastcall RestoreOldParamValues(bool UserParams);
	AnsiString __fastcall SetMacro(const AnsiString SQLText);
	bool __fastcall ParamsNotExist(const AnsiString SQLText);
	AnsiString __fastcall OK_SQLText(void);
	AnsiString __fastcall GetWhereClause(int Index);
	void __fastcall SetWhereClause(int Index, const AnsiString WhereClauseTxt);
	AnsiString __fastcall GetOrderString(void);
	void __fastcall SetOrderString(const AnsiString OrderTxt);
	void __fastcall PrepareUserParamsTypes(void);
	void __fastcall StartStatistic(const AnsiString stText);
	void __fastcall EndStatistic(const AnsiString stText);
	void __fastcall ReadQueryStartTransaction(Classes::TReader* Reader);
	void __fastcall WriteQueryStartTransaction(Classes::TWriter* Writer);
	void __fastcall ReadQueryAutoCommit(Classes::TReader* Reader);
	void __fastcall WriteQueryAutoCommit(Classes::TWriter* Writer);
	void __fastcall ReadQueryTrimChar(Classes::TReader* Reader);
	void __fastcall WriteQueryTrimChar(Classes::TWriter* Writer);
	void __fastcall ReadQueryNoForceIsNull(Classes::TReader* Reader);
	void __fastcall WriteQueryNoForceIsNull(Classes::TWriter* Writer);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	
public:
	__fastcall virtual TFIBQuery(Classes::TComponent* AOwner);
	__fastcall virtual ~TFIBQuery(void);
	virtual void __fastcall Loaded(void);
	
private:
	TOnBatchError FOnBatchError;
	
public:
	bool __fastcall BatchInput(TFIBBatchInputStream* InputObject);
	bool __fastcall BatchOutput(TFIBBatchOutputStream* OutputObject);
	void __fastcall BatchInputRawFile(const AnsiString FileName);
	void __fastcall BatchOutputRawFile(const AnsiString FileName);
	void __fastcall BatchToQuery(TFIBQuery* ToQuery, Classes::TStrings* Mappings);
	int __fastcall Call(int ErrCode, bool RaiseError);
	void __fastcall CheckClosed(const AnsiString OpName);
	void __fastcall CheckOpen(const AnsiString OpName);
	void __fastcall CheckValidStatement(void);
	void __fastcall Close(void);
	TFIBXSQLDA* __fastcall Current(void);
	virtual void __fastcall ExecQuery(void);
	void __fastcall FreeHandle(void);
	TFIBXSQLDA* __fastcall Next(void);
	void __fastcall Prepare(void);
	void __fastcall PrepareArrayFields(void);
	void __fastcall PrepareArraySqlVar(TFIBXSQLVAR* SqlVar, const AnsiString RelName, const AnsiString 
		SQLName, bool IsField);
	void __fastcall SetParamValues(const Variant * ParamValues, const int ParamValues_Size);
	void __fastcall ExecWP(const Variant * ParamValues, const int ParamValues_Size);
	void __fastcall BeginModifySQLText(void);
	void __fastcall EndModifySQLText(void);
	int __fastcall CountModifySQLText(void);
	int __fastcall GetMainWhereIndex(void);
	AnsiString __fastcall GetMainWhereClause(void);
	void __fastcall SetMainWhereClause(const AnsiString Value);
	bool __fastcall IsProc(void);
	TFIBXSQLVAR* __fastcall ParamByName(const AnsiString ParamName);
	TFIBXSQLVAR* __fastcall FindParam(const AnsiString aParamName);
	void __fastcall ApplyMacro(void);
	int __fastcall FieldCount(void);
	__property bool Bof = {read=FBOF, nodefault};
	__property Ibase::PISC_DB_HANDLE DBHandle = {read=GetDBHandle};
	__property bool Eof = {read=GetEOF, nodefault};
	__property TFIBXSQLVAR* FieldByName[AnsiString FieldName] = {read=GetFieldByName/*, default*/};
	__property TFIBXSQLVAR* Fields[int Idx] = {read=GetFields};
	__property int FieldIndex[AnsiString FieldName] = {read=GetFieldIndex};
	__property bool Open = {read=FOpen, nodefault};
	__property TFIBXSQLDA* Params = {read=GetSQLParams};
	__property AnsiString Plan = {read=GetPlan};
	__property bool Prepared = {read=FPrepared, nodefault};
	__property int RecordCount = {read=GetRecordCount, nodefault};
	__property int RowsAffected = {read=GetRowsAffected, nodefault};
	__property TFIBSQLTypes SQLType = {read=FSQLType, nodefault};
	__property Ibase::PISC_TR_HANDLE TRHandle = {read=GetTRHandle};
	__property bool ProcExecuted = {read=FProcExecuted, write=FProcExecuted, nodefault};
	__property TOnSQLFetch OnSQLFetch = {read=FOnSQLFetch, write=FOnSQLFetch};
	__property Classes::TStringList* OnlySrvParams = {read=FOnlySrvParams};
	
protected:
	Pfibprops::TConditions* FConditions;
	void __fastcall SetConditions(Pfibprops::TConditions* Value);
	
__published:
	__property Pfibprops::TConditions* Conditions = {read=FConditions, write=SetConditions};
	
public:
	int __fastcall WhereClausesCount(void);
	__property AnsiString WhereClause[int Index] = {read=GetWhereClause, write=SetWhereClause};
	__property AnsiString MainWhereClause = {read=GetMainWhereClause, write=SetMainWhereClause};
	__property int IndexMainWhere = {read=GetMainWhereIndex, nodefault};
	__property AnsiString OrderClause = {read=GetOrderString, write=SetOrderString};
	__property AnsiString ModifyTable = {read=GetModifyTable};
	__property unsigned CallTime = {read=FCallTime, nodefault};
	__property bool MacroChanged = {read=FMacroChanged, nodefault};
	__property AnsiString NormalizedSQL = {read=vNormalizedText};
	
__published:
	__property Fibdatabase::TFIBDatabase* Database = {read=GetDatabase, write=SetDatabase};
	__property bool GoToFirstRecordOnExecute = {read=FGoToFirstRecordOnExecute, write=FGoToFirstRecordOnExecute
		, default=1};
	__property bool ParamCheck = {read=FParamCheck, write=FParamCheck, nodefault};
	__property Classes::TStrings* SQL = {read=FSQL, write=SetSQL};
	__property Fibdatabase::TFIBTransaction* Transaction = {read=GetTransaction, write=SetTransaction};
		
	__property Classes::TNotifyEvent OnSQLChanging = {read=FOnSQLChanging, write=FOnSQLChanging};
	__property Pfibprops::TpFIBQueryOptions Options = {read=FOptions, write=FOptions, stored=false, nodefault
		};
	__property TOnBatching OnBatching = {read=FOnBatching, write=FOnBatching};
	__property TOnBatchError OnBatchError = {read=FOnBatchError, write=FOnBatchError};
};



#pragma option push -b-
enum TBatchState { bsNotPrepared, bsFileReady, bsInProcess, bsInError };
#pragma option pop

class DELPHICLASS TFIBBatch;
class PASCALIMPLEMENTATION TFIBBatch : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	AnsiString FFilename;
	TFIBXSQLDA* FColumns;
	TFIBXSQLDA* FParams;
	TBatchState FState;
	
public:
	__fastcall TFIBBatch(void);
	virtual void __fastcall ReadyStream(void) = 0 ;
	__property TFIBXSQLDA* Columns = {read=FColumns};
	__property AnsiString Filename = {read=FFilename, write=FFilename};
	__property TFIBXSQLDA* Params = {read=FParams};
	__property TBatchState State = {read=FState, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TFIBBatch(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TFIBBatchInputStream : public TFIBBatch 
{
	typedef TFIBBatch inherited;
	
public:
	virtual bool __fastcall ReadParameters(void) = 0 ;
public:
	#pragma option push -w-inl
	/* TFIBBatch.Create */ inline __fastcall TFIBBatchInputStream(void) : TFIBBatch() { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TFIBBatchInputStream(void) { }
	#pragma option pop
	
};


typedef TMetaClass*TFIBBatchInputStreamClass;

class PASCALIMPLEMENTATION TFIBBatchOutputStream : public TFIBBatch 
{
	typedef TFIBBatch inherited;
	
public:
	virtual bool __fastcall WriteColumns(void) = 0 ;
public:
	#pragma option push -w-inl
	/* TFIBBatch.Create */ inline __fastcall TFIBBatchOutputStream(void) : TFIBBatch() { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TFIBBatchOutputStream(void) { }
	#pragma option pop
	
};


typedef TMetaClass*TFIBBatchOutputStreamClass;

//-- var, const, procedure ---------------------------------------------------
#define ExecProcPrefix "EXECUTE "
#define scExecuteCount "ExecuteCount"
#define scSumTimeExecute "SumTimeExecute"
#define scAvgTimeExecute "AvgTimeExecute"
#define scMaxTimeExecute "MaxTimeExecute"
#define scLastTimeExecute "LastTimeExecute"
#define scLastQuery "LastQueryName"

}	/* namespace Fibquery */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Fibquery;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// FIBQuery
