// KEHOME/java/mkrGetResource.java
// Aug/26/2003
// usage: java -DKBDATA=kbdata mkrGetResource genus name

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Client;
import edu.stanford.TAP.Resource;
import edu.stanford.TAP.XML;

/**
*	Get resource with genus, name
*/
public class mkrGetResource
{
    public static void main(String argv[])
    {
	String info   = "# INFO: mkrGetResource: ";
	String debug  = "no";
	String flags  = "";

	String kbdata = System.getProperty("KBDATA");
	String genus  = argv[0];
	String name   = argv[1];

	if (debug == "yes") {
	  System.out.println(info + "kbdata = " + kbdata);
	  System.out.println(info + "genus = "  + genus);
	  System.out.println(info + "name = "   + name);
	  System.out.println(info + "flags = "  + flags);
	}

	Client tap = new Client(kbdata);
	Resource answer = get_resource(tap,genus,name);

	if (answer.count() == 0) {
		System.out.println("  " + info + "count = " + answer.count());
	} else {
		print_column(answer);
	}
	return;
    } // end main()

/**
*	print one answer per line
*/
    public static void print_column(Resource answer)
    {
	for(int x = 0; x < answer.count(); ++x) {
	    System.out.println("  " + answer.item(x).value);
	}
    } // end print_column()

/**
*	MKE interface to TAP GetResourceNamed()
*/
    public static Resource get_resource(
	Client tap,
	String genus,
	String name
    )
    {
	String info   = "# INFO: get_resource: ";
	String debug  = "no";
	String flags  = "";

	String kbdata = System.getProperty("KBDATA");

	Abbrev.LoadNamespaces("namespaces.txt");
	String uriGenus = Qname.GetNameURI(genus);

	if (debug == "yes") {
	  System.out.println(info + " uriGenus = " + uriGenus);
	  System.out.println(info + " name = "     + name);
	  System.out.println(info + " flags = "    + flags);
	}

	//if () {
		//Resource answer = tap.GetResourcesNamed(name);
	//} else {
		Resource resource = new Resource(uriGenus);
		Resource answer = tap.GetResourcesNamed(name,resource);
	//}

	for(int x = 0; x < answer.count(); ++x) {
	    String tapAnswer = answer.item(x).value;
	    String mkrAnswer = XML.SplitNamespace(tapAnswer).tag;
	    answer.item(x).value = mkrAnswer;
	}
	return answer;
    } // end get_resource()

} // end class

